/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.List;
import kickass.nonasm.util.functions.Func3;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.IDirectiveParser;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class ExprBodyTailParser<NODE>
implements ITailParser<NODE> {
    private IDirectiveParser<NODE> subParser;
    private Func3<ExprNode, List<NODE>, SourceRange, NODE> nodeCreator;

    public ExprBodyTailParser(IDirectiveParser<NODE> iDirectiveParser, Func3<ExprNode, List<NODE>, SourceRange, NODE> func3) {
        this.subParser = iDirectiveParser;
        this.nodeCreator = func3;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlOrCurly();
        ExprNode exprNode = ExprParser.parse(tokenStreamList, evaluationState);
        if (exprNode == null) {
            return null;
        }
        IToken iToken2 = tokenStreamList.getTerminatingToken();
        if (iToken2.getType() != TokenType.CurlyBracketRange && (iToken2 = iTokenStream.expectTypeSkipWsAndNl(TokenType.CurlyBracketRange, evaluationState)) == null) {
            return null;
        }
        List<NODE> list = this.subParser.parseAll(iToken2.getChildStream(), evaluationState);
        return this.nodeCreator.apply(exprNode, list, sourceRange);
    }
}

