/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.segments.SegmentMemoryBlock;

public class MemoryBlockDirective
extends AsmDirective {
    private ExprNode startAddressExpr;
    private boolean isVirtual;
    private String name;
    private SegmentMemoryBlock block;
    boolean adressNotResolvedBefore = true;

    public MemoryBlockDirective(ExprNode exprNode, String string, Boolean bl, SourceRange sourceRange) {
        super(sourceRange);
        this.startAddressExpr = exprNode;
        this.isVirtual = bl;
        this.name = string == null ? "Unnamed" : string;
    }

    @Override
    public AsmNode copy() {
        return new MemoryBlockDirective(this.startAddressExpr, this.name, this.isVirtual, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.startAddressExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Value value;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        if (this.block == null) {
            this.block = evaluationState.segmentMgr.startMemoryBlock(this.name, this.range, this.isVirtual);
        }
        if ((value = this.startAddressExpr.evaluate(evaluationState)).isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n = value.getInt(this.range);
        if (n < 0) {
            throw new AsmErrorException("Memory address may not be negative!", this.range);
        }
        if (this.adressNotResolvedBefore) {
            evaluationState.setMadeMetaProgress();
            this.adressNotResolvedBefore = false;
        }
        evaluationState.segmentMgr.setMemoryPosition(n);
        this.block.setStart(n);
        if (evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

