/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.c64output;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.log.Logger;
import kickass.nonasm.tools.collections.OrderedMap;
import kickass.nonasm.tools.tuples.Pair;
import kickass.plugins.impl.PluginDiskData;
import kickass.plugins.impl.PluginEngine;
import kickass.plugins.impl.PluginFileData;
import kickass.plugins.impl.PluginMemoryBlock;
import kickass.plugins.impl.PluginParameterMap;
import kickass.plugins.interf.diskwriter.IDiskFileData;
import kickass.plugins.interf.diskwriter.IDiskWriter;
import kickass.plugins.interf.general.IEngine;
import kickass.plugins.interf.general.IMemoryBlock;
import kickass.plugins.std.disk.C1541DiskWriter;
import kickass.setup.configuration.parameters.KickAssemblerParameters;
import kickass.state.EvaluationState;
import kickass.state.c64output.C64File;
import kickass.state.c64output.C64FileType;
import kickass.state.c64output.D64Disk;
import kickass.state.c64output.D64File;
import kickass.state.miscoutput.DebugDumpWriter;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentManager;
import kickass.state.segments.SegmentMemoryBlock;

public class C64OutputManager {
    public String inputfileWithoutExt;
    public static IDiskWriter defaultDiskWriter = new C1541DiskWriter();
    private Map<String, IDiskWriter> diskWriters = new HashMap<String, IDiskWriter>();
    private Map<String, C64File> c64Files = new OrderedMap<String, C64File>();
    private List<D64Disk> d64Disks = new ArrayList<D64Disk>();
    private EvaluationState state;
    private String executeFileCandidate;

    public C64OutputManager(EvaluationState evaluationState) {
        this.state = evaluationState;
    }

    public String getExecuteFileCandidate() {
        return this.executeFileCandidate;
    }

    public IDiskWriter getDiskWriter(String string) {
        return this.diskWriters.get(string);
    }

    public boolean addDiskWriter(String string, IDiskWriter iDiskWriter) {
        if (this.diskWriters.containsKey(string)) {
            return false;
        }
        this.diskWriters.put(string, iDiskWriter);
        return true;
    }

    public boolean c64FileExist(String string) {
        return this.c64Files.containsKey(this.NormalizeFilename(string));
    }

    public C64File getC64File(String string) {
        return this.c64Files.get(this.NormalizeFilename(string));
    }

    public boolean addC64File(C64File c64File) {
        String string = this.NormalizeFilename(c64File.getFilename());
        c64File.setFilename(string);
        if (this.c64Files.containsKey(string)) {
            return false;
        }
        this.c64Files.put(c64File.getFilename(), c64File);
        return true;
    }

    public void addD64Disk(D64Disk d64Disk) {
        this.d64Disks.add(d64Disk);
    }

    public void postPassExecution() {
        boolean bl;
        KickAssemblerParameters kickAssemblerParameters = this.state.parameters;
        Logger logger = this.state.log;
        String string = null;
        String string2 = null;
        Object var5_5 = null;
        SegmentManager segmentManager = this.state.segmentMgr;
        Segment segment = segmentManager.defaultSegment;
        boolean bl2 = segmentManager.getSegments().size() == 1;
        boolean bl3 = !segment.isEmpty();
        boolean bl4 = bl = bl2 || bl3;
        if (bl) {
            if (this.c64FileExist(kickAssemblerParameters.outputfile)) {
                throw new AsmErrorException("Can't output default segment since a file called '" + kickAssemblerParameters.outputfile + "' already exist");
            }
            this.addC64File(new C64File(kickAssemblerParameters.outputfile, segment.getName()).setType(kickAssemblerParameters.binFile ? C64FileType.bin : C64FileType.prg).setMbFiles(kickAssemblerParameters.filesForEachMemBlock).setIsDefaultFile());
        }
        for (C64File object : this.c64Files.values()) {
            Segment segment2 = segmentManager.getSegment(object.getSegmentId());
            if (segment2 == null) {
                throw new AsmErrorException("Unknown source segment for file '" + object.getFilename() + "': " + object.getSegmentId());
            }
            if (!object.getMbFiles()) {
                if (object.isDefaultFile()) {
                    string = object.getFilename();
                }
                if (string2 == null) {
                    string2 = object.getFilename();
                }
                this.writeC64File(object.getFilename(), object.getType(), object.isDefaultFile(), segment2.getMinAddress(), segment2.flatten(false), logger);
                DebugDumpWriter.writePrg(object.getFilename(), this.state, object.isDefaultFile());
            }
            if (!object.getMbFiles()) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (SegmentMemoryBlock segmentMemoryBlock : segment2.getOutputMemoryBlocks()) {
                if (segmentMemoryBlock.isVirtual()) continue;
                ArrayList<SegmentMemoryBlock> arrayList = (ArrayList<SegmentMemoryBlock>)hashMap.get(segmentMemoryBlock.getName());
                if (arrayList == null) {
                    arrayList = new ArrayList<SegmentMemoryBlock>();
                    hashMap.put(segmentMemoryBlock.getName(), arrayList);
                }
                arrayList.add(segmentMemoryBlock);
            }
            String[] stringArray = new String[]{".bin", ".prg"};
            Pair<String, String> pair = C64OutputManager.findFilenameBaseAndPostfix(object.getFilename(), stringArray);
            for (String string3 : hashMap.keySet()) {
                Object object22;
                String string4 = pair.getA() + "_" + string3 + pair.getB();
                List list = (List)hashMap.get(string3);
                if (list.size() != 1) {
                    logger.warn("" + list.size() + " blocks have the name '" + string3 + "'. They will be merged in the same file.");
                }
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                for (Object object22 : list) {
                    n = Math.min(n, ((SegmentMemoryBlock)object22).getStart());
                    n2 = Math.max(n2, ((SegmentMemoryBlock)object22).getEnd());
                }
                Object object3 = new byte[n2 - n];
                Arrays.fill((byte[])object3, segment2.getFillByte());
                object22 = list.iterator();
                while (object22.hasNext()) {
                    SegmentMemoryBlock segmentMemoryBlock = (SegmentMemoryBlock)object22.next();
                    byte[] byArray = segmentMemoryBlock.getBytes();
                    int n3 = segmentMemoryBlock.getStart() - n;
                    int n4 = 0;
                    while (n4 < byArray.length) {
                        object3[n3++] = byArray[n4++];
                    }
                }
                this.writeC64File(string4, object.getType(), false, n, (byte[])object3, logger);
            }
        }
        for (D64Disk d64Disk : this.d64Disks) {
            this.writeD64Disk(d64Disk, logger);
        }
        if (string != null) {
            this.executeFileCandidate = string;
        } else if (var5_5 != null) {
            this.executeFileCandidate = var5_5;
        } else if (string2 != null) {
            this.executeFileCandidate = string2;
        }
    }

    private static Pair<String, String> findFilenameBaseAndPostfix(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.endsWith(string2)) continue;
            String string3 = string.substring(0, string.length() - string2.length());
            return new Pair<String, String>(string3, string2);
        }
        return new Pair<String, String>(string, "");
    }

    private void writeC64File(String string, C64FileType c64FileType, boolean bl, int n, byte[] byArray, Logger logger) {
        logger.println("Writing prg file: " + string);
        try {
            OutputStream outputStream = this.state.outputMgr.OpenOutputStream(string, !bl);
            if (c64FileType == C64FileType.prg) {
                byte by = (byte)(n & 0xFF);
                byte by2 = (byte)((n & 0xFF00) >> 8);
                outputStream.write(new byte[]{by, by2});
            }
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (AsmErrorException asmErrorException) {
            throw asmErrorException;
        }
        catch (Exception exception) {
            throw new AsmErrorException("Problem while writing file '" + string + "': " + exception.getMessage(), null);
        }
    }

    private void writeD64Disk(D64Disk d64Disk, Logger logger) {
        Object object;
        ArrayList<IDiskFileData> arrayList = new ArrayList<IDiskFileData>();
        for (D64File object22 : d64Disk.diskFiles) {
            object = new PluginParameterMap(object22.parameters);
            List<IMemoryBlock> list = PluginMemoryBlock.createList(object22.segment.getOutputMemoryBlocks());
            arrayList.add(new PluginFileData((PluginParameterMap)object, list));
        }
        PluginParameterMap pluginParameterMap = new PluginParameterMap(d64Disk.diskParameters);
        PluginDiskData pluginDiskData = new PluginDiskData(pluginParameterMap, arrayList);
        object = new PluginEngine(this.state, d64Disk.range);
        d64Disk.writer.execute(pluginDiskData, (IEngine)object);
    }

    public String NormalizeFilename(String string) {
        return string.replace("%o", this.inputfileWithoutExt);
    }
}

