/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.service.wight.annotation.processing;

import global.namespace.service.wight.annotation.ServiceImplementation;
import global.namespace.service.wight.annotation.ServiceInterface;
import global.namespace.service.wight.annotation.processing.ServiceAnnnotationProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"global.namespace.service.wight.annotation.ServiceImplementation"})
public final class ServiceImplementationProcessor
extends ServiceAnnnotationProcessor {
    private static final Comparator<TypeElement> TYPE_ELEMENT_COMPARATOR = Comparator.comparing(o -> o.getQualifiedName().toString());

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Registry registry = new Registry();
        for (Element element : roundEnv.getElementsAnnotatedWith(ServiceImplementation.class)) {
            if (element instanceof TypeElement) {
                TypeElement impl = (TypeElement)element;
                if (!this.valid(impl) || this.processAnnotations(impl, registry) || this.processTypeHierarchy(impl, registry)) continue;
                this.error("Cannot find any service interface.", impl);
                continue;
            }
            this.warning("Expected a type element here.", element);
        }
        registry.persist();
        return true;
    }

    private boolean valid(TypeElement impl) {
        Set<Modifier> modifiers = impl.getModifiers();
        if (!modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.ABSTRACT) || impl.getKind() != ElementKind.CLASS) {
            this.error("Not a public and non-abstract class.", impl);
            return false;
        }
        if (impl.getNestingKind().isNested() && !modifiers.contains((Object)Modifier.STATIC)) {
            this.error("Impossible to instantiate without an instance of the enclosing class.", impl);
            return false;
        }
        LinkedList<ExecutableElement> constructors = new LinkedList<ExecutableElement>();
        for (Element element : impl.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            constructors.add((ExecutableElement)element);
        }
        if (!constructors.isEmpty() && !this.valid(constructors)) {
            this.error("No public constructor with zero parameters available.", impl);
            return false;
        }
        return true;
    }

    private boolean valid(Collection<? extends ExecutableElement> ctors) {
        for (ExecutableElement executableElement : ctors) {
            if (!this.valid(executableElement)) continue;
            return true;
        }
        return false;
    }

    private boolean valid(ExecutableElement ctor) {
        return ctor.getModifiers().contains((Object)Modifier.PUBLIC) && ctor.getParameters().isEmpty();
    }

    private boolean processAnnotations(final TypeElement impl, final Registry registry) {
        final DeclaredType implType = (DeclaredType)impl.asType();
        for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(impl)) {
            if (!ServiceImplementation.class.getName().equals(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                ExecutableElement element = entry.getKey();
                if (!"value".equals(element.getSimpleName().toString())) continue;
                class Visitor
                extends SimpleAnnotationValueVisitor8<Boolean, Void> {
                    Visitor() {
                        super(false);
                    }

                    @Override
                    public Boolean visitType(TypeMirror type, Void p) {
                        if (ServiceImplementationProcessor.this.processingEnv.getTypeUtils().isAssignable(implType, type)) {
                            registry.add(impl, (TypeElement)((DeclaredType)type).asElement());
                        } else {
                            ServiceImplementationProcessor.this.error("Unassignable to " + type + ".", impl);
                        }
                        return Boolean.TRUE;
                    }

                    @Override
                    public Boolean visitArray(List<? extends AnnotationValue> values, Void p) {
                        boolean found = false;
                        for (AnnotationValue annotationValue : values) {
                            found |= annotationValue.accept(this, p).booleanValue();
                        }
                        return found;
                    }
                }
                return entry.getValue().accept(new Visitor(), null);
            }
        }
        return false;
    }

    private boolean processTypeHierarchy(final TypeElement impl, final Registry registry) {
        class Visitor
        extends SimpleTypeVisitor8<Boolean, Void> {
            Visitor() {
                super(false);
            }

            @Override
            public Boolean visitDeclared(DeclaredType type, Void p) {
                boolean found = false;
                TypeElement elem = (TypeElement)type.asElement();
                if (null != elem.getAnnotation(ServiceInterface.class)) {
                    found = true;
                    registry.add(impl, elem);
                }
                for (TypeMirror typeMirror : elem.getInterfaces()) {
                    found |= typeMirror.accept(this, p).booleanValue();
                }
                return elem.getSuperclass().accept(this, p) != false || found;
            }
        }
        return impl.asType().accept(new Visitor(), null);
    }

    private final class Registry {
        final Elements elements;
        final Map<TypeElement, Collection<TypeElement>> services;

        private Registry() {
            this.elements = ServiceImplementationProcessor.this.processingEnv.getElementUtils();
            this.services = new HashMap<TypeElement, Collection<TypeElement>>();
        }

        void add(TypeElement impl, TypeElement iface) {
            Collection<TypeElement> coll = this.services.get(iface);
            if (null == coll) {
                coll = new TreeSet<TypeElement>(TYPE_ELEMENT_COMPARATOR);
            }
            coll.add(impl);
            this.services.put(iface, coll);
        }

        void persist() {
            Filer filer = ServiceImplementationProcessor.this.processingEnv.getFiler();
            for (Map.Entry<TypeElement, Collection<TypeElement>> entry : this.services.entrySet()) {
                TypeElement iface = entry.getKey();
                Collection<TypeElement> coll = entry.getValue();
                if (coll.isEmpty()) continue;
                String path = "META-INF/services/" + this.name(iface);
                try {
                    FileObject fo = filer.createResource(StandardLocation.CLASS_OUTPUT, "", path, new Element[0]);
                    Writer w = fo.openWriter();
                    Throwable throwable = null;
                    try {
                        for (TypeElement impl : coll) {
                            w.append(this.name(impl)).append("\n");
                            ServiceImplementationProcessor.this.debug(String.format(Locale.ENGLISH, "Registered in: %s", path), impl);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (w == null) continue;
                        if (throwable != null) {
                            try {
                                w.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        w.close();
                    }
                }
                catch (IOException e) {
                    ServiceImplementationProcessor.this.error(String.format(Locale.ENGLISH, "Failed to register %d service implementation class(es) at: %s: %s", coll.size(), path, e.getMessage()));
                }
            }
        }

        CharSequence name(TypeElement elem) {
            return this.elements.getBinaryName(elem);
        }
    }
}

