/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameters;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import libsidutils.IOUtils;
import libsidutils.directory.Directory;
import libsidutils.directory.DiskDirectory;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.FileRequestPathServletParameters;

@WebServlet(name="DiskDirectoryServlet", displayName="DiskDirectoryServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/disk-directory/*"}, description="Get Directory of Disk")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class DiskDirectoryServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.DiskDirectoryServlet.MAX_DISK_DIRECTORY_IN_PARALLEL, new DefaultThreadFactory("/diskdirectory"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.DiskDirectoryServlet.DISK_DIRECTORY_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        DiskDirectoryServletParameters servletParameters = new DiskDirectoryServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        File file = servletParameters.fetchFile(DiskDirectoryServlet.this.configuration, DiskDirectoryServlet.this.directoryProperties, parser, DiskDirectoryServlet.this.hasAdminAccess(request));
                        if (file == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        Directory directory = DiskDirectoryServlet.this.createDiskDirectory(file);
                        if (!this.isComplete()) {
                            DiskDirectoryServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, directory);
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(DiskDirectoryServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        DiskDirectoryServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    private Directory createDiskDirectory(File file) throws IOException, FileNotFoundException {
        File extractedFile = IOUtils.extract(this.configuration.getSidplay2Section().getTmpDir(), file);
        return new DiskDirectory(extractedFile);
    }

    @Parameters(resourceBundle="server.restful.servlets.DiskDirectoryServletParameters")
    public static class DiskDirectoryServletParameters
    extends FileRequestPathServletParameters {
    }
}

