/*
 * Decompiled with CFR 0.152.
 */
package sidblaster.d2xx;

import com.ftdi.EEPROMData;
import com.ftdi.FTD2XXException;
import com.ftdi.FTDevice;
import com.ftdi.Parity;
import com.ftdi.StopBits;
import com.ftdi.WordLength;
import sidblaster.SIDType;

public class D2XXDevice {
    private static final int FT_READ_TIMEOUT = 1000;
    private static final int FT_WRITE_TIMEOUT = 1000;
    private static final int FT_BAUD_RATE = Integer.valueOf(System.getenv().getOrDefault("SIDBLASTERUSB_BAUDRATE", "500000"));
    private static final short FT_LATENCY_TIMER = Short.valueOf(System.getenv().getOrDefault("SIDBLASTERUSB_LATENCY_TIMER", "2"));
    private static final int FT_TRANSFER_SIZE = Integer.valueOf(System.getenv().getOrDefault("SIDBLASTERUSB_TRANSFER_SIZE", "4096"));

    public static void open(FTDevice device) throws FTD2XXException {
        device.open();
    }

    public static void close(FTDevice device) throws FTD2XXException {
        device.close();
    }

    public static int read(FTDevice device, byte[] buffer, int count) throws FTD2XXException {
        return device.read(buffer, 0, count);
    }

    public static int write(FTDevice device, byte[] buffer, int count) throws FTD2XXException {
        return device.write(buffer, 0, count);
    }

    public static boolean IsOpen(FTDevice device) {
        return device != null && device.isOpen();
    }

    public static void initialize(FTDevice device) throws FTD2XXException {
        device.setTimeouts(1000L, 1000L);
        device.setBaudRate(FT_BAUD_RATE);
        device.setDataCharacteristics(WordLength.BITS_8, StopBits.STOP_BITS_1, Parity.PARITY_NONE);
        device.setLatencyTimer(FT_LATENCY_TIMER);
        device.setUSBParameters(FT_TRANSFER_SIZE, FT_TRANSFER_SIZE);
    }

    public static void setLatencyTimer(FTDevice device, short ms) throws FTD2XXException, IllegalArgumentException {
        device.setLatencyTimer(ms);
    }

    public static SIDType getSIDType(FTDevice device) {
        if (device.getDevDescription().startsWith("SIDBlaster/USB/")) {
            String sidType = device.getDevDescription().substring("SIDBlaster/USB/".length());
            if (sidType.equals("6581")) {
                return SIDType.MOS6581;
            }
            if (sidType.equals("8580")) {
                return SIDType.MOS8580;
            }
        }
        return SIDType.NONE;
    }

    public static void setSIDType(FTDevice device, SIDType sidType) throws FTD2XXException, InterruptedException {
        if (!device.isOpen()) {
            device.open();
        }
        EEPROMData read = device.readEEPROM();
        switch (sidType) {
            case MOS6581: {
                read.setDescription("SIDBlaster/USB/6581");
                break;
            }
            case MOS8580: {
                read.setDescription("SIDBlaster/USB/8580");
                break;
            }
            default: {
                read.setDescription("SIDBlaster/USB");
            }
        }
        device.writeEEPROM(read);
        Thread.sleep(1000L);
    }

    public static void setSerialNo(FTDevice device, String serialNo) throws FTD2XXException, InterruptedException {
        if (!device.isOpen()) {
            device.open();
        }
        EEPROMData read = device.readEEPROM();
        read.setSerialNumber(serialNo);
        device.writeEEPROM(read);
        Thread.sleep(1000L);
    }

    public static void displayInfo(FTDevice device) {
        System.out.printf("%18s%s\n", new Object[]{"FT Device type: ", device.getDevType()});
        System.out.printf("%18s%s\n", "Serial number: ", device.getDevSerialNumber());
        System.out.printf("%18s%s\n", "Description: ", device.getDevDescription());
        System.out.printf("%18s0x%08X\n", "VID&PID: ", device.getDevID());
        System.out.printf("%18s%d\n", "Is opened: ", device.isOpen() ? 1 : 0);
        System.out.printf("%18s0x%08X\n", "Location ID: ", device.getDevLocationID());
    }

    public static void send(FTDevice device, byte[] buffer) throws FTD2XXException {
        D2XXDevice.send(device, buffer, buffer.length);
    }

    public static void send(FTDevice device, byte[] buffer, int count) throws FTD2XXException {
        if (count != 0) {
            device.write(buffer, 0, count);
        }
    }

    public static byte[] receive(FTDevice device) throws FTD2XXException {
        int rxBytes = device.getQueueStatus();
        if (rxBytes > 0) {
            byte[] buffer = new byte[rxBytes];
            D2XXDevice.read(device, buffer, rxBytes);
            return buffer;
        }
        return new byte[0];
    }
}

