/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.function.functionselector;

import java.util.HashMap;
import java.util.Map;
import kickass.pass.function.Function;
import kickass.pass.function.functionselector.IFunctionSelector;

public class MultiFunctionSelector
implements IFunctionSelector {
    private String functionName;
    private Function anyArgsFunction = null;
    private Map<Integer, Function> functionMap = new HashMap<Integer, Function>();

    public MultiFunctionSelector(String string, Function ... functionArray) {
        this.functionName = string;
        for (Function function : functionArray) {
            if (function.getName().equals(string)) continue;
            throw new RuntimeException("Wrong function name '" + function.getName() + "', it should be '" + string + "'");
        }
        for (Function function : functionArray) {
            this.addFunction(function);
        }
    }

    @Override
    public boolean addFunction(Function function) {
        if (function.getNoOfArguments() == null) {
            if (this.anyArgsFunction != null) {
                return false;
            }
            this.anyArgsFunction = function;
            return true;
        }
        if (this.functionMap.containsKey(function.getNoOfArguments())) {
            return false;
        }
        this.functionMap.put(function.getNoOfArguments(), function);
        return true;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public Function getFunction(int n) {
        Function function = this.functionMap.get(n);
        return function != null ? function : this.anyArgsFunction;
    }
}

