/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.functionnode;

import java.util.List;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.stmt.StmtNode;
import kickass.pass.functionnode.FunctionDirective;
import kickass.pass.functionnode.FunctionNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;

public class ForFDirective
extends FunctionDirective {
    private List<StmtNode> initStmts;
    private ExprNode conditionExpr;
    private List<ExprNode> iterExprs;
    private FunctionNode body;
    private SymbolScope countVarScope;
    private SymbolScope iterScope;

    public ForFDirective(List<StmtNode> list, ExprNode exprNode, List<ExprNode> list2, FunctionNode functionNode, SourceRange sourceRange) {
        super(sourceRange);
        this.initStmts = list;
        this.conditionExpr = exprNode;
        this.iterExprs = list2;
        this.body = functionNode;
    }

    @Override
    public FunctionNode executeMetaRegistrations(EvaluationState evaluationState) {
        this.countVarScope = new SymbolScope(evaluationState.scopeMgr.getCurrentScope(), null);
        this.iterScope = new SymbolScope(this.countVarScope, null);
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope);
        for (StmtNode stmtNode : this.initStmts) {
            stmtNode.executeMetaRegistrations(evaluationState);
        }
        evaluationState.scopeMgr.setCurrentScope(this.iterScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope.getParent());
        return this;
    }

    @Override
    public FunctionNode executePrepass(EvaluationState evaluationState) {
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope);
        for (StmtNode object : this.initStmts) {
            object.executePrepass(evaluationState);
        }
        this.conditionExpr.executePrepass(evaluationState);
        for (ExprNode exprNode : this.iterExprs) {
            exprNode.executePrepass(evaluationState);
        }
        evaluationState.scopeMgr.setCurrentScope(this.iterScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope.getParent());
        return this;
    }

    @Override
    public void executeFunctionPass(EvaluationState evaluationState) {
        this.evaluateStmts(this.initStmts, evaluationState);
        while (this.errorIfInvalid(this.conditionExpr.evaluate(evaluationState)).getBoolean(this.range)) {
            this.body.executeFunctionPass(evaluationState);
            this.evaluateExprs(this.iterExprs, evaluationState);
        }
    }

    private void evaluateStmts(List<StmtNode> list, EvaluationState evaluationState) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).evaluate(evaluationState);
        }
    }

    private void evaluateExprs(List<ExprNode> list, EvaluationState evaluationState) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).evaluate(evaluationState);
        }
    }

    private Value errorIfInvalid(Value value) {
        if (value.isInvalid()) {
            throw new AsmErrorException("Can't evaluate condition in first pass", this.range);
        }
        return value;
    }
}

