import "${staticPath}/common/jsidplay2-utils-wrapper.js";

// Function to map linear x values (0..2047) to canvas width (0..canvas.width)
const mapX = (x, width) => (x / 2047) * width;

// Function to map logarithmic y values (1Hz..20000Hz) to canvas height (0..canvas.height)
const mapY = (y, height) => {
  const logY = Math.log10(y); // Convert to log scale
  const logMin = Math.log10(200); // log(1) = 0 (starting frequency)
  const logMax = Math.log10(20000); // log(20000) ~ 4.3010 (max frequency)
  return height - ((logY - logMin) / (logMax - logMin)) * height + 12;
};

// Draw grid lines and labels
export const drawGrid = (width, height, ctx) => {
  ctx.clearRect(0, 0, width, height);

  // Draw X-axis lines and labels
  ctx.strokeStyle = "#ccc";
  ctx.lineWidth = 1;
  for (let x = 0; x <= 2250; x += 2500 / 10) {
	if (x === 2250) {
		x = 2047;
	}
    // 10 grid lines for X-axis
    const xPos = mapX(x, width);
    ctx.beginPath();
    ctx.moveTo(xPos, 0);
    ctx.lineTo(xPos, height);
    ctx.stroke();

	if (x !== 2000) {
      // X-axis labels
      ctx.fillStyle = "black";
      ctx.fillText(Math.round(x), xPos + 2, height - 10); // Label just below the X-axis
    }
  }

  // Draw Y-axis lines and labels (logarithmic)
  const yLabels = [
    200, 400, 600, 800, 1000, 1200, 1400, 1600, 1800, 1900, 2000, 4000, 6000, 8000, 10000, 12000, 14000, 16000,
    18000, 19000, 20000,
  ]; // Key frequencies on log scale
  for (let i = 0; i < yLabels.length; i++) {
    const yPos = mapY(yLabels[i], height);
    ctx.beginPath();
    ctx.moveTo(0, yPos);
    ctx.lineTo(width, yPos);
    ctx.stroke();
    if (i % 2 != 0) continue;

    ctx.fillStyle = "black";
    if (yLabels[i] >= 1000) {
      // If frequency is >= 1000, show label as KHz (e.g., 20 KHz instead of 20000 Hz)
      ctx.fillText((yLabels[i] / 1000).toFixed(1) + " KHz", 10, yPos - 2);
    } else {
      ctx.fillText(yLabels[i] + " Hz", 10, yPos - 2);
    }
  }

  // Draw axis lines
  ctx.beginPath();
  ctx.moveTo(0, 0);
  ctx.lineTo(0, height); // Y-axis
  ctx.lineTo(width, height); // X-axis
  ctx.stroke();
};

export function drawFilterCurve(type, filter, ctx, width, height) {
  // Calculate filter curve (from jsidplay2-utils)
  const curvePoints = js2filterCurve(type, filter.name, filter.filter6581CurvePosition, filter.voiceNonlinearity, filter.steepness, filter.resonanceFactor,
									filter.offset, filter.nonlinearity, filter.minimumfetresistance, filter.k, filter.filter8580CurvePosition, filter.baseresistance, filter.b,
									filter.attenuation);
  ctx.beginPath();
  ctx.strokeStyle = "#00c4ff"; // bright cyan
  ctx.lineWidth = 2;  

  // draw curve
  for (let i = 0; i < 2048; i++) {
    if (i === 0) {
      ctx.moveTo(mapX(0, width), mapY(0, height));
    } else {
      ctx.lineTo(mapX(i, width), mapY(curvePoints[i], height));
	}
  }
  ctx.stroke();
}
