/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.mos656x;

import java.util.HashMap;
import java.util.Map;
import libsidplay.common.VICChipModel;
import libsidplay.components.mos656x.IPalette;
import libsidplay.components.mos656x.OctreeQuantization;

public class Palette
implements IPalette {
    private float saturation = 0.5f;
    private float phaseShift = -15.0f;
    private float offset = 0.9f;
    private float tint = 0.0f;
    private float luminanceC = 0.5f;
    private float dotCreep = 0.5f;
    private float brightness = 0.0f;
    private float contrast = 1.0f;
    private float gamma = 2.0f;
    private static final float NOMINAL_PAL_GAMMA = 2.5f;
    private static final int PALETTE_PURITY = 256;
    private static final float ANGLE_RED = 112.5f;
    private static final float ANGLE_GRN = -135.0f;
    private static final float ANGLE_BLU = 0.0f;
    private static final float ANGLE_ORN = -45.0f;
    private static final float ANGLE_BRN = 157.5f;
    private byte[] evenFiltered;
    private byte[] oddFiltered;
    private int[] oddLineTable;
    private int[] evenLineTable;

    private byte[] calculatePaletteInternal(PaletteEntry[] colors, YUVEntry[] yuv, float saturation, float phaseShift, float tint) {
        YUVEntry[] palette = new YUVEntry[16];
        for (int i = 0; i < colors.length; ++i) {
            PaletteEntry pe = colors[i];
            palette[i] = pe.toYUV(saturation, phaseShift, tint);
        }
        int[] filteredYuv = this.generateFilteredPalette(palette);
        OctreeQuantization q = new OctreeQuantization(256);
        for (int i = 0; i < filteredYuv.length; ++i) {
            int w = 1;
            block2: for (int c1 = 0; c1 < 12; c1 += 4) {
                for (int c2 = c1 + 4; c2 < 16; c2 += 4) {
                    if ((i >> c1 & 0xF) != (i >> c2 & 0xF)) continue;
                    w *= 256;
                    continue block2;
                }
            }
            q.addColor(filteredYuv[i], w);
        }
        int[] yuvPalette = q.getPalette();
        HashMap<Integer, Byte> yuvToIndex = new HashMap<Integer, Byte>();
        for (int i = 0; i < 256; ++i) {
            yuv[i] = new YUVEntry(yuvPalette[i]);
            yuvToIndex.put(yuvPalette[i], (byte)i);
        }
        return Palette.replaceColorsByPalette(filteredYuv, q, yuvToIndex);
    }

    public void calculatePalette(PaletteEntry[] colors) {
        YUVEntry[] evenPalette = new YUVEntry[256];
        YUVEntry[] oddPalette = new YUVEntry[256];
        this.evenFiltered = this.calculatePaletteInternal(colors, evenPalette, this.saturation, this.phaseShift, this.tint);
        this.oddFiltered = this.calculatePaletteInternal(colors, oddPalette, this.saturation, -this.phaseShift, this.tint);
        this.evenLineTable = new int[65536];
        this.oddLineTable = new int[65536];
        for (int above = 0; above < 256; ++above) {
            for (int below = 0; below < 256; ++below) {
                int idx = above << 8 | below;
                YUVEntry aboveColor = oddPalette[above];
                YUVEntry belowColor = evenPalette[below];
                this.evenLineTable[idx] = new YUVEntry(belowColor.y, (aboveColor.u + belowColor.u) * 0.5f, (aboveColor.v + belowColor.v) * 0.5f).toRGB(this.brightness, this.contrast, this.gamma);
                aboveColor = evenPalette[above];
                belowColor = oddPalette[below];
                this.oddLineTable[idx] = new YUVEntry(belowColor.y, (aboveColor.u + belowColor.u) * this.offset * 0.5f, (aboveColor.v + belowColor.v) * this.offset * 0.5f).toRGB(this.brightness, this.contrast, this.gamma);
            }
        }
    }

    private static byte[] replaceColorsByPalette(int[] filtered, OctreeQuantization q, Map<Integer, Byte> colorIndex) {
        byte[] palette = new byte[filtered.length];
        for (int colorName = 0; colorName < filtered.length; ++colorName) {
            int c = q.lookup(filtered[colorName]);
            palette[colorName] = colorIndex.get(c);
        }
        return palette;
    }

    private static float gauss(float b, float c) {
        b *= b;
        c *= c;
        double factor = 1.0 / Math.sqrt(Math.PI * 2 * (double)c);
        return (float)(factor * Math.exp(-b / (2.0f * c)));
    }

    private float luminanceFilter(float y0, float y1, float y2, float y3) {
        float kernelPlacement = 1.5f + (0.5f - (y0 + y1 + y2 + y3) * 0.25f) * this.dotCreep;
        float c0 = Palette.gauss(kernelPlacement - 0.0f, this.getLuminanceC());
        float c1 = Palette.gauss(kernelPlacement - 1.0f, this.getLuminanceC());
        float c2 = Palette.gauss(kernelPlacement - 2.0f, this.getLuminanceC());
        float c3 = Palette.gauss(kernelPlacement - 3.0f, this.getLuminanceC());
        return (c0 * y0 + c1 * y1 + c2 * y2 + c3 * y3) / (c0 + c1 + c2 + c3);
    }

    private int[] generateFilteredPalette(YUVEntry[] p) {
        int[] filtered = new int[65536];
        for (int x0 = 0; x0 < 16; ++x0) {
            YUVEntry col0 = p[x0];
            for (int x1 = 0; x1 < 16; ++x1) {
                YUVEntry col1 = p[x1];
                for (int x2 = 0; x2 < 16; ++x2) {
                    YUVEntry col2 = p[x2];
                    for (int x3 = 0; x3 < 16; ++x3) {
                        YUVEntry col3 = p[x3];
                        float y = this.luminanceFilter(col0.y, col1.y, col2.y, col3.y);
                        float u = (col0.u + col1.u + col2.u + col3.u) * 0.25f;
                        float v = (col0.v + col1.v + col2.v + col3.v) * 0.25f;
                        YUVEntry ye = new YUVEntry(y, u, v);
                        filtered[x0 << 12 | x1 << 8 | x2 << 4 | x3] = ye.toPacked();
                    }
                }
            }
        }
        return filtered;
    }

    public byte[] getEvenFiltered() {
        return this.evenFiltered;
    }

    public byte[] getOddFiltered() {
        return this.oddFiltered;
    }

    public int[] getEvenLines() {
        return this.evenLineTable;
    }

    public int[] getOddLines() {
        return this.oddLineTable;
    }

    public float getGamma() {
        return this.gamma;
    }

    @Override
    public void setGamma(float gamma) {
        this.gamma = gamma;
    }

    public float getContrast() {
        return this.contrast;
    }

    @Override
    public void setContrast(float contrast) {
        this.contrast = contrast;
    }

    public float getBrightness() {
        return this.brightness;
    }

    @Override
    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public float getLuminanceC() {
        return this.luminanceC;
    }

    @Override
    public void setLuminanceC(float luminanceC) {
        this.luminanceC = luminanceC;
    }

    public float getTint() {
        return this.tint;
    }

    @Override
    public void setTint(float tint) {
        this.tint = tint;
    }

    public float getPhaseShift() {
        return this.phaseShift;
    }

    @Override
    public void setPhaseShift(float phaseShift) {
        this.phaseShift = phaseShift;
    }

    public float getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(float offset) {
        this.offset = offset;
    }

    public float getSaturation() {
        return this.saturation;
    }

    @Override
    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    public float getDotCreep() {
        return this.dotCreep;
    }

    @Override
    public void setDotCreep(float dotCreep) {
        this.dotCreep = dotCreep;
    }

    public static PaletteEntry[] buildPaletteVariant(VICChipModel model) {
        float[] lum = model.getLuminances();
        float min = lum[0];
        float max = lum[1];
        for (int i = 0; i < lum.length; ++i) {
            lum[i] = (lum[i] - min) / (max - min);
        }
        return new PaletteEntry[]{new PaletteEntry(lum[0], -45.0f, 0, "Black"), new PaletteEntry(lum[1], 157.5f, 0, "White"), new PaletteEntry(lum[2], 112.5f, 1, "Red"), new PaletteEntry(lum[3], 112.5f, -1, "Cyan"), new PaletteEntry(lum[4], -135.0f, -1, "Purple"), new PaletteEntry(lum[5], -135.0f, 1, "Green"), new PaletteEntry(lum[6], 0.0f, 1, "Blue"), new PaletteEntry(lum[7], 0.0f, -1, "Yellow"), new PaletteEntry(lum[8], -45.0f, -1, "Orange"), new PaletteEntry(lum[9], 157.5f, 1, "Brown"), new PaletteEntry(lum[10], 112.5f, 1, "Light Red"), new PaletteEntry(lum[11], 112.5f, 0, "Dark Grey"), new PaletteEntry(lum[12], -135.0f, 0, "Medium Grey"), new PaletteEntry(lum[13], -135.0f, 1, "Light Green"), new PaletteEntry(lum[14], 0.0f, 1, "Light Blue"), new PaletteEntry(lum[15], 0.0f, 0, "Light Grey")};
    }

    protected static class YUVEntry {
        protected final float y;
        protected final float u;
        protected final float v;

        protected YUVEntry(float y, float u, float v) {
            this.y = y;
            this.u = u;
            this.v = v;
        }

        protected YUVEntry(int yuvPacked) {
            this.y = (float)(yuvPacked >> 20 & 0x3FF) / 1023.0f;
            this.u = (float)(yuvPacked >> 10 & 0x3FF) / 1023.0f - 0.5f;
            this.v = (float)(yuvPacked & 0x3FF) / 1023.0f - 0.5f;
        }

        protected int toPacked() {
            int yi = Math.round(this.y * 1023.0f);
            int ui = Math.round((this.u + 0.5f) * 1023.0f);
            int vi = Math.round((this.v + 0.5f) * 1023.0f);
            yi = Math.max(0, Math.min(yi, 1023));
            ui = Math.max(0, Math.min(ui, 1023));
            vi = Math.max(0, Math.min(vi, 1023));
            return yi << 20 | ui << 10 | vi;
        }

        protected int toRGB(float brightness, float contrast, float gamma) {
            float rf = this.y + 1.13983f * this.v;
            float gf = this.y - 0.39465f * this.u - 0.5806f * this.v;
            float bf = this.y + 2.03211f * this.u;
            rf += brightness;
            gf += brightness;
            bf += brightness;
            rf *= contrast;
            gf *= contrast;
            bf *= contrast;
            rf = (float)Math.pow(rf, 2.5f / gamma);
            gf = (float)Math.pow(gf, 2.5f / gamma);
            bf = (float)Math.pow(bf, 2.5f / gamma);
            int r = Math.round(rf * 255.0f);
            int g = Math.round(gf * 255.0f);
            int b = Math.round(bf * 255.0f);
            r = Math.max(0, Math.min(255, r));
            g = Math.max(0, Math.min(255, g));
            b = Math.max(0, Math.min(255, b));
            return r << 16 | g << 8 | b;
        }
    }

    protected static class PaletteEntry {
        private final float luminance;
        private final float angle;
        private final int direction;
        private final String name;

        protected PaletteEntry(float luminance, float angle, int direction, String name) {
            this.luminance = luminance;
            this.angle = angle;
            this.direction = direction;
            this.name = name;
        }

        protected YUVEntry toYUV(float saturation, float phase, float baseTint) {
            float y = this.luminance;
            if (this.direction == 0) {
                return new YUVEntry(y, 0.0f, baseTint);
            }
            float u = (float)((double)saturation * Math.cos((double)(phase += this.direction < 0 ? this.angle + 180.0f : this.angle) * Math.PI / 180.0));
            float v = (float)((double)saturation * Math.sin((double)phase * Math.PI / 180.0));
            v *= 0.5f;
            return new YUVEntry(y, u *= 0.5f, v += baseTint);
        }

        protected String getName() {
            return this.name;
        }
    }
}

