/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.whatssid;

import com.beust.jcommander.Parameters;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.persistence.EntityManager;
import javax.persistence.QueryTimeoutException;
import libsidutils.fingerprinting.FingerPrinting;
import libsidutils.fingerprinting.ini.IniFingerprintConfig;
import libsidutils.fingerprinting.rest.beans.MusicInfoBean;
import libsidutils.fingerprinting.rest.beans.MusicInfoWithConfidenceBean;
import libsidutils.fingerprinting.rest.beans.WAVBean;
import server.restful.JSIDPlay2Server;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.LRUCache;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.filters.RTMPBasedRateLimiterFilter;
import server.restful.common.parameter.RequestResponseBodyParameter;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;
import ui.entities.whatssid.service.WhatsSidService;

@WebServlet(name="WhatsSidServlet", displayName="WhatsSidServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/whatssid"}, description="WhatsSID tune recognition. What's this tune?")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
@MultipartConfig(maxFileSize=-1L, maxRequestSize=-1L, fileSizeThreshold=0)
public class WhatsSidServlet
extends JSIDPlay2Servlet {
    private static final Map<Integer, MusicInfoWithConfidenceBean> MUSIC_INFO_WITH_CONFIDENCE_BEAN_MAP = Collections.synchronizedMap(new LRUCache(IServletSystemProperties.WhatsSIDServlet.CACHE_SIZE));
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.WhatsSIDServlet.MAX_WHATSIDS_IN_PARALLEL, new DefaultThreadFactory("/whatssid"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    public Map<Class<? extends HttpFilter>, Map<String, String>> getServletFiltersParameterMap() {
        HashMap<Class<? extends HttpFilter>, Map<String, String>> result = new HashMap<Class<? extends HttpFilter>, Map<String, String>>();
        HashMap<String, String> rtmpBasedRateLimiterFilterParameters = new HashMap<String, String>();
        rtmpBasedRateLimiterFilterParameters.put("maxRtmpPerServlet", String.valueOf(IServletSystemProperties.WhatsSIDServlet.WHATSID_MAINTENANCE ? Integer.valueOf(0) : String.valueOf(IServletSystemProperties.WhatsSIDServlet.WHATSID_LOW_PRIO ? 1 : Integer.MAX_VALUE)));
        result.put(RTMPBasedRateLimiterFilter.class, rtmpBasedRateLimiterFilterParameters);
        return result;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.WhatsSIDServlet.WHATSSID_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                try {
                    MusicInfoWithConfidenceBean musicInfoWithConfidence;
                    WhatsSidServletParameters servletParameters = new WhatsSidServletParameters();
                    ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                    if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                        parser.usage();
                        return;
                    }
                    WAVBean wavBean = (WAVBean)WhatsSidServlet.this.getInput(request, WAVBean.class);
                    boolean isMultipart = request.getContentType().toLowerCase(Locale.US).startsWith("multipart/");
                    wavBean.setMaxSeconds(isMultipart ? IServletSystemProperties.WhatsSIDServlet.UPLOAD_MAX_SECONDS : IServletSystemProperties.WhatsSIDServlet.MAX_SECONDS);
                    int hashCode = request.getRemoteAddr().hashCode() ^ wavBean.hashCode();
                    if (MUSIC_INFO_WITH_CONFIDENCE_BEAN_MAP.containsKey(hashCode)) {
                        musicInfoWithConfidence = (MusicInfoWithConfidenceBean)MUSIC_INFO_WITH_CONFIDENCE_BEAN_MAP.get(hashCode);
                        ServletUtil.info(WhatsSidServlet.this.getServletContext(), String.valueOf(musicInfoWithConfidence) + " (cached)", this.parentThread);
                    } else {
                        musicInfoWithConfidence = this.match(JSIDPlay2Server.getEntityManager(), wavBean);
                        MUSIC_INFO_WITH_CONFIDENCE_BEAN_MAP.put(hashCode, musicInfoWithConfidence);
                        ServletUtil.info(WhatsSidServlet.this.getServletContext(), String.valueOf(musicInfoWithConfidence), this.parentThread);
                    }
                    if (!this.isComplete()) {
                        WhatsSidServlet.this.setOutput(request, response, musicInfoWithConfidence);
                    }
                }
                catch (QueryTimeoutException qte) {
                    ServletUtil.warn(WhatsSidServlet.this.getServletContext(), ((Object)((Object)qte)).getClass().getName(), this.parentThread);
                    if (!this.isComplete()) {
                        response.sendError(503, ((Object)((Object)qte)).getClass().getName());
                    }
                }
                catch (Throwable t) {
                    ServletUtil.error(WhatsSidServlet.this.getServletContext(), t, this.parentThread);
                    if (!this.isComplete()) {
                        response.setStatus(500);
                        WhatsSidServlet.this.setOutput(response, t);
                    }
                }
                finally {
                    JSIDPlay2Server.freeEntityManager();
                }
            }

            private MusicInfoWithConfidenceBean match(EntityManager entityManager, WAVBean wavBean) throws IOException {
                WhatsSidService whatsSidService = new WhatsSidService(entityManager);
                FingerPrinting fingerPrinting = new FingerPrinting(new IniFingerprintConfig(), whatsSidService);
                return fingerPrinting.match(wavBean);
            }
        });
    }

    @Parameters(resourceBundle="server.restful.servlets.whatssid.WhatsSidServletParameters")
    public static class WhatsSidServletParameters
    extends UsageParameter
    implements RequestResponseBodyParameter<WAVBean, MusicInfoWithConfidenceBean> {
        @Override
        public WAVBean getRequestBodyExample() {
            return new WAVBean(new byte[]{82, 73, 70, 70, 44, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 1, 0, 64, 31, 0, 0, -128, 62, 0, 0, 2, 0, 16, 0, 100, 97, 116, 97, 2, 0, 0, 0, 0, 0});
        }

        @Override
        public MusicInfoWithConfidenceBean getResponseBodyExample() {
            MusicInfoWithConfidenceBean musicInfoWithConfidenceBean = new MusicInfoWithConfidenceBean();
            MusicInfoBean musicInfoBean = new MusicInfoBean();
            musicInfoBean.setTitle("Lightspeed");
            musicInfoBean.setArtist("Ari Yliaho (Agemixer)");
            musicInfoBean.setAlbum("2001 Scallop");
            musicInfoBean.setFileDir("/media/nas2/Ken/C64/C64Music/MUSICIANS/A/Agemixer/Lightspeed.sid");
            musicInfoBean.setInfoDir("/C64Music/MUSICIANS/A/Agemixer/Lightspeed.sid");
            musicInfoBean.setAudioLength(332.0562438964844);
            musicInfoWithConfidenceBean.setMusicInfo(musicInfoBean);
            musicInfoWithConfidenceBean.setRelativeConfidence(18.2648401826484);
            musicInfoWithConfidenceBean.setOffsetSeconds(72.12903225806451);
            musicInfoWithConfidenceBean.setConfidence(80);
            musicInfoWithConfidenceBean.setOffset(2236);
            return musicInfoWithConfidenceBean;
        }
    }
}

