/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.compiletime;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import libsidutils.sidid.SidIdBase;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.metaprogramming.Meta;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.Value;

@CompileTime
public class SidIdTeaVM {
    private static final String SID_ID_CFG = "/libsidutils/sidid/sidid.cfg";

    @Meta
    public static native String getSidIdCfg(boolean var0);

    private static void getSidIdCfg(Value<Boolean> b) {
        try (DataInputStream is = new DataInputStream(SidIdBase.class.getResourceAsStream(SID_ID_CFG));){
            URL url = SidIdBase.class.getResource(SID_ID_CFG);
            byte[] sidIdCfgBin = new byte[url.openConnection().getContentLength()];
            is.readFully(sidIdCfgBin);
            String sidIdCfg = new String(Base64.getEncoder().encode(sidIdCfgBin), StandardCharsets.US_ASCII);
            Value sidIdCfgValue = Metaprogramming.emit(() -> sidIdCfg);
            Metaprogramming.exit(() -> sidIdCfgValue.get());
        }
        catch (IOException e) {
            throw new RuntimeException("Load failed for resource: /libsidutils/sidid/sidid.cfg");
        }
    }
}

