/*
 * Decompiled with CFR 0.152.
 */
package sidplay.player;

import java.util.function.DoubleSupplier;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.config.ISidPlay2Section;
import libsidplay.sidtune.MP3Tune;
import libsidplay.sidtune.SidTune;

public abstract class Timer {
    private double start;
    private double end;
    private double fadeIn;
    private double fadeOut;
    private double defaultLength;
    private Event startTimeEvent = Event.of("Timer Start", event -> this.start());
    private Event endTimeEvent = Event.of("Timer End", event -> this.end());
    private Event fadeInStartTimeEvent = Event.of("Fade-in Start", event -> this.fadeInStart(this.fadeIn));
    private Event fadeOutStartTimeEvent = Event.of("Fade-out Start", event -> this.fadeOutStart(this.fadeOut));
    private final EventScheduler context;
    private final ISidPlay2Section sidplay2Section;
    private DoubleSupplier lengthFnct;

    public Timer(ISidPlay2Section sidplay2Section, EventScheduler context, DoubleSupplier lengthFnct) {
        this.sidplay2Section = sidplay2Section;
        this.context = context;
        this.lengthFnct = lengthFnct;
    }

    public final void setStart(double start) {
        this.start = start;
    }

    public void setDefaultLength(double defaultLength) {
        this.defaultLength = defaultLength;
    }

    public final void reset(SidTune tune) {
        this.fadeIn = this.sidplay2Section.getFadeInTime();
        this.fadeOut = this.sidplay2Section.getFadeOutTime();
        this.schedule(tune, this.start, this.startTimeEvent);
        if (this.fadeIn != 0.0) {
            this.schedule(tune, this.start, this.fadeInStartTimeEvent);
        }
        this.updateEnd(tune);
    }

    public final void updateEnd(SidTune tune) {
        double songLength;
        this.cancel(this.endTimeEvent);
        if (this.fadeOut != 0.0) {
            this.cancel(this.fadeOutStartTimeEvent);
        }
        if (tune instanceof MP3Tune) {
            return;
        }
        if (tune != SidTune.RESET && this.sidplay2Section.isEnableDatabase() && (songLength = this.lengthFnct.getAsDouble()) > 0.0) {
            this.end = this.schedule(tune, songLength, this.endTimeEvent);
            if (this.fadeOut != 0.0) {
                this.schedule(tune, this.end - this.fadeOut, this.fadeOutStartTimeEvent);
            }
            return;
        }
        this.end = this.defaultLength;
        if (this.end > 0.0) {
            this.end = this.schedule(tune, this.start + this.end, this.endTimeEvent);
            if (this.fadeOut != 0.0) {
                this.schedule(tune, this.end - this.fadeOut, this.fadeOutStartTimeEvent);
            }
        }
    }

    private double schedule(SidTune tune, double seconds, Event event) {
        long initDelay = SidTune.getInitDelay(tune);
        long absoluteCycles = (long)((double)initDelay + seconds * this.context.getCyclesPerSecond());
        if (absoluteCycles < this.context.getTime(Event.Phase.PHI1)) {
            this.context.scheduleAbsolute(event, 0L, Event.Phase.PHI1);
        } else {
            this.context.scheduleAbsolute(event, absoluteCycles, Event.Phase.PHI1);
        }
        return seconds;
    }

    private void cancel(Event event) {
        this.context.cancel(event);
    }

    public final double getEnd() {
        return this.end;
    }

    public abstract void start();

    public abstract void end();

    public abstract void fadeInStart(double var1);

    public abstract void fadeOutStart(double var1);
}

