/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.rtmp;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Event;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.keyboard.KeyTableEntry;
import libsidplay.sidtune.SidTune;
import libsidutils.IOUtils;
import server.restful.common.IServletSystemProperties;
import server.restful.common.rtmp.StatusText;
import server.restful.servlets.ConvertServlet;
import sidplay.Player;
import sidplay.audio.ThrottlingDriver;
import sidplay.player.State;
import ui.common.ConvenienceResult;
import ui.common.filefilter.CartFileFilter;
import ui.common.filefilter.DiskFileFilter;

public final class PlayerWithStatus {
    private static final DiskFileFilter DISK_FILE_FILTER = new DiskFileFilter();
    private static final CartFileFilter CART_FILE_FILTER = new CartFileFilter();
    private final Player player;
    private File diskImage;
    private File attachedCartridge;
    private CartridgeType attachedCartridgeType;
    private final int pressSpaceInterval;
    private final LocalDateTime created;
    private LocalDateTime validUntil;
    private final StatusText statusText;
    private int playCounter;

    public PlayerWithStatus(Player player, File diskImage, ConvenienceResult convenienceResult, ConvertServlet.ConvertServletParameters servletParameters) {
        this.player = player;
        this.diskImage = diskImage;
        this.attachedCartridge = convenienceResult.getAttatchedCartridge();
        this.attachedCartridgeType = convenienceResult.getAttachedCartridgeType();
        this.pressSpaceInterval = servletParameters.getPressSpaceInterval();
        this.created = LocalDateTime.now();
        this.validUntil = this.created.plusSeconds(IServletSystemProperties.ConvertServlet.RTMP_NOT_YET_PLAYED_TIMEOUT);
        this.statusText = new StatusText(player, servletParameters.getShowStatus(), servletParameters.getLocale());
        this.addPressSpaceListener();
        this.addStatusTextListener();
    }

    public void onPlay() {
        ++this.playCounter;
        this.validUntil = this.created.plusSeconds(IServletSystemProperties.ConvertServlet.RTMP_EXCEEDS_MAXIMUM_DURATION);
    }

    public void onPlayDone() {
        if (--this.playCounter == 0) {
            this.validUntil = LocalDateTime.now().plusSeconds(IServletSystemProperties.ConvertServlet.RTMP_NOT_YET_PLAYED_TIMEOUT);
        }
    }

    public void onKeepAlive(Long currentTime, Long bufferedEnd) {
        LocalDateTime maxDuration = this.created.plusSeconds(IServletSystemProperties.ConvertServlet.RTMP_EXCEEDS_MAXIMUM_DURATION);
        this.validUntil = LocalDateTime.now().isBefore(maxDuration) ? LocalDateTime.now().plusSeconds(IServletSystemProperties.ConvertServlet.HLS_NOT_YET_PLAYED_TIMEOUT) : maxDuration;
        this.player.getAudioDriver().lookup(ThrottlingDriver.class).ifPresent(throttlingDriver -> throttlingDriver.setClientTime(currentTime, bufferedEnd));
    }

    public boolean isInvalid() {
        return this.validUntil.isBefore(LocalDateTime.now());
    }

    public LocalDateTime getValidUntil() {
        return this.validUntil;
    }

    public void quitPlayer() {
        this.player.quit();
    }

    public File insertNextDisk() throws IOException {
        this.diskImage = this.determineNextImage(this.diskImage, DISK_FILE_FILTER);
        if (this.diskImage != null && DISK_FILE_FILTER.accept(this.diskImage)) {
            this.player.insertDisk(IOUtils.extract(this.player.getConfig().getSidplay2Section().getTmpDir(), this.diskImage));
        }
        return this.diskImage;
    }

    public File insertNextCart() throws IOException {
        this.attachedCartridge = this.determineNextImage(this.attachedCartridge, CART_FILE_FILTER);
        if (this.attachedCartridge != null && CART_FILE_FILTER.accept(this.attachedCartridge)) {
            this.player.insertCartridge(this.attachedCartridgeType, IOUtils.extract(this.player.getConfig().getSidplay2Section().getTmpDir(), this.attachedCartridge));
        }
        return this.attachedCartridge;
    }

    public void setDefaultSidModel6581() {
        this.player.getConfig().getEmulationSection().setDefaultSidModel(ChipModel.MOS6581);
        this.player.updateSIDChipConfiguration();
    }

    public void setDefaultSidModel8580() {
        this.player.getConfig().getEmulationSection().setDefaultSidModel(ChipModel.MOS8580);
        this.player.updateSIDChipConfiguration();
    }

    public void setDefaultEmulationReSid() {
        this.player.getConfig().getEmulationSection().setDefaultEmulation(Emulation.RESID);
        this.player.updateSIDChipConfiguration();
    }

    public void setDefaultEmulationReSidFp() {
        this.player.getConfig().getEmulationSection().setDefaultEmulation(Emulation.RESIDFP);
        this.player.updateSIDChipConfiguration();
    }

    public void pressKey(KeyTableEntry key) {
        this.player.getC64().getEventScheduler().scheduleThreadSafeKeyEvent(Event.of("Virtual Keyboard Pressed", event -> this.player.getC64().getKeyboard().keyPressed(key)));
    }

    public void releaseKey(KeyTableEntry key) {
        this.player.getC64().getEventScheduler().scheduleThreadSafeKeyEvent(Event.of("Virtual Keyboard Released", event -> this.player.getC64().getKeyboard().keyReleased(key)));
    }

    public void typeKey(KeyTableEntry key) {
        this.player.getC64().getEventScheduler().scheduleThreadSafeKeyEvent(Event.of("Virtual Keyboard Pressed", event -> {
            if (key == KeyTableEntry.RESTORE) {
                this.player.getC64().getKeyboard().restore();
            } else {
                this.player.getC64().getKeyboard().keyPressed(key);
                this.player.getC64().getEventScheduler().schedule(Event.of("Wait Until Virtual Keyboard Released", event2 -> this.player.getC64().getEventScheduler().scheduleThreadSafeKeyEvent(Event.of("Virtual Keyboard Released", event3 -> this.player.getC64().getKeyboard().keyReleased(key)))), this.player.getC64().getClock().getCyclesPerFrame() << 2);
            }
        }));
    }

    public void joystick(int number, int value) {
        this.player.getC64().getEventScheduler().scheduleThreadSafeKeyEvent(Event.of("Virtual Joystick Pressed", event -> {
            this.player.getC64().setJoystick(number, () -> (byte)(0xFF ^ value));
            this.player.getC64().getEventScheduler().schedule(Event.of("Wait Until Virtual Joystick Released", event2 -> this.player.getC64().getEventScheduler().scheduleThreadSafeKeyEvent(Event.of("Virtual Joystick Released", event3 -> this.player.getC64().setJoystick(number, null)))), this.player.getC64().getClock().getCyclesPerFrame() << 2);
        }));
    }

    private File determineNextImage(File imageFile, FileFilter fileFilter) {
        if (imageFile != null) {
            File[] files = imageFile.getParentFile().listFiles(fileFilter);
            List filesList = Arrays.asList(Optional.ofNullable(files).orElse(new File[0])).stream().filter(File::isFile).collect(Collectors.toList());
            Iterator fileIterator = filesList.stream().sorted().iterator();
            while (fileIterator.hasNext()) {
                File file = (File)fileIterator.next();
                if (!file.equals(imageFile) || !fileIterator.hasNext()) continue;
                return (File)fileIterator.next();
            }
            return filesList.stream().sorted().findFirst().orElse(imageFile);
        }
        return imageFile;
    }

    private void addPressSpaceListener() {
        if (this.pressSpaceInterval > 0) {
            this.player.stateProperty().addListener(event -> {
                if (event.getNewValue() == State.START) {
                    long initDelay = SidTune.getInitDelay(this.player.getTune());
                    this.player.getC64().getEventScheduler().schedule(Event.of("Virtual Keyboard Pressed", event2 -> {
                        this.player.getC64().getKeyboard().keyPressed(KeyTableEntry.SPACE);
                        this.player.getC64().getEventScheduler().schedule(Event.of("Virtual Keyboard Released", event3 -> this.player.getC64().getKeyboard().keyReleased(KeyTableEntry.SPACE)), this.player.getC64().getClock().getCyclesPerFrame() << 2);
                        this.player.getC64().getEventScheduler().schedule((Event)event2, (long)this.pressSpaceInterval * (long)this.player.getC64().getClock().getCpuFrequency());
                    }), initDelay + (long)this.pressSpaceInterval * (long)this.player.getC64().getClock().getCpuFrequency());
                }
            });
        }
    }

    private void addStatusTextListener() {
        this.player.stateProperty().addListener(event -> {
            if (event.getNewValue() == State.START) {
                this.player.getC64().getEventScheduler().schedule(Event.of("Update Status Text", event2 -> {
                    this.statusText.update(this.diskImage);
                    this.player.getC64().getEventScheduler().schedule((Event)event2, this.player.getC64().getClock().getCyclesPerFrame());
                }), 0L);
            }
        });
    }
}

