/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.metanodes;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.state.EvaluationState;

public class AddRangeToCallStackNode
extends AsmNode {
    private SourceRange range;
    private AsmNode body;

    public AddRangeToCallStackNode(SourceRange sourceRange, AsmNode asmNode) {
        this.range = sourceRange;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new AddRangeToCallStackNode(this.range, this.body.copy());
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
        this.body.deliverOutput(iOutputReciever);
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.callStack.push(this.range);
        this.body.executePass(evaluationState);
        evaluationState.callStack.pop();
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        evaluationState.callStack.push(this.range);
        this.body.executePrepass(evaluationState);
        evaluationState.callStack.pop();
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        evaluationState.callStack.push(this.range);
        this.body.executeMetaRegistrations(evaluationState);
        evaluationState.callStack.pop();
        return this;
    }
}

