/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import sidplay.Player;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.entities.config.Configuration;
import ui.entities.config.service.ConfigService;

public abstract class C64Window
implements UIPart,
Initializable {
    protected UIUtil util;
    private Stage stage;
    private Scene scene;
    private boolean wait;
    private Supplier<Boolean> closeActionEnabler = () -> true;

    public C64Window() {
        ConfigService configService = new ConfigService(ConfigService.ConfigurationType.XML);
        Configuration configuration = configService.load();
        this.util = new UIUtil(null, new Player(configuration), this);
        configService.close();
    }

    public C64Window(Player player) {
        this(new Stage(), player);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.util.setBundle(resources);
        this.initialize();
    }

    protected abstract void initialize();

    public C64Window(Stage stage, Player player) {
        this.stage = stage;
        this.util = new UIUtil(this, player, this);
        this.scene = (Scene)this.util.parse();
        this.scene.setOnKeyPressed(ke -> {
            if (ke.getCode() == KeyCode.ESCAPE) {
                this.close();
            }
        });
        stage.getIcons().add((Object)new Image(this.util.getBundle().getString("ICON")));
        stage.setTitle(this.util.getBundle().getString("TITLE"));
        stage.setOnCloseRequest(event -> this.close());
        stage.setScene(this.scene);
    }

    public void open() {
        if (this.wait) {
            this.stage.showAndWait();
        } else {
            this.stage.show();
        }
    }

    public void close() {
        if (this.closeActionEnabler.get().booleanValue()) {
            this.stage.close();
            this.close((Node)this.getStage().getScene().getRoot());
            this.doClose();
        }
    }

    public void close(Node node) {
        if (node instanceof UIPart) {
            ((UIPart)node).doClose();
        }
        if (node instanceof Parent) {
            ((Parent)node).getChildrenUnmodifiable().stream().forEach(child -> this.close((Node)child));
        }
    }

    public void setCloseActionEnabler(Supplier<Boolean> closeActionEnabler) {
        this.closeActionEnabler = closeActionEnabler;
    }

    public Stage getStage() {
        return this.stage;
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public UIUtil getUtil() {
        return this.util;
    }
}

