/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kickass.nonasm.tools.tuples.Triple;
import kickass.nonasm.util.functions.Func3;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class EnumTailParser
implements ITailParser<AsmNode> {
    private Func3<String, List<Triple<String, SourceRange, ExprNode>>, SourceRange, AsmNode> nodeCreator;

    public EnumTailParser(Func3<String, List<Triple<String, SourceRange, ExprNode>>, SourceRange, AsmNode> func3) {
        this.nodeCreator = func3;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        Object T1 = null;
        iTokenStream.skipWsAndNl();
        IToken iToken2 = iTokenStream.expectType(TokenType.CurlyBracketRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        ArrayList<Triple<String, SourceRange, Object>> arrayList = new ArrayList<Triple<String, SourceRange, Object>>();
        TokenStreamList tokenStreamList = iToken2.getChildStream();
        while (!tokenStreamList.peek().isEos()) {
            ExprNode exprNode;
            TokenStreamList tokenStreamList2 = tokenStreamList.getUntilCommaSkipWsAndNl();
            IToken iToken3 = tokenStreamList2.expectType(TokenType.Id, evaluationState);
            if (iToken3 == null) continue;
            String string = iToken3.getStringValue();
            SourceRange sourceRange2 = iToken3.getSourceRange();
            IToken iToken4 = tokenStreamList2.next();
            if (iToken4.isEos()) {
                arrayList.add(new Triple<String, SourceRange, Object>(string, sourceRange2, null));
                continue;
            }
            if (!iToken4.expectType(TokenType.Assign, evaluationState, "Invalid token") || (exprNode = ExprParser.parse(tokenStreamList2, evaluationState)) == null) continue;
            arrayList.add(new Triple<String, SourceRange, ExprNode>(string, sourceRange2, exprNode));
        }
        return this.nodeCreator.apply((String)T1, (List<Triple<String, SourceRange, ExprNode>>)arrayList, sourceRange);
    }
}

