/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import com.xuggle.xuggler.ICodec;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.EventScheduler;
import libsidplay.common.SamplingRate;
import libsidplay.config.IAudioSection;
import sidplay.audio.AudioConfig;
import sidplay.audio.wav.WAVHeader;
import sidplay.audio.xuggle.XuggleAudioDriver;

public abstract class WAVDriver
extends XuggleAudioDriver {
    protected WAVHeader wavHeader;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        AudioConfig cfg = new AudioConfig(audioSection);
        this.wavHeader = new WAVHeader(cfg.getChannels(), cfg.getFrameRate());
        super.open(audioSection, recordingFilename, cpuClock, context);
    }

    @Override
    public void write() throws InterruptedException {
        this.wavHeader.advance(this.sampleBuffer.position());
        super.write();
    }

    @Override
    protected List<SamplingRate> getSupportedSamplingRates() {
        return Arrays.asList(SamplingRate.VERY_LOW, SamplingRate.LOW, SamplingRate.MEDIUM, SamplingRate.HIGH);
    }

    @Override
    protected SamplingRate getDefaultSamplingRate() {
        return SamplingRate.LOW;
    }

    @Override
    protected ICodec.ID getAudioCodec() {
        return ICodec.ID.CODEC_ID_PCM_S16LE;
    }

    @Override
    protected String getOutputFormatName() {
        return "wav";
    }

    @Override
    public String getExtension() {
        return ".wav";
    }

    public static class WAVStreamDriver
    extends WAVDriver {
        public WAVStreamDriver(OutputStream out) {
            this.out = out;
        }

        @Override
        protected OutputStream getOut(String recordingFilename) {
            return this.out;
        }
    }

    public static class WAVFileDriver
    extends WAVDriver {
        private RandomAccessFile file;

        @Override
        protected OutputStream getOut(String recordingFilename) throws IOException {
            System.out.println("Recording, file=" + recordingFilename);
            this.file = new RandomAccessFile(recordingFilename, "rw");
            return new FileOutputStream(this.file.getFD());
        }

        @Override
        public void close() {
            super.close();
            if (this.out != null && this.file != null) {
                try {
                    this.file.seek(0L);
                    this.out.write(this.wavHeader.getBytes());
                    this.out.close();
                    this.file.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing WAV audio stream", e);
                }
                finally {
                    this.out = null;
                    this.file = null;
                }
            }
        }
    }
}

