/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.wav;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class WAVHeader {
    private static final int HEADER_OFFSET = 8;
    public static final int HEADER_LENGTH = 44;
    private int length = 36;
    private int sampleFreq;
    private int bytesPerSec;
    private int dataChunkLen;
    private short format = 1;
    private short channels;
    private short blockAlign;
    private short bitsPerSample;

    public WAVHeader(int channels, int frameRate) {
        this.channels = (short)channels;
        this.sampleFreq = frameRate;
        this.bytesPerSec = frameRate * 2 * channels;
        this.blockAlign = (short)(2 * channels);
        this.bitsPerSample = (short)16;
        this.dataChunkLen = 0;
    }

    public void advance(int length) {
        this.length += length;
        this.dataChunkLen += length;
    }

    public byte[] getBytes() {
        ByteBuffer b = ByteBuffer.allocate(44);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b.put("RIFF".getBytes(StandardCharsets.US_ASCII));
        b.putInt(this.length);
        b.put("WAVE".getBytes(StandardCharsets.US_ASCII));
        b.put("fmt ".getBytes(StandardCharsets.US_ASCII));
        b.putInt(16);
        b.putShort(this.format);
        b.putShort(this.channels);
        b.putInt(this.sampleFreq);
        b.putInt(this.bytesPerSec);
        b.putShort(this.blockAlign);
        b.putShort(this.bitsPerSample);
        b.put("data".getBytes(StandardCharsets.US_ASCII));
        b.putInt(this.dataChunkLen);
        return b.array();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setDataChunkLen(int dataChunkLen) {
        this.dataChunkLen = dataChunkLen;
    }
}

