/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import libsidplay.sidtune.MD5Method;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.sidid.SidIdInfo;
import lowlevel.ID3V2Decoder;

public class MP3Tune
extends SidTune {
    private File mp3;
    private ID3V2Decoder decoder = new ID3V2Decoder();

    @Override
    public Integer placeProgramInMemory(byte[] c64buf) {
        return null;
    }

    @Override
    public Integer placeProgramInMemory(byte[] c64buf, byte[] driver) {
        return null;
    }

    @Override
    public void save(String destFileName) throws IOException {
        throw new RuntimeException("Saving of this format is not possible!");
    }

    @Override
    public Collection<String> identify() {
        return this.identify(null);
    }

    @Override
    public Collection<String> identify(byte[] sidIdCfgBin) {
        ArrayList<String> names = new ArrayList<String>();
        names.add("jump3r");
        return names;
    }

    @Override
    public SidIdInfo.PlayerInfoSection getPlayerInfo(String playerName) {
        return null;
    }

    @Override
    public SidIdInfo.PlayerInfoSection getPlayerInfo(String playerName, byte[] sidIdCfgBin) {
        return null;
    }

    public static final SidTune load(File file) throws IOException, SidTuneError {
        if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".mp3")) {
            throw new SidTuneError("MP3: Bad file extension, expected: .mp3");
        }
        MP3Tune mp3 = new MP3Tune();
        mp3.mp3 = file;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            mp3.decoder.read(randomAccessFile);
            String title = Optional.ofNullable(mp3.decoder.getTitle()).map(MP3Tune::replaceNonPrintable).orElse(null);
            String interpret = Optional.ofNullable(mp3.decoder.getInterpret()).map(MP3Tune::replaceNonPrintable).orElse(null);
            String albumInterpret = Optional.ofNullable(mp3.decoder.getAlbumInterpret()).map(MP3Tune::replaceNonPrintable).orElse(null);
            String genre = Optional.ofNullable(mp3.decoder.getGenre()).map(MP3Tune::replaceNonPrintable).orElse(null);
            String album = Optional.ofNullable(mp3.decoder.getAlbum()).map(MP3Tune::replaceNonPrintable).orElse(null);
            String year = Optional.ofNullable(mp3.decoder.getYear()).map(MP3Tune::replaceNonPrintable).orElse(null);
            mp3.info.infoString.add(title != null ? title : IOUtils.getFilenameWithoutSuffix(file.getName()));
            if (interpret != null) {
                mp3.info.infoString.add(interpret);
            } else if (albumInterpret != null) {
                mp3.info.infoString.add(albumInterpret);
            } else {
                mp3.info.infoString.add("<?>");
            }
            if (album != null && year != null) {
                mp3.info.infoString.add(album + " (" + year + ")" + (genre != null ? " / " + genre : ""));
            } else if (album != null) {
                mp3.info.infoString.add(album + (genre != null ? " / " + genre : ""));
            } else {
                mp3.info.infoString.add("<?>");
            }
        }
        return mp3;
    }

    public byte[] getCoverArt() {
        return this.decoder.getImageBytes();
    }

    @Override
    public String getMD5Digest(MD5Method md5Method) {
        return null;
    }

    public File getMP3() {
        return this.mp3;
    }

    @Override
    protected long getInitDelay() {
        return 0L;
    }

    private static String replaceNonPrintable(String str) {
        return str.replaceAll("\\p{Cntrl}", "");
    }
}

