/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@WebFilter(filterName="RobotsTxtFilter", displayName="RobotsTxtFilter", servletNames={"StartPageServlet"}, description="Deny existence of resource robots.txt")
public class RobotsTxtFilter
extends HttpFilter {
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!"/robots.txt".equals(request.getServletPath())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendError(404);
        }
    }
}

