/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.xuggle;

import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.io.InputOutputStreamHandler;
import com.xuggle.xuggler.io.XugglerIO;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SamplingRate;
import libsidplay.config.IAudioSection;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;
import sidplay.audio.exceptions.IniConfigException;
import sidplay.audio.xuggle.XuggleBase;

public abstract class XuggleAudioDriver
extends XuggleBase
implements AudioDriver {
    protected OutputStream out;
    private EventScheduler context;
    private IMediaWriter writer;
    private long firstTimeStamp;
    private double ticksPerMicrosecond;
    private boolean aborted;
    protected ByteBuffer sampleBuffer;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        this.context = context;
        AudioConfig cfg = new AudioConfig(audioSection);
        this.out = this.getOut(recordingFilename);
        if (!this.getSupportedSamplingRates().contains((Object)audioSection.getSamplingRate())) {
            throw new IniConfigException("Sampling rate is not supported by encoder, switch to default", () -> audioSection.setSamplingRate(this.getDefaultSamplingRate()));
        }
        this.writer = ToolFactory.makeWriter((String)XugglerIO.map((String)XugglerIO.generateUniqueName((Object)this.out), (IURLProtocolHandler)new AbortingOutputStreamHandler(this.out)));
        IContainerFormat containerFormat = IContainerFormat.make();
        containerFormat.setOutputFormat(this.getOutputFormatName(), null, null);
        this.writer.getContainer().setFormat(containerFormat);
        this.throwExceptionOnError(this.writer.addAudioStream(0, 0, this.getAudioCodec(), cfg.getChannels(), cfg.getFrameRate()));
        this.configureStreamCoder(this.writer.getContainer().getStream(0L).getStreamCoder(), audioSection);
        this.aborted = false;
        this.firstTimeStamp = 0L;
        this.ticksPerMicrosecond = cpuClock.getCpuFrequency() / 1000000.0;
        this.sampleBuffer = ByteBuffer.allocateDirect(cfg.getChunkFrames() * 2 * cfg.getChannels()).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void write() throws InterruptedException {
        long timeStamp = this.getTimeStamp();
        short[] shortArray = new short[this.sampleBuffer.position() >> 1];
        ((Buffer)this.sampleBuffer).flip();
        this.sampleBuffer.asShortBuffer().get(shortArray);
        this.writer.encodeAudio(0, shortArray, timeStamp, TimeUnit.MICROSECONDS);
        if (this.aborted) {
            throw new RuntimeException("Error writing audio stream");
        }
    }

    @Override
    public void close() {
        try {
            if (this.writer != null && this.writer.isOpen()) {
                this.writer.close();
            }
        }
        finally {
            this.writer = null;
        }
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    @Override
    public boolean isRecording() {
        return true;
    }

    private long getTimeStamp() {
        long now = this.context.getTime(Event.Phase.PHI2);
        if (this.firstTimeStamp == 0L) {
            this.firstTimeStamp = now;
        }
        return (long)((double)(now - this.firstTimeStamp) / this.ticksPerMicrosecond);
    }

    protected void configureStreamCoder(IStreamCoder streamCoder, IAudioSection audioSection) {
    }

    protected abstract List<SamplingRate> getSupportedSamplingRates();

    protected abstract SamplingRate getDefaultSamplingRate();

    protected abstract ICodec.ID getAudioCodec();

    protected abstract String getOutputFormatName();

    protected abstract OutputStream getOut(String var1) throws IOException;

    private class AbortingOutputStreamHandler
    extends InputOutputStreamHandler {
        public AbortingOutputStreamHandler(OutputStream out) {
            super(null, out, false);
        }

        public int write(byte[] buf, int size) {
            try {
                if (this.getOpenStream() == null || !(this.getOpenStream() instanceof OutputStream)) {
                    return -1;
                }
                OutputStream stream = (OutputStream)this.getOpenStream();
                stream.write(buf, 0, size);
                return size;
            }
            catch (IOException e) {
                XuggleAudioDriver.this.aborted = true;
                return -1;
            }
        }
    }
}

