/*
 * Decompiled with CFR 0.152.
 */
package ui.gamebase;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.stage.FileChooser;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TFile;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.common.download.DownloadThread;
import ui.common.download.ProgressListener;
import ui.common.fileextension.MDBFileExtensions;
import ui.common.util.DesktopUtil;
import ui.entities.DatabaseType;
import ui.entities.PersistenceProperties;
import ui.entities.config.OnlineSection;
import ui.entities.config.SidPlay2Section;
import ui.entities.gamebase.Games;
import ui.entities.gamebase.service.GamesService;
import ui.gamebase.GameBasePage;

public class GameBase
extends C64VBox
implements UIPart {
    public static final String ID = "GAMEBASE";
    private static final String EXT_MDB = ".mdb";
    private static final String GB64_URL = "http://www.gb64.com";
    @FXML
    protected CheckBox enableGameBase;
    @FXML
    protected TextField dbFileField;
    @FXML
    protected TextField filterField;
    @FXML
    protected TitledPane contents;
    @FXML
    protected TabPane letter;
    @FXML
    protected TextField infos;
    @FXML
    protected TextField programmer;
    @FXML
    protected TextField category;
    @FXML
    protected TextField musician;
    @FXML
    protected TextArea comment;
    @FXML
    protected Button linkMusic;
    @FXML
    protected TextField gameBaseFile;
    private EntityManager em;
    private GamesService gamesService;

    public GameBase() {
    }

    public GameBase(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        this.filterField.setOnKeyReleased(event -> {
            this.letter.getTabs().stream().forEach(tab -> ((GameBasePage)tab.getContent()).filter(""));
            Tab selectedTab = (Tab)this.letter.getSelectionModel().getSelectedItem();
            String trim = this.filterField.getText().trim();
            OptionalInt optionalFilteredFirstChar = trim.chars().map(Character::toUpperCase).findFirst();
            OptionalInt optionalTabFirstChar = selectedTab.getText().chars().findFirst();
            if (optionalFilteredFirstChar.isPresent() && optionalFilteredFirstChar.getAsInt() != optionalTabFirstChar.getAsInt()) {
                selectedTab = this.letter.getTabs().stream().filter(tab -> tab.getText().chars().findFirst().getAsInt() == optionalFilteredFirstChar.getAsInt()).findFirst().orElse((Tab)this.letter.getTabs().stream().findFirst().get());
                this.letter.getSelectionModel().select((Object)selectedTab);
            }
            ((GameBasePage)selectedTab.getContent()).filter(trim);
        });
        this.contents.setPrefHeight(Double.MAX_VALUE);
        this.letter.getTabs().stream().forEach(tab -> ((GameBasePage)tab.getContent()).getGamebaseTable().getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.selectGame((Games)newValue)));
        Platform.runLater(() -> this.setRoot(sidPlay2Section.getGameBase64()));
    }

    @Override
    public void doClose() {
        this.disconnect();
    }

    @FXML
    private void doEnableGameBase() {
        OnlineSection onlineSection = this.util.getConfig().getOnlineSection();
        if (this.enableGameBase.isSelected()) {
            this.enableGameBase.setDisable(true);
            try {
                URL url = new URI(onlineSection.getGamebaseUrl()).toURL();
                DownloadThread downloadThread = new DownloadThread(this.util.getConfig(), new GameBaseListener(this.util, this.letter.getScene()), url, true);
                downloadThread.start();
            }
            catch (MalformedURLException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void downloadMusic() {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        OnlineSection onlineSection = this.util.getConfig().getOnlineSection();
        try {
            URL url = new URI(onlineSection.getGb64MusicUrl() + this.linkMusic.getText().replace('\\', '/')).toURL();
            try (InputStream is = url.openStream();){
                this.util.getPlayer().play(SidTune.load(this.linkMusic.getText(), is));
                this.util.setPlayingTab((Node)this, new ObjectProperty[0]);
            }
        }
        catch (IOException | URISyntaxException | SidTuneError e) {
            System.err.println(e.getMessage());
            File file = IOUtils.getFile(this.linkMusic.getText().replace('\\', '/'), sidPlay2Section.getHvsc(), sidPlay2Section.getCgsc());
            try {
                this.util.getPlayer().play(SidTune.load(file));
                this.util.setPlayingTab((Node)this, new ObjectProperty[0]);
            }
            catch (IOException | SidTuneError e1) {
                e1.printStackTrace();
            }
        }
    }

    @FXML
    private void doBrowse() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("GameBase64 Databases", MDBFileExtensions.EXTENSIONS));
        this.setRoot(fileDialog.showOpenDialog(this.letter.getScene().getWindow()));
    }

    @FXML
    private void gotoURL() {
        DesktopUtil.browse(GB64_URL);
    }

    private void selectGame(Games newValue) {
        if (newValue != null) {
            this.comment.setText(newValue.getComment());
            this.category.setText(this.getCategory(newValue));
            this.infos.setText(this.getInfos(newValue));
            this.musician.setText(newValue.getMusicians().getMusician());
            this.programmer.setText(newValue.getProgrammers().getProgrammer());
            String sidFilename = newValue.getSidFilename();
            this.linkMusic.setDisable(sidFilename == null || sidFilename.isEmpty());
            this.linkMusic.setText(this.linkMusic.isDisable() ? "" : sidFilename);
        }
    }

    private String getInfos(Games newValue) {
        return String.format(this.util.getBundle().getString("PUBLISHER"), newValue.getYears().getYear(), newValue.getPublishers().getPublisher());
    }

    private String getCategory(Games newValue) {
        String genre = newValue.getGenres().getGenre();
        String parentGenre = newValue.getGenres().getParentGenres().getParentGenre();
        if (parentGenre != null && parentGenre.length() != 0) {
            return parentGenre + " - " + genre;
        }
        return genre;
    }

    private void setRoot(final File file) {
        if (file != null && file.exists()) {
            Task<Void> task = new Task<Void>(){

                public Void call() throws Exception {
                    try {
                        GameBase.this.fetchGames(file);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            Thread thread = new Thread((Runnable)task);
            thread.setPriority(1);
            thread.start();
        }
    }

    private void fetchGames(File file) {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        sidPlay2Section.setGameBase64(file);
        Platform.runLater(() -> {
            this.enableGameBase.setDisable(true);
            this.letter.getTabs().stream().forEach(tab -> tab.setDisable(true));
            this.util.progressProperty(this.letter.getScene()).set(-1.0);
        });
        this.connect(file);
        Map gamesForTabs = this.letter.getTabs().stream().collect(Collectors.toMap(Function.identity(), tab -> this.gamesService.select(tab.getText().charAt(0))));
        Platform.runLater(() -> {
            this.letter.getTabs().stream().forEach(tab -> ((GameBasePage)tab.getContent()).setGames((List)gamesForTabs.get(tab)));
            this.enableGameBase.setDisable(false);
            this.letter.getTabs().stream().forEach(tab -> tab.setDisable(false));
            this.letter.getSelectionModel().selectFirst();
            this.filterField.setText("");
            this.gameBaseFile.setText(file.getAbsolutePath());
            this.util.progressProperty(this.letter.getScene()).set(0.0);
        });
    }

    private void connect(File dbFile) {
        if (this.em != null) {
            this.em.close();
        }
        this.em = Persistence.createEntityManagerFactory((String)"gamebase-ds", (Map)new PersistenceProperties(DatabaseType.MSACCESS, "", "", dbFile.getAbsolutePath())).createEntityManager();
        this.gamesService = new GamesService(this.em);
    }

    private void disconnect() {
        if (this.em != null && this.em.isOpen()) {
            this.em.getEntityManagerFactory().close();
        }
    }

    protected final class GameBaseListener
    extends ProgressListener {
        protected GameBaseListener(UIUtil util, Scene scene) {
            super(util, scene);
        }

        @Override
        public void downloaded(File downloadedFile) {
            SidPlay2Section sidplay2 = this.util.getConfig().getSidplay2Section();
            try {
                if (downloadedFile == null) {
                    return;
                }
                File tmpDir = sidplay2.getTmpDir();
                TFile zip = new TFile(downloadedFile);
                TFile.cp_rp((File)zip, (File)tmpDir, (TArchiveDetector)TArchiveDetector.ALL);
                GameBase.this.setRoot(new File(tmpDir, zip.listFiles((dir, name) -> name.endsWith(GameBase.EXT_MDB))[0].getName()));
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater(() -> GameBase.this.enableGameBase.setDisable(false));
            }
        }
    }
}

