/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.plugins.impl.PluginEngine;
import kickass.plugins.impl.PluginMemoryBlock;
import kickass.plugins.impl.PluginValue;
import kickass.plugins.interf.general.IMemoryBlock;
import kickass.plugins.interf.general.IValue;
import kickass.plugins.interf.modifier.IModifier;
import kickass.state.EvaluationState;
import kickass.state.FunctionSideOutput;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentManager;
import kickass.state.segments.SegmentMemoryBlock;

public class ModifyDirective
extends AsmDirective {
    private String name;
    private List<ExprNode> argumentExprs;
    private AsmNode body;
    private boolean isFinished = false;
    private FunctionSideOutput sideOutputFromArguments;
    private byte[] modifiedBytes;
    private Segment modifySegement;
    private SegmentMemoryBlock.Entry memEntry;

    public ModifyDirective(String string, List<ExprNode> list, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.argumentExprs = list;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new ModifyDirective(this.name, this.argumentExprs, this.body.copy(), this.range);
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Object object;
        if (this.modifySegement == null) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
            String string = "<<modify>>";
            this.modifySegement = new Segment(string, this.range);
        }
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        boolean bl = false;
        IValue[] iValueArray = new IValue[this.argumentExprs.size()];
        for (int i = 0; i < iValueArray.length; ++i) {
            object = this.argumentExprs.get(i).evaluate(evaluationState);
            bl |= ((Value)object).isInvalid();
            iValueArray[i] = new PluginValue((Value)object, this.range);
        }
        this.sideOutputFromArguments = evaluationState.sideeffectMgr.getFunctionSideOutput();
        SegmentManager segmentManager = evaluationState.segmentMgr;
        object = evaluationState.segmentMgr.getCurrentSegment();
        this.modifySegement.initPass();
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(this.modifySegement);
        this.body = this.body.executePass(evaluationState);
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect((Segment)object);
        this.modifySegement.close(evaluationState);
        if (bl || !this.body.isFinished()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        if (this.modifiedBytes == null) {
            this.modifySegement.finalize(evaluationState);
            List<IMemoryBlock> list = PluginMemoryBlock.createList(this.modifySegement.getOutputMemoryBlocks());
            IModifier iModifier = evaluationState.namespaceMgr.getSystemNamespace().getModifierPlugins().get(this.name);
            if (iModifier == null) {
                throw new AsmErrorException("Unknown modifyer: " + this.name, this.range);
            }
            PluginEngine pluginEngine = new PluginEngine(evaluationState, this.range);
            this.modifiedBytes = iModifier.execute(list, iValueArray, pluginEngine);
            this.memEntry.fillEntry(this.modifiedBytes, this.range);
        }
        segmentManager.increaseMemoryPosition(this.modifiedBytes.length);
        this.isFinished = true;
        return this;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
        new SideEffectOnlyOutput(this.sideOutputFromArguments).deliverOutput(iOutputReciever);
        this.body.deliverOutput(iOutputReciever);
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.body.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        this.body.executeMetaRegistrations(evaluationState);
        return this;
    }
}

