/*
 * Decompiled with CFR 0.152.
 */
package ui.siddump;

import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Scanner;
import java.util.regex.MatchResult;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.stage.FileChooser;
import javax.xml.parsers.ParserConfigurationException;
import libsidplay.sidtune.SidTune;
import libsidutils.siddump.SIDDumpConfiguration;
import org.xml.sax.SAXException;
import server.netsiddev.InvalidCommandException;
import sidplay.Player;
import sidplay.audio.siddump.SIDDumpExtension;
import sidplay.audio.siddump.SidDumpOutput;
import sidplay.player.State;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.converter.TimeToStringConverter;
import ui.siddump.SidDumpReplayer;

public class SidDump
extends C64VBox
implements UIPart {
    public static final String ID = "SIDDUMP";
    @FXML
    private Button loadDump;
    @FXML
    private Button saveDump;
    @FXML
    private Button stop;
    @FXML
    private ToggleButton replayAll;
    @FXML
    private ToggleButton startStopRecording;
    @FXML
    private CheckBox startStopPlayer;
    @FXML
    private CheckBox timeInSeconds;
    @FXML
    private CheckBox lowResolutionMode;
    @FXML
    private TextField firstFrame;
    @FXML
    private TextField noteSpacing;
    @FXML
    private TextField maxRecordLength;
    @FXML
    private TextField patternSpacing;
    @FXML
    private TextField oldNoteFactor;
    @FXML
    private TextField tableFontSize;
    @FXML
    private TextField baseFreq;
    @FXML
    private TextField baseNote;
    @FXML
    private TextField callsPerFrame;
    @FXML
    private ComboBox<SIDDumpConfiguration.SIDDumpPlayer> regPlayer;
    @FXML
    private TableView<SidDumpOutput> dumpTable;
    private ObservableList<SidDumpOutput> sidDumpOutputs;
    private ObservableList<SIDDumpConfiguration.SIDDumpPlayer> sidDumpPlayers;
    private SIDDumpExtension sidDumpExtension;
    private int loadAddress;
    private int initAddress;
    private int playerAddress;
    private int subTune;
    private double seconds;
    private double recordLength;
    private Thread fPlayerThread;
    private Collection<SIDDumpConfiguration.SIDDumpReg> fRegOrder = null;
    private int fReplayFreq = 50;
    private float leftVolume;
    private SidDumpReplayer replayer;
    private PropertyChangeListener changeListener;

    public SidDump() {
    }

    public SidDump(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.changeListener = event -> {
            if (event.getNewValue() == State.START) {
                Platform.runLater(() -> this.setTune(this.util.getPlayer().getTune()));
            }
            if (event.getNewValue() == State.END) {
                Platform.runLater(() -> {
                    this.startStopRecording.setSelected(false);
                    this.replayAll.setDisable(false);
                    this.stopRecording();
                });
            }
        };
        this.sidDumpExtension = new SIDDumpExtension(){

            @Override
            public void add(SidDumpOutput output) {
                SidDump.this.add(output);
            }

            @Override
            public boolean isAborted() {
                return SidDump.this.isAborted();
            }
        };
        this.util.getPlayer().stateProperty().addListener(this.changeListener);
        this.maxRecordLength.textProperty().addListener((obj, o, n) -> this.util.checkTextField(this.maxRecordLength, () -> {
            this.seconds = new TimeToStringConverter().fromString(this.maxRecordLength.getText()).doubleValue();
            return this.seconds != -1.0;
        }, () -> {
            this.recordLength = this.seconds;
        }, "MAX_RECORD_LENGTH_TIP", "MAX_RECORD_LENGTH_FORMAT"));
        this.sidDumpOutputs = FXCollections.observableArrayList();
        SortedList sortedList = new SortedList(this.sidDumpOutputs);
        sortedList.comparatorProperty().bind((ObservableValue)this.dumpTable.comparatorProperty());
        this.dumpTable.setItems((ObservableList)sortedList);
        this.sidDumpPlayers = FXCollections.observableArrayList();
        this.regPlayer.setItems(this.sidDumpPlayers);
        try {
            SIDDumpConfiguration sidDump = new SIDDumpConfiguration();
            this.sidDumpPlayers.addAll(sidDump.getPlayers());
            this.regPlayer.getSelectionModel().select(0);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.doSetTableFontSize();
        this.setTune(this.util.getPlayer().getTune());
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.changeListener);
        this.util.getPlayer().removeMOS6510Extension(this.sidDumpExtension);
        this.util.getPlayer().removeSidListener(this.sidDumpExtension);
    }

    @FXML
    private void doLoadDump() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        File file = fileDialog.showOpenDialog(this.loadDump.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParentFile());
            this.load(file.getAbsolutePath());
            this.noteSpacing.setText(String.valueOf(this.sidDumpExtension.getNoteSpacing()));
            this.patternSpacing.setText(String.valueOf(this.sidDumpExtension.getPatternSpacing()));
            this.firstFrame.setText(String.valueOf(this.sidDumpExtension.getFirstFrame()));
            this.lowResolutionMode.setSelected(this.sidDumpExtension.getLowRes());
            this.timeInSeconds.setSelected(this.sidDumpExtension.getTimeInSeconds());
        }
    }

    @FXML
    private void doSaveDump() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        File file = fileDialog.showSaveDialog(this.saveDump.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParentFile());
            this.save(file.getAbsolutePath(), this.sidDumpOutputs);
        }
    }

    @FXML
    private void doReplayAll() {
        try {
            while (this.fPlayerThread != null && this.fPlayerThread.isAlive()) {
                this.stopReplay();
                this.fPlayerThread.join(1000L);
                this.fPlayerThread.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.replayAll.isSelected()) {
            this.fPlayerThread = new Thread(() -> {
                try {
                    this.replay(this.sidDumpOutputs);
                }
                catch (InvalidCommandException e) {
                    e.printStackTrace();
                }
                this.replayAll.setSelected(false);
            });
            this.fPlayerThread.start();
        }
    }

    @FXML
    private void doStartStopRecording() {
        if (this.startStopRecording.isSelected()) {
            this.setTune(this.util.getPlayer().getTune());
            this.util.getPlayer().addSidListener(this.sidDumpExtension);
            this.util.getPlayer().addMOS6510Extension(this.sidDumpExtension);
            this.util.setPlayingTab((Node)this, new ObjectProperty[0]);
            if (this.startStopPlayer.isSelected()) {
                this.util.getPlayer().play(this.util.getPlayer().getTune());
            }
        } else {
            this.util.getPlayer().removeSidListener(this.sidDumpExtension);
            this.util.getPlayer().removeMOS6510Extension(this.sidDumpExtension);
            if (this.startStopPlayer.isSelected()) {
                this.util.getPlayer().stopC64();
            }
        }
    }

    @FXML
    private void doSetPlayer() {
        this.fRegOrder = ((SIDDumpConfiguration.SIDDumpPlayer)this.regPlayer.getSelectionModel().getSelectedItem()).getRegs();
    }

    @FXML
    private void doSetNoteSpacing() {
        this.util.checkTextField(this.noteSpacing, () -> Integer.parseInt(this.noteSpacing.getText()) >= 0, () -> {}, "NOTE_SPACING_TIP", "NOTE_SPACING_NEG");
    }

    @FXML
    private void doSetPatternSpacing() {
        this.util.checkTextField(this.patternSpacing, () -> Integer.parseInt(this.patternSpacing.getText()) >= 0, () -> {}, "PATTERN_SPACING_TIP", "PATTERN_SPACING_NEG");
    }

    @FXML
    private void doSetOldNoteFactor() {
        this.util.checkTextField(this.oldNoteFactor, () -> Float.parseFloat(this.oldNoteFactor.getText()) >= 1.0f, () -> {}, "OLD_NOTE_FACTOR_TIP", "OLD_NOTE_FACTOR_NEG");
    }

    @FXML
    private void doSetBaseFreq() {
        this.util.checkTextField(this.baseFreq, () -> Integer.decode(this.baseFreq.getText()) >= 0, () -> {}, "BASE_FREQ_TIP", "BASE_FREQ_HEX");
    }

    @FXML
    private void doSetTableFontSize() {
        this.util.checkTextField(this.tableFontSize, () -> {
            int fontSizeVal = Integer.parseInt(this.tableFontSize.getText());
            return fontSizeVal > 0 && fontSizeVal <= 24;
        }, () -> {
            int fontSizeVal = Integer.parseInt(this.tableFontSize.getText());
            this.dumpTable.setStyle(String.format("-fx-font-size:%d.0px;}", fontSizeVal));
            for (TableColumn column : this.dumpTable.getColumns()) {
                column.setStyle(String.format("-fx-font-size:%d.0px;", fontSizeVal));
            }
        }, "TABLE_FONT_SIZE_TIP", "TABLE_FONT_SIZE_NEG");
    }

    @FXML
    private void doSetBaseNote() {
        this.util.checkTextField(this.baseNote, () -> {
            int baseNoteVal = Integer.decode(this.baseNote.getText());
            return baseNoteVal >= 128 && baseNoteVal <= 223;
        }, () -> {}, "BASE_NOTE_TIP", "BASE_NOTE_HEX");
    }

    @FXML
    private void doSetCallsPerFrame() {
        this.util.checkTextField(this.callsPerFrame, () -> {
            int speed = Integer.parseInt(this.callsPerFrame.getText());
            return speed >= 1;
        }, () -> {
            int speed = Integer.parseInt(this.callsPerFrame.getText());
            this.fReplayFreq = speed * 50;
        }, "CALLS_PER_FRAME_TIP", "CALLS_PER_FRAME_NEG");
    }

    @FXML
    private void doSetFirstFrame() {
        this.util.checkTextField(this.firstFrame, () -> Long.parseLong(this.firstFrame.getText()) >= 0L, () -> {}, "FIRST_FRAME_TIP", "FIRST_FRAME_NEG");
    }

    private void setTune(SidTune tune) {
        if (tune == SidTune.RESET) {
            this.startStopRecording.setDisable(true);
            this.startStopRecording.setTooltip(new Tooltip(this.util.getBundle().getString("NOT_AVAILABLE")));
            return;
        }
        this.startStopRecording.setDisable(tune.getInfo().getPlayAddr() == 0);
        this.loadAddress = tune.getInfo().getLoadAddr();
        this.initAddress = tune.getInfo().getInitAddr();
        this.playerAddress = tune.getInfo().getPlayAddr();
        this.subTune = tune.getInfo().getCurrentSong();
        this.sidDumpExtension.setFirstFrame(Long.parseLong(this.firstFrame.getText()));
        if (this.seconds == 0.0) {
            double length = this.util.getPlayer().getSidDatabaseInfo(db -> db.getSongLength(tune), 0.0);
            if (length == 0.0 && (length = this.util.getConfig().getSidplay2Section().getDefaultPlayLength()) <= 0.0) {
                length = 60.0;
            }
            this.maxRecordLength.setText(new TimeToStringConverter().toString(length));
            this.recordLength = length;
        } else {
            this.recordLength = this.seconds;
        }
        this.sidDumpExtension.setTimeInSeconds(this.timeInSeconds.isSelected());
        this.sidDumpExtension.setOldNoteFactor(Float.parseFloat(this.oldNoteFactor.getText()));
        this.sidDumpExtension.setBaseFreq(Integer.decode(this.baseFreq.getText()));
        this.sidDumpExtension.setBaseNote(Integer.decode(this.baseNote.getText()));
        this.sidDumpExtension.setPatternSpacing(Integer.parseInt(this.patternSpacing.getText()));
        this.sidDumpExtension.setNoteSpacing(Integer.parseInt(this.noteSpacing.getText()));
        this.sidDumpExtension.setLowRes(this.lowResolutionMode.isSelected());
        if (tune.getInfo().getPlayAddr() == 0) {
            this.startStopRecording.setSelected(false);
            this.startStopRecording.setTooltip(new Tooltip(this.util.getBundle().getString("NOT_AVAILABLE")));
        } else {
            this.startStopRecording.setTooltip(new Tooltip(null));
        }
        this.leftVolume = this.util.getConfig().getAudioSection().getMainVolume();
        this.fRegOrder = ((SIDDumpConfiguration.SIDDumpPlayer)this.regPlayer.getSelectionModel().getSelectedItem()).getRegs();
        this.sidDumpExtension.init(this.util.getPlayer().getC64().getClock());
        Platform.runLater(() -> this.sidDumpOutputs.clear());
    }

    public void stopRecording() {
        this.sidDumpExtension.setFrames((long)((double)this.sidDumpExtension.getFirstFrame() + this.seconds * this.util.getPlayer().getC64().getClock().getScreenRefresh()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(String filename) {
        Platform.runLater(() -> this.sidDumpOutputs.clear());
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8));){
            block37: for (int i = 0; i < 7; ++i) {
                String lineContents = br.readLine();
                if (lineContents == null) {
                    System.err.println("unexpected end of file!");
                    return;
                }
                switch (i) {
                    case 0: {
                        String group;
                        int j;
                        Scanner sc = new Scanner(lineContents);
                        sc.useDelimiter("\n");
                        sc.findInLine("Load address: \\$(\\p{XDigit}+) Init address: \\$(\\p{XDigit}+) Play address: \\$(\\p{XDigit}+)");
                        MatchResult result = sc.match();
                        block38: for (j = 0; j < result.groupCount(); ++j) {
                            group = result.group(j + 1);
                            switch (j) {
                                case 0: {
                                    this.loadAddress = this.readNumber(group, 16);
                                    continue block38;
                                }
                                case 1: {
                                    this.initAddress = this.readNumber(group, 16);
                                    continue block38;
                                }
                                case 2: {
                                    this.playerAddress = this.readNumber(group, 16);
                                    continue block38;
                                }
                            }
                        }
                        continue block37;
                    }
                    case 1: {
                        String group;
                        int j;
                        Scanner sc = new Scanner(lineContents);
                        sc.useDelimiter("\n");
                        sc.findInLine("Calling initroutine with subtune (\\d+)");
                        MatchResult result = sc.match();
                        block39: for (j = 0; j < result.groupCount(); ++j) {
                            group = result.group(j + 1);
                            switch (j) {
                                case 0: {
                                    this.subTune = this.readNumber(group, 10) + 1;
                                    continue block39;
                                }
                            }
                        }
                        continue block37;
                    }
                    case 2: {
                        String group;
                        int j;
                        Scanner sc = new Scanner(lineContents);
                        sc.useDelimiter("\n");
                        sc.findInLine("Calling playroutine for (\\d+) frames\\, starting from frame (\\d+)");
                        MatchResult result = sc.match();
                        block40: for (j = 0; j < result.groupCount(); ++j) {
                            group = result.group(j + 1);
                            switch (j) {
                                case 0: {
                                    continue block40;
                                }
                                case 1: {
                                    this.sidDumpExtension.setFirstFrame(this.readNumber(group, 10));
                                    continue block40;
                                }
                            }
                        }
                        continue block37;
                    }
                    case 3: {
                        int j;
                        Scanner sc = new Scanner(lineContents);
                        sc.useDelimiter("\n");
                        sc.findInLine("Middle C frequency is \\$(\\d+)");
                        MatchResult result = sc.match();
                        for (j = 0; j < result.groupCount(); ++j) {
                        }
                        continue block37;
                    }
                }
            }
            try (Scanner sc = new Scanner(br);){
                sc.useDelimiter(" ?\\| ?");
                this.sidDumpExtension.setNoteSpacing(0);
                this.sidDumpExtension.setPatternSpacing(0);
                this.sidDumpExtension.setLowRes(false);
                int fFetchedRow = 0;
                int fPatternNum = 1;
                int fNoteNum = 1;
                int lastFrame = 0;
                block42: do {
                    String next;
                    SidDumpOutput output = new SidDumpOutput();
                    int col = 0;
                    while (sc.hasNext() && (next = sc.next()).trim().length() != 0) {
                        switch (col) {
                            case 0: {
                                int lowresdist;
                                if (next.startsWith("-") || next.startsWith("=")) {
                                    output.setTime(next);
                                    break;
                                }
                                lastFrame = Integer.parseInt(next.trim());
                                if (fFetchedRow == 1 && (lowresdist = lastFrame) != 1) {
                                    this.sidDumpExtension.setLowRes(true);
                                    this.sidDumpExtension.setNoteSpacing(lowresdist);
                                }
                                output.setTime(next);
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                output.setFreq(next.substring(0, 4), col - 1);
                                output.setNote(next.substring(5, 13), col - 1);
                                output.setWf(next.substring(14, 16), col - 1);
                                output.setAdsr(next.substring(17, 21), col - 1);
                                output.setPul(next.substring(22, 25), col - 1);
                                break;
                            }
                            case 4: {
                                output.setFcut(next.substring(0, 4));
                                output.setRc(next.substring(5, 7));
                                output.setTyp(next.substring(8, 11));
                                output.setV(next.substring(12, 13));
                                break;
                            }
                            case 5: {
                                this.add(output);
                                if (next.trim().startsWith("+=")) {
                                    if (this.sidDumpExtension.getPatternSpacing() == 0) {
                                        int nextFrame = lastFrame + this.sidDumpExtension.getNoteSpacing();
                                        this.sidDumpExtension.setPatternSpacing(nextFrame / this.sidDumpExtension.getNoteSpacing());
                                    }
                                    fNoteNum = 1;
                                    fPatternNum = this.addPatternSpacing(fPatternNum);
                                    continue block42;
                                }
                                if (!next.trim().startsWith("+-")) continue block42;
                                if (this.sidDumpExtension.getNoteSpacing() == 0 && !this.sidDumpExtension.getLowRes()) {
                                    this.sidDumpExtension.setNoteSpacing(fFetchedRow);
                                }
                                fNoteNum = this.addNoteSpacing(fNoteNum);
                                continue block42;
                            }
                        }
                        ++col;
                    }
                    this.add(output);
                } while (sc.hasNext());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.stopRecording();
    }

    private int readNumber(String number, int radix) {
        try {
            return Integer.parseInt(number, radix);
        }
        catch (NumberFormatException e) {
            System.err.println(e.getMessage());
            return 0;
        }
    }

    private int addNoteSpacing(int noteNum) {
        SidDumpOutput noteSep = new SidDumpOutput();
        noteSep.setTime(String.format("-N%03X", noteNum++));
        for (int c = 0; c < 3; ++c) {
            noteSep.setFreq("----", c);
            noteSep.setNote("--------", c);
            noteSep.setWf("--", c);
            noteSep.setAdsr("----", c);
            noteSep.setPul("---", c);
        }
        noteSep.setFcut("----");
        noteSep.setRc("--");
        noteSep.setTyp("---");
        noteSep.setV("-");
        this.add(noteSep);
        return noteNum;
    }

    private int addPatternSpacing(int fPatternNum) {
        SidDumpOutput patternSep = new SidDumpOutput();
        patternSep.setTime(String.format("=P%03X", fPatternNum++));
        for (int c = 0; c < 3; ++c) {
            patternSep.setFreq("====", c);
            patternSep.setNote("========", c);
            patternSep.setWf("==", c);
            patternSep.setAdsr("====", c);
            patternSep.setPul("===", c);
        }
        patternSep.setFcut("====");
        patternSep.setRc("==");
        patternSep.setTyp("===");
        patternSep.setV("=");
        this.add(patternSep);
        return fPatternNum;
    }

    public void save(String filename, ObservableList<SidDumpOutput> sidDumpOutputs) {
        try (PrintStream out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(filename)), false, StandardCharsets.UTF_8.name());){
            out.println(String.format("Load address: $%04X Init address: $%04X Play address: $%04X", this.loadAddress, this.initAddress, this.playerAddress));
            out.println("Calling initroutine with subtune " + (this.subTune - 1));
            out.println("Calling playroutine for " + (int)(this.seconds * this.util.getPlayer().getC64().getClock().getScreenRefresh()) + " frames, starting from frame " + this.sidDumpExtension.getFirstFrame());
            out.println(String.format("Middle C frequency is $%04X", this.sidDumpExtension.getMiddleCFreq()));
            out.println();
            out.println("| Frame | Freq Note/Abs WF ADSR Pul | Freq Note/Abs WF ADSR Pul | Freq Note/Abs WF ADSR Pul | FCut RC Typ V |");
            out.println("+-------+---------------------------+---------------------------+---------------------------+---------------+");
            for (SidDumpOutput putput : sidDumpOutputs) {
                out.print("| ");
                out.print(putput.getTime());
                out.print(" | ");
                out.print(putput.getFreq(0));
                out.print(" ");
                out.print(putput.getNote(0));
                out.print(" ");
                out.print(putput.getWf(0));
                out.print(" ");
                out.print(putput.getAdsr(0));
                out.print(" ");
                out.print(putput.getPul(0));
                out.print(" | ");
                out.print(putput.getFreq(1));
                out.print(" ");
                out.print(putput.getNote(1));
                out.print(" ");
                out.print(putput.getWf(1));
                out.print(" ");
                out.print(putput.getAdsr(1));
                out.print(" ");
                out.print(putput.getPul(1));
                out.print(" | ");
                out.print(putput.getFreq(2));
                out.print(" ");
                out.print(putput.getNote(2));
                out.print(" ");
                out.print(putput.getWf(2));
                out.print(" ");
                out.print(putput.getAdsr(2));
                out.print(" ");
                out.print(putput.getPul(2));
                out.print(" | ");
                out.print(putput.getFcut());
                out.print(" ");
                out.print(putput.getRc());
                out.print(" ");
                out.print(putput.getTyp());
                out.print(" ");
                out.print(putput.getV());
                out.println(" |");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void add(SidDumpOutput output) {
        Platform.runLater(() -> this.sidDumpOutputs.add((Object)output));
    }

    public boolean isAborted() {
        return this.sidDumpExtension.getFrames() > (long)((double)this.sidDumpExtension.getFirstFrame() + this.recordLength * this.util.getPlayer().getC64().getClock().getScreenRefresh());
    }

    public void replay(ObservableList<SidDumpOutput> sidDumpOutputs) throws InvalidCommandException {
        this.replayer = new SidDumpReplayer(this.util.getPlayer().getConfig());
        this.replayer.setLeftVolume(this.leftVolume);
        this.replayer.setRegOrder(this.fRegOrder);
        this.replayer.setReplayFrequency(this.fReplayFreq);
        this.replayer.replay(sidDumpOutputs);
    }

    public void stopReplay() {
        this.replayer.stopReplay();
    }
}

