/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.io.File;
import java.io.IOException;
import libsidplay.common.Event;
import libsidplay.components.c1541.DiskImage;
import libsidplay.components.c1541.Rotation;
import libsidplay.components.c1541.VIACore;
import libsidplay.components.mos6510.MOS6510;

public abstract class VIA6522DC
extends VIACore {
    private static final int DRIVE_ATTACH_DELAY = 1800000;
    private static final int DRIVE_DETACH_DELAY = 600000;
    private static final int DRIVE_ATTACH_DETACH_DELAY = 1200000;
    private long attachClk;
    private long detachClk;
    private long attachDetachClk;
    private byte gcrRead;
    private byte gcrWrite;
    private Mode readWriteMode;
    private int byteReadyActive;
    private boolean gcrDataDirty;
    private int currentHalfTrack;
    private final Rotation rot;
    private DiskImage image;
    private final int id;

    public VIA6522DC(int deviceID, final MOS6510 cpu) {
        super("1541Drive" + deviceID + "VIA6522DC");
        this.id = deviceID;
        this.rot = new Rotation(){

            @Override
            protected long cpuClk() {
                return cpu.getEventScheduler().getTime(Event.Phase.PHI2);
            }

            @Override
            protected final Mode getReadWriteMode() {
                return VIA6522DC.this.getMode();
            }

            @Override
            protected void readData(byte readData) {
                VIA6522DC.this.setLastGCRRead(readData);
                if (VIA6522DC.this.isByteReadyActive()) {
                    cpu.setFlagV(true);
                    VIA6522DC.this.signal(0, 1);
                }
            }

            @Override
            protected byte writeData() {
                byte writeData = VIA6522DC.this.getLastGCRWrite();
                if (VIA6522DC.this.isByteReadyActive()) {
                    cpu.setFlagV(true);
                    VIA6522DC.this.signal(0, 1);
                }
                return writeData;
            }

            @Override
            protected int getCurrentTrackSize() {
                if (VIA6522DC.this.getImage() != null) {
                    return VIA6522DC.this.getImage().trackSize[(VIA6522DC.this.getHalfTrack() >> 1) - 1];
                }
                return DiskImage.RAW_TRACK_SIZE[DiskImage.SPEED_MAP_1541[(VIA6522DC.this.getHalfTrack() >> 1) - 1]];
            }

            @Override
            protected final void setDirty() {
                VIA6522DC.this.setGCRDataDirty();
            }

            @Override
            protected final boolean isDiskChangeInProgress() {
                return VIA6522DC.this.getAttachClk() != 0L;
            }
        };
    }

    @Override
    public final void reset() {
        this.attachClk = 0L;
        this.detachClk = 0L;
        this.attachDetachClk = 0L;
        this.gcrRead = 0;
        this.gcrWrite = (byte)85;
        this.byteReadyActive = 0;
        this.readWriteMode = Mode.READ;
        this.gcrDataDirty = false;
        this.currentHalfTrack = 2;
        this.setHalfTrack(36);
        super.reset();
        this.rot.reset();
    }

    protected DiskImage getImage() {
        return this.image;
    }

    public DiskImage insertDisk(File file) throws IOException {
        this.ejectDisk();
        this.attachClk = this.cpuClk();
        if (this.detachClk > 0L) {
            this.attachDetachClk = this.cpuClk();
        }
        this.image = DiskImage.attach(this.rot.getGCR(), file);
        this.rot.getGCR().attach();
        System.out.printf("Unit %d: " + this.image.getClass().getSimpleName() + " disk image attached: %s.\n", this.id, file.getAbsolutePath());
        this.diskAttachedDetached(file.getName(), true);
        return this.image;
    }

    public void ejectDisk() throws IOException {
        if (this.image != null) {
            this.gcrDataWriteback();
            this.detachClk = this.cpuClk();
            this.rot.getGCR().detach();
            this.image.detach();
            System.out.printf("Unit %d: " + this.image.getClass().getSimpleName() + " disk image detached: %s.\n", this.id, this.image.fileName);
            this.diskAttachedDetached(this.image.fileName, false);
            this.image = null;
        }
    }

    public long getAttachClk() {
        return this.attachClk;
    }

    protected void setHalfTrack(int num) {
        int oldTrackSize = this.rot.getCurrentTrackSize();
        this.currentHalfTrack = num;
        this.rot.getGCR().setHalfTrack(num, oldTrackSize, this.rot.getCurrentTrackSize());
    }

    public int getHalfTrack() {
        return this.currentHalfTrack;
    }

    protected void moveHead(boolean forward) {
        this.gcrDataWriteback();
        if (forward && this.currentHalfTrack < 84) {
            this.setHalfTrack(this.currentHalfTrack + 1);
        }
        if (!forward && this.currentHalfTrack > 2) {
            this.setHalfTrack(this.currentHalfTrack - 1);
        }
    }

    protected void gcrDataWriteback() {
        boolean isDirty = this.gcrDataDirty;
        this.gcrDataDirty = false;
        if (this.image == null || !isDirty) {
            return;
        }
        if (this.image.readOnly) {
            System.err.println("Attempt to write to read-only disk image.");
        } else {
            try {
                this.image.gcrDataWriteback(this.currentHalfTrack >> 1);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.err.println(String.format("Error writing T:%d to disk image.", this.currentHalfTrack >> 1));
            }
        }
    }

    public final boolean isLEDOn() {
        return (this.oldpb & 8) != 0;
    }

    public final boolean isMotorOn() {
        return (this.byteReadyActive & 4) != 0;
    }

    @Override
    protected final void setCa2(int state) {
        this.rotateDisk();
        this.byteReadyActive = this.byteReadyActive & 0xFFFFFFFD | state << 1;
    }

    @Override
    protected final void setCb2(int state) {
        this.rotateDisk();
        this.readWriteMode = state != 0 ? Mode.READ : Mode.WRITE;
    }

    protected Mode getMode() {
        return this.readWriteMode;
    }

    @Override
    protected final void storePra(int addr, byte byt) {
        this.rotateDisk();
        this.gcrWrite = byt;
    }

    protected final byte getLastGCRWrite() {
        return this.gcrWrite;
    }

    @Override
    protected final void storePrb(byte byt) {
        this.rotateDisk();
        if (((this.oldpb ^ byt) & 3) != 0 && (byt & 4) != 0) {
            if ((this.oldpb & 3) == (byt + 1 & 3)) {
                this.moveHead(false);
            } else if ((this.oldpb & 3) == (byt - 1 & 3)) {
                this.moveHead(true);
            }
        }
        if (((this.oldpb ^ byt) & 0x60) != 0) {
            this.rot.setSpeedZone((byt & 0xFF) >> 5 & 3);
        }
        if (((this.oldpb ^ byt) & 4) != 0) {
            this.byteReadyActive = this.byteReadyActive & 0xFFFFFFFB | byt & 4;
            if (this.isMotorOn()) {
                this.rot.rotationBegins();
            }
        }
    }

    @Override
    protected final void storeAcr(byte value) {
    }

    @Override
    protected final void storeSr(byte value) {
    }

    @Override
    protected final void storeT2l(byte value) {
    }

    @Override
    protected final byte readPra() {
        this.byteRead();
        int encoderDecoderValue = this.readWriteMode == Mode.READ ? (int)this.gcrRead : -1;
        return (byte)(encoderDecoderValue & ~this.via[3] | this.via[1] & this.via[3]);
    }

    protected final void setLastGCRRead(byte lastReadData) {
        this.gcrRead = lastReadData;
    }

    @Override
    protected final byte readPrb() {
        this.rotateDisk();
        return (byte)((this.rot.syncFound() | this.writeProtectSense()) & ~this.via[2] | this.via[0] & this.via[2]);
    }

    protected final boolean isByteReadyActive() {
        return (this.byteReadyActive & 2) != 0;
    }

    protected final void rotateDisk() {
        if (this.isMotorOn()) {
            this.rot.rotateDisk();
        }
    }

    protected void setGCRDataDirty() {
        this.gcrDataDirty = true;
    }

    private void byteRead() {
        if (this.attachClk != 0L) {
            if (this.cpuClk() - this.attachClk < 1800000L) {
                this.gcrRead = 0;
            } else {
                this.attachClk = 0L;
            }
        } else if (this.attachDetachClk != 0L) {
            if (this.cpuClk() - this.attachDetachClk < 1200000L) {
                this.gcrRead = 0;
            } else {
                this.attachDetachClk = 0L;
            }
        } else {
            this.rotateDisk();
        }
    }

    private byte writeProtectSense() {
        if (this.detachClk != 0L) {
            if (this.cpuClk() - this.detachClk < 600000L) {
                return 0;
            }
            this.detachClk = 0L;
        }
        if (this.attachDetachClk != 0L) {
            if (this.cpuClk() - this.attachDetachClk < 1200000L) {
                return 16;
            }
            this.attachDetachClk = 0L;
        }
        if (this.attachClk != 0L) {
            if (this.cpuClk() - this.attachClk < 1800000L) {
                return 0;
            }
            this.attachClk = 0L;
        }
        if (this.image == null || !this.image.isReadOnly()) {
            return 16;
        }
        return 0;
    }

    public abstract void diskAttachedDetached(String var1, boolean var2);

    static enum Mode {
        READ,
        WRITE;

    }
}

