/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BinaryUUIDType;
import org.hsqldb.types.BitType;
import org.hsqldb.types.BlobType;
import org.hsqldb.types.BooleanType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Charset;
import org.hsqldb.types.ClobType;
import org.hsqldb.types.Collation;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NullType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.OtherType;
import org.hsqldb.types.UserTypeModifier;

public abstract class Type
implements SchemaObject,
Cloneable {
    public static final Type[] emptyArray = new Type[0];
    public final int typeComparisonGroup;
    public final int typeDataGroup;
    public final int typeCode;
    public final long precision;
    public final int scale;
    public UserTypeModifier userTypeModifier;
    public static final Type SQL_ALL_TYPES = NullType.getNullType();
    public static final CharacterType SQL_CHAR = new CharacterType(1, 1L);
    public static final CharacterType SQL_CHAR_UUID = new CharacterType(1, 36L);
    public static final CharacterType SQL_CHAR_DEFAULT = new CharacterType(1, 256L);
    public static final CharacterType SQL_VARCHAR = new CharacterType(12, 0L);
    public static final CharacterType SQL_VARCHAR_DEFAULT = new CharacterType(12, 32768L);
    public static final ClobType SQL_CLOB = new ClobType(0x40000000L);
    public static final BitType SQL_BIT = new BitType(14, 1L);
    public static final BitType SQL_BIT_VARYING = new BitType(15, 1L);
    public static final BitType SQL_BIT_VARYING_MAX_LENGTH = new BitType(15, 1024L);
    public static final BinaryType SQL_BINARY = new BinaryType(60, 1L);
    public static final BinaryType SQL_BINARY_16 = new BinaryType(60, 16L);
    public static final BinaryType SQL_BINARY_DEFAULT = new BinaryType(60, 32768L);
    public static final BinaryType SQL_VARBINARY = new BinaryType(61, 0L);
    public static final BinaryType SQL_VARBINARY_DEFAULT = new BinaryType(61, 32768L);
    public static final BlobType SQL_BLOB = new BlobType(0x40000000L);
    public static final BinaryUUIDType SQL_GUID = new BinaryUUIDType();
    public static final OtherType OTHER = OtherType.getOtherType();
    public static final BooleanType SQL_BOOLEAN = BooleanType.getBooleanType();
    public static final NumberType SQL_NUMERIC = new NumberType(2, 128L, 0);
    public static final NumberType SQL_DECIMAL = new NumberType(3, 128L, 0);
    public static final NumberType SQL_DECIMAL_DEFAULT = new NumberType(3, 128L, 32);
    public static final NumberType SQL_DECIMAL_BIGINT_SQR = new NumberType(3, 40L, 0);
    public static final NumberType SQL_DOUBLE = new NumberType(8, 0L, 0);
    public static final NumberType TINYINT = new NumberType(-6, 3L, 0);
    public static final NumberType SQL_SMALLINT = new NumberType(5, 5L, 0);
    public static final NumberType SQL_INTEGER = new NumberType(4, 10L, 0);
    public static final NumberType SQL_BIGINT = new NumberType(25, 19L, 0);
    public static final DateTimeType SQL_DATE = new DateTimeType(93, 91, 0);
    public static final DateTimeType SQL_TIME = new DateTimeType(92, 92, 0);
    public static final DateTimeType SQL_TIME_MAX = new DateTimeType(92, 92, 9);
    public static final DateTimeType SQL_TIME_WITH_TIME_ZONE = new DateTimeType(92, 94, 0);
    public static final DateTimeType SQL_TIMESTAMP = new DateTimeType(93, 93, 6);
    public static final DateTimeType SQL_TIMESTAMP_WITH_TIME_ZONE = new DateTimeType(93, 95, 6);
    public static final DateTimeType SQL_TIMESTAMP_NO_FRACTION = new DateTimeType(93, 93, 0);
    public static final DateTimeType SQL_TIMESTAMP_WITH_TIME_ZONE_MAX = new DateTimeType(93, 95, 9);
    public static final IntervalType SQL_INTERVAL_YEAR = IntervalType.newIntervalType(101, 2L, 0);
    public static final IntervalType SQL_INTERVAL_MONTH = IntervalType.newIntervalType(102, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY = IntervalType.newIntervalType(103, 2L, 0);
    public static final IntervalType SQL_INTERVAL_HOUR = IntervalType.newIntervalType(104, 2L, 0);
    public static final IntervalType SQL_INTERVAL_MINUTE = IntervalType.newIntervalType(105, 2L, 0);
    public static final IntervalType SQL_INTERVAL_SECOND = IntervalType.newIntervalType(106, 2L, 6);
    public static final IntervalType SQL_INTERVAL_SECOND_MAX_FRACTION = IntervalType.newIntervalType(106, 2L, 9);
    public static final IntervalType SQL_INTERVAL_YEAR_TO_MONTH = IntervalType.newIntervalType(107, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_HOUR = IntervalType.newIntervalType(108, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_MINUTE = IntervalType.newIntervalType(109, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_SECOND = IntervalType.newIntervalType(110, 2L, 6);
    public static final IntervalType SQL_INTERVAL_HOUR_TO_MINUTE = IntervalType.newIntervalType(111, 2L, 0);
    public static final IntervalType SQL_INTERVAL_HOUR_TO_SECOND = IntervalType.newIntervalType(112, 2L, 6);
    public static final IntervalType SQL_INTERVAL_MINUTE_TO_SECOND = IntervalType.newIntervalType(113, 2L, 6);
    public static final IntervalType SQL_INTERVAL_YEAR_MAX_PRECISION = IntervalType.newIntervalType(101, 9L, 0);
    public static final IntervalType SQL_INTERVAL_MONTH_MAX_PRECISION = IntervalType.newIntervalType(102, 9L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_MAX_PRECISION = IntervalType.newIntervalType(103, 9L, 0);
    public static final IntervalType SQL_INTERVAL_HOUR_MAX_PRECISION = IntervalType.newIntervalType(104, 9L, 0);
    public static final IntervalType SQL_INTERVAL_MINUTE_MAX_PRECISION = IntervalType.newIntervalType(105, 9L, 0);
    public static final IntervalType SQL_INTERVAL_SECOND_MAX_PRECISION = IntervalType.newIntervalType(106, 12L, 6);
    public static final IntervalType SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION = IntervalType.newIntervalType(106, 12L, 9);
    public static final IntervalType SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION = IntervalType.newIntervalType(107, 9L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION = IntervalType.newIntervalType(110, 9L, 9);
    public static final ArrayType SQL_ARRAY_ALL_TYPES = new ArrayType(SQL_ALL_TYPES, 0x100000);
    public static final IntValueHashMap typeAliases;
    public static final IntValueHashMap typeNames;
    public static final IntKeyHashMap jdbcConvertTypes;

    Type(int n, int n2, long l, int n3) {
        this.typeComparisonGroup = n;
        this.typeCode = n2;
        this.precision = l;
        this.scale = n3;
        this.typeDataGroup = this.typeCode == 1 ? 12 : this.typeCode;
    }

    @Override
    public final int getType() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getType();
    }

    @Override
    public final HsqlNameManager.HsqlName getName() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getName();
    }

    @Override
    public final HsqlNameManager.HsqlName getSchemaName() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getSchemaName();
    }

    @Override
    public final HsqlNameManager.HsqlName getCatalogName() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getSchemaName().schema;
    }

    @Override
    public final Grantee getOwner() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getOwner();
    }

    @Override
    public final OrderedHashSet getReferences() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getReferences();
    }

    @Override
    public final OrderedHashSet getComponents() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getComponents();
    }

    @Override
    public final void compile(Session session, SchemaObject schemaObject) {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        this.userTypeModifier.compile(session);
    }

    @Override
    public String getSQL() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getSQL();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public Type duplicate() {
        try {
            return (Type)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "Type");
        }
    }

    public abstract int displaySize();

    public abstract int getJDBCTypeCode();

    public abstract String getJDBCClassName();

    public abstract Class getJDBCClass();

    public int getJDBCScale() {
        return this.scale;
    }

    public int getJDBCPrecision() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    public abstract String getNameString();

    public String getFullNameString() {
        return this.getNameString();
    }

    public abstract String getDefinition();

    public Collation getCollation() {
        return null;
    }

    public Charset getCharacterSet() {
        return null;
    }

    public final String getTypeDefinition() {
        if (this.userTypeModifier == null) {
            return this.getDefinition();
        }
        return this.getName().getSchemaQualifiedStatementName();
    }

    public abstract int compare(Session var1, Object var2, Object var3);

    public int compare(Session session, Object object, Object object2, int n) {
        if (object == object2) {
            return 0;
        }
        return this.compare(session, object, object2);
    }

    public int compare(Session session, Object object, Object object2, SortAndSlice sortAndSlice) {
        if (object == object2) {
            return 0;
        }
        if (sortAndSlice == null) {
            return this.compare(session, object, object2);
        }
        if (object == null) {
            return sortAndSlice.sortNullsLast[0] ? 1 : -1;
        }
        if (object2 == null) {
            return sortAndSlice.sortNullsLast[0] ? -1 : 1;
        }
        int n = this.compare(session, object, object2);
        return sortAndSlice.sortDescending[0] ? -n : n;
    }

    public abstract Object convertToTypeLimits(SessionInterface var1, Object var2);

    public Object castToType(SessionInterface sessionInterface, Object object, Type type) {
        return this.convertToType(sessionInterface, object, type);
    }

    public abstract Object convertToType(SessionInterface var1, Object var2, Type var3);

    public Object convertToTypeJDBC(SessionInterface sessionInterface, Object object, Type type) {
        if (type.isLobType()) {
            throw Error.error(5561);
        }
        return this.convertToType(sessionInterface, object, type);
    }

    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        return object;
    }

    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        return object;
    }

    public abstract Object convertToDefaultType(SessionInterface var1, Object var2);

    public abstract String convertToString(Object var1);

    public abstract String convertToSQLString(Object var1);

    public abstract boolean canConvertFrom(Type var1);

    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        return -1;
    }

    public boolean canBeAssignedFrom(Type type) {
        if (type == null) {
            return true;
        }
        return type.typeCode == 0 || this.typeComparisonGroup == type.typeComparisonGroup;
    }

    public boolean canCompareDirect(Type type) {
        return this.typeComparisonGroup == type.typeComparisonGroup;
    }

    public int arrayLimitCardinality() {
        return 0;
    }

    public Type collectionBaseType() {
        return null;
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isMultisetType() {
        return false;
    }

    public boolean isRowType() {
        return false;
    }

    public boolean isStructuredType() {
        return false;
    }

    public boolean isCharacterType() {
        return false;
    }

    public boolean isNumberType() {
        return false;
    }

    public boolean isIntegralType() {
        return false;
    }

    public boolean isExactNumberType() {
        return false;
    }

    public boolean isDecimalType() {
        return false;
    }

    public boolean isDateTimeType() {
        return false;
    }

    public boolean isDateTimeTypeWithZone() {
        return false;
    }

    public boolean isDateOrTimestampType() {
        return false;
    }

    public boolean isTimestampType() {
        return false;
    }

    public boolean isTimeType() {
        return false;
    }

    public boolean isIntervalType() {
        return false;
    }

    public boolean isIntervalYearMonthType() {
        return false;
    }

    public boolean isIntervalDaySecondType() {
        return false;
    }

    public boolean isBinaryType() {
        return false;
    }

    public boolean isUUIDType() {
        return false;
    }

    public boolean isBooleanType() {
        return false;
    }

    public boolean isLobType() {
        return false;
    }

    public boolean isBitType() {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public boolean isDistinctType() {
        return this.userTypeModifier == null ? false : this.userTypeModifier.schemaObjectType == 12;
    }

    public boolean isDomainType() {
        return this.userTypeModifier == null ? false : this.userTypeModifier.schemaObjectType == 13;
    }

    public int getDegree() {
        return 1;
    }

    public boolean acceptsPrecision() {
        return false;
    }

    public boolean requiresPrecision() {
        return false;
    }

    public long getMaxPrecision() {
        return 0L;
    }

    public int getMaxScale() {
        return 0;
    }

    public int getPrecisionRadix() {
        return 0;
    }

    public boolean acceptsFractionalPrecision() {
        return false;
    }

    public boolean acceptsScale() {
        return false;
    }

    public int precedenceDegree(Type type) {
        if (type.typeCode == this.typeCode) {
            if (this.typeCode == 50) {
                return this.collectionBaseType().precedenceDegree(type.collectionBaseType());
            }
            return 0;
        }
        return Integer.MIN_VALUE;
    }

    public abstract Type getAggregateType(Type var1);

    public abstract Type getCombinedType(Session var1, Type var2, int var3);

    public int compareToTypeRange(Object object) {
        return 0;
    }

    public Object absolute(Object object) {
        throw Error.runtimeError(201, "Type");
    }

    public Object negate(Object object) {
        throw Error.runtimeError(201, "Type");
    }

    public Object add(Session session, Object object, Object object2, Type type) {
        throw Error.runtimeError(201, "Type");
    }

    public Object subtract(Session session, Object object, Object object2, Type type) {
        throw Error.runtimeError(201, "Type");
    }

    public Object multiply(Object object, Object object2) {
        throw Error.runtimeError(201, "Type");
    }

    public Object divide(Session session, Object object, Object object2) {
        throw Error.runtimeError(201, "Type");
    }

    public Object concat(Session session, Object object, Object object2) {
        throw Error.runtimeError(201, "Type");
    }

    public int cardinality(Session session, Object object) {
        return 0;
    }

    public boolean isNegative(Object object) {
        return false;
    }

    public int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Type) {
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Type)object).typeCode == this.typeCode && ((Type)object).precision == this.precision && ((Type)object).scale == this.scale && ((Type)object).userTypeModifier == this.userTypeModifier;
        }
        return false;
    }

    public int hashCode() {
        return this.typeCode + ((int)this.precision << 8) + (this.scale << 16);
    }

    public static ArrayType getDefaultArrayType(int n) {
        return new ArrayType(Type.getDefaultType(n), 0x100000);
    }

    public static Type getDefaultType(int n) {
        try {
            return Type.getType(n, SQL_VARCHAR.getCharacterSet(), SQL_VARCHAR.getCollation(), 0L, 0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Type getDefaultTypeWithSize(int n) {
        switch (n) {
            case 0: {
                return SQL_ALL_TYPES;
            }
            case 50: {
                return SQL_ARRAY_ALL_TYPES;
            }
            case 1: {
                return SQL_CHAR_DEFAULT;
            }
            case 12: {
                return SQL_VARCHAR_DEFAULT;
            }
            case 40: {
                return SQL_CLOB;
            }
            case 4: {
                return SQL_INTEGER;
            }
            case 5: {
                return SQL_SMALLINT;
            }
            case 25: {
                return SQL_BIGINT;
            }
            case -6: {
                return TINYINT;
            }
            case 6: 
            case 7: 
            case 8: {
                return SQL_DOUBLE;
            }
            case 2: {
                return SQL_NUMERIC;
            }
            case 3: {
                return SQL_DECIMAL;
            }
            case 16: {
                return SQL_BOOLEAN;
            }
            case 60: {
                return SQL_BINARY_DEFAULT;
            }
            case 61: {
                return SQL_VARBINARY_DEFAULT;
            }
            case -11: {
                return SQL_GUID;
            }
            case 30: {
                return SQL_BLOB;
            }
            case 14: {
                return SQL_BIT;
            }
            case 15: {
                return SQL_BIT_VARYING;
            }
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                return SQL_TIME;
            }
            case 94: {
                return SQL_TIME_WITH_TIME_ZONE;
            }
            case 93: {
                return SQL_TIMESTAMP;
            }
            case 95: {
                return SQL_TIMESTAMP_WITH_TIME_ZONE;
            }
            case 101: {
                return SQL_INTERVAL_YEAR;
            }
            case 107: {
                return SQL_INTERVAL_YEAR_TO_MONTH;
            }
            case 102: {
                return SQL_INTERVAL_MONTH;
            }
            case 103: {
                return SQL_INTERVAL_DAY;
            }
            case 108: {
                return SQL_INTERVAL_DAY_TO_HOUR;
            }
            case 109: {
                return SQL_INTERVAL_DAY_TO_MINUTE;
            }
            case 110: {
                return SQL_INTERVAL_DAY_TO_SECOND;
            }
            case 104: {
                return SQL_INTERVAL_HOUR;
            }
            case 111: {
                return SQL_INTERVAL_HOUR_TO_MINUTE;
            }
            case 112: {
                return SQL_INTERVAL_HOUR_TO_SECOND;
            }
            case 105: {
                return SQL_INTERVAL_MINUTE;
            }
            case 113: {
                return SQL_INTERVAL_MINUTE_TO_SECOND;
            }
            case 106: {
                return SQL_INTERVAL_SECOND;
            }
            case 1111: {
                return OTHER;
            }
        }
        return null;
    }

    public static int getHSQLDBTypeCode(int n) {
        switch (n) {
            case -5: {
                return 25;
            }
            case -1: {
                return 12;
            }
            case 2005: {
                return 40;
            }
            case -2: {
                return 60;
            }
            case -7: {
                return 15;
            }
            case -4: 
            case -3: {
                return 61;
            }
            case 2004: {
                return 30;
            }
            case 2003: {
                return 50;
            }
        }
        return n;
    }

    public static int getJDBCTypeCode(int n) {
        switch (n) {
            case 30: {
                return 2004;
            }
            case 40: {
                return 2005;
            }
            case 25: {
                return -5;
            }
            case 60: {
                return -2;
            }
            case 61: {
                return -3;
            }
            case 14: 
            case 15: {
                return -7;
            }
            case 50: {
                return 2003;
            }
        }
        return n;
    }

    public static Type getType(Type type, Collation collation) {
        if (type.getCollation() == collation) {
            return type;
        }
        if (type.isCharacterType()) {
            type = new CharacterType(collation, type.typeCode, type.precision);
        }
        return type;
    }

    public static Type getType(int n, Charset charset, Collation collation, long l, int n2) {
        switch (n) {
            case 0: {
                return SQL_ALL_TYPES;
            }
            case 1: 
            case 12: 
            case 40: {
                return CharacterType.getCharacterType(n, l, collation);
            }
            case 4: {
                return SQL_INTEGER;
            }
            case 5: {
                return SQL_SMALLINT;
            }
            case 25: {
                return SQL_BIGINT;
            }
            case -6: {
                return TINYINT;
            }
            case 6: {
                if (l > 53L) {
                    throw Error.error(5592, "" + l);
                }
                return SQL_DOUBLE;
            }
            case 7: 
            case 8: {
                return SQL_DOUBLE;
            }
            case 2: 
            case 3: {
                if (l == 0L) {
                    l = 128L;
                }
                return NumberType.getNumberType(n, l, n2);
            }
            case 16: {
                return SQL_BOOLEAN;
            }
            case 30: 
            case 60: 
            case 61: {
                return BinaryType.getBinaryType(n, l);
            }
            case -11: {
                return SQL_GUID;
            }
            case 14: 
            case 15: {
                return BitType.getBitType(n, l);
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return DateTimeType.getDateTimeType(n, n2);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return IntervalType.getIntervalType(n, l, n2);
            }
            case 1111: {
                return OTHER;
            }
        }
        throw Error.runtimeError(201, "Type");
    }

    public static Type getAggregateType(Type type, Type type2) {
        if (type2 == null || type2.typeCode == 0) {
            return type;
        }
        if (type == null || type.typeCode == 0) {
            return type2;
        }
        return type2.getAggregateType(type);
    }

    public static int getTypeNr(String string) {
        int n = typeNames.get((Object)string, Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            n = typeAliases.get((Object)string, Integer.MIN_VALUE);
        }
        return n;
    }

    public static Type getTypeForJDBCConvertToken(int n) {
        return (Type)jdbcConvertTypes.get(n);
    }

    public static boolean isSupportedSQLType(int n) {
        return Type.getDefaultType(n) != null;
    }

    public static boolean matches(Type[] typeArray, Type[] typeArray2) {
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i].typeCode == typeArray2[i].typeCode) continue;
            return false;
        }
        return true;
    }

    static {
        typeNames = new IntValueHashMap(37);
        typeNames.put("CHARACTER", 1);
        typeNames.put("VARCHAR", 12);
        typeNames.put("VARCHAR_IGNORECASE", 100);
        typeNames.put("NVARCHAR", 12);
        typeNames.put("DATE", 91);
        typeNames.put("TIME", 92);
        typeNames.put("TIMESTAMP", 93);
        typeNames.put("INTERVAL", 10);
        typeNames.put("TINYINT", -6);
        typeNames.put("SMALLINT", 5);
        typeNames.put("INTEGER", 4);
        typeNames.put("BIGINT", 25);
        typeNames.put("REAL", 7);
        typeNames.put("FLOAT", 6);
        typeNames.put("DOUBLE", 8);
        typeNames.put("NUMERIC", 2);
        typeNames.put("DECIMAL", 3);
        typeNames.put("BOOLEAN", 16);
        typeNames.put("BINARY", 60);
        typeNames.put("VARBINARY", 61);
        typeNames.put("CLOB", 40);
        typeNames.put("BLOB", 30);
        typeNames.put("BIT", 14);
        typeNames.put("OTHER", 1111);
        typeNames.put("UUID", -11);
        typeAliases = new IntValueHashMap(64);
        typeAliases.put("CHAR", 1);
        typeAliases.put("INT", 4);
        typeAliases.put("DEC", 3);
        typeAliases.put("LONGVARCHAR", -1);
        typeAliases.put("DATETIME", 93);
        typeAliases.put("LONGVARBINARY", -4);
        typeAliases.put("OBJECT", 1111);
        jdbcConvertTypes = new IntKeyHashMap(37);
        jdbcConvertTypes.put(956, SQL_CHAR_DEFAULT);
        jdbcConvertTypes.put(979, SQL_VARCHAR_DEFAULT);
        jdbcConvertTypes.put(966, SQL_VARCHAR_DEFAULT);
        jdbcConvertTypes.put(970, SQL_VARCHAR_DEFAULT);
        jdbcConvertTypes.put(958, SQL_DATE);
        jdbcConvertTypes.put(975, SQL_TIME);
        jdbcConvertTypes.put(976, SQL_TIMESTAMP);
        jdbcConvertTypes.put(977, TINYINT);
        jdbcConvertTypes.put(974, SQL_SMALLINT);
        jdbcConvertTypes.put(963, SQL_INTEGER);
        jdbcConvertTypes.put(951, SQL_BIGINT);
        jdbcConvertTypes.put(971, SQL_DOUBLE);
        jdbcConvertTypes.put(962, SQL_DOUBLE);
        jdbcConvertTypes.put(961, SQL_DOUBLE);
        jdbcConvertTypes.put(969, SQL_NUMERIC);
        jdbcConvertTypes.put(959, SQL_DECIMAL);
        jdbcConvertTypes.put(955, SQL_BOOLEAN);
        jdbcConvertTypes.put(952, SQL_BINARY_DEFAULT);
        jdbcConvertTypes.put(978, SQL_VARBINARY_DEFAULT);
        jdbcConvertTypes.put(964, SQL_VARBINARY_DEFAULT);
        jdbcConvertTypes.put(957, SQL_CLOB);
        jdbcConvertTypes.put(954, SQL_BLOB);
        jdbcConvertTypes.put(953, SQL_BIT);
    }
}

