/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.cart.supported.core.FMOPL_072;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class SFXSoundExpander
extends Cartridge {
    private final int type;
    private final EventScheduler context;
    private FMOPL_072.FM_OPL fmOpl;
    private long lastTime;
    private final Bank io2Bank = new Bank(){

        @Override
        public byte read(int addr) {
            SFXSoundExpander.this.clock();
            return (byte)((addr & 0xFF) == 96 ? FMOPL_072.read(SFXSoundExpander.this.fmOpl, 0) : (int)SFXSoundExpander.this.pla.getDisconnectedBusBank().read(addr));
        }

        @Override
        public void write(int addr, byte val) {
            SFXSoundExpander.this.clock();
            if ((addr & 0xFF) == 64 || (addr & 0xFF) == 80) {
                FMOPL_072.write(SFXSoundExpander.this.fmOpl, (addr & 0xFF) == 64 ? 0 : 1, val & 0xFF);
            }
        }
    };

    public SFXSoundExpander(DataInputStream dis, PLA pla, int sizeKB) {
        super(pla);
        this.type = sizeKB;
        this.context = pla.getCPU().getEventScheduler();
        this.reset();
    }

    @Override
    public Bank getIO2() {
        return this.io2Bank;
    }

    @Override
    public void reset() {
        super.reset();
        this.fmOpl = FMOPL_072.init(this.type, 3579545, (int)this.context.getCyclesPerSecond());
    }

    @Override
    public boolean isCreatingSamples() {
        return true;
    }

    @Override
    public void mixerStart() {
        this.clocksSinceLastAccess();
    }

    @Override
    public void clock() {
        FMOPL_072.update_one(this.fmOpl, this.sampler, this.clocksSinceLastAccess());
    }

    private int clocksSinceLastAccess() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastTime);
        this.lastTime = now;
        return diff;
    }

    @Override
    public String toString() {
        return "FM-YAM " + (this.type == 0 ? "OPL1 (YM3526)" : "OPL2 (YM3812)");
    }
}

