/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ResourceBundle;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDListener;
import libsidplay.config.IAudioSection;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;
import sidplay.audio.sidreg.SidRegWrite;

public abstract class SIDRegDriver
implements SIDListener,
AudioDriver {
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle("sidplay.audio.SIDRegDriver");
    protected OutputStream out;
    protected Format format = Format.NORMAL;
    private EventScheduler context;
    private long fTime;
    private ByteBuffer sampleBuffer;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        AudioConfig cfg = new AudioConfig(audioSection);
        this.context = context;
        this.out = this.getOut(recordingFilename);
        this.fTime = 0L;
        if (this.format != Format.C64_JUKEBOX) {
            SIDRegDriver.writeHeader(this.out);
        }
        this.sampleBuffer = ByteBuffer.allocateDirect(cfg.getChunkFrames() * 2 * cfg.getChannels()).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void write(int addr, byte data) {
        long time = this.context.getTime(Event.Phase.PHI2);
        if (this.fTime == 0L) {
            this.fTime = time;
        }
        long relTime = time - this.fTime;
        try {
            new SidRegWrite(time, relTime, addr, data).writeSidRegister(this.out, this.format, relTime == 0L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.fTime = time;
    }

    @Override
    public void write() throws InterruptedException {
    }

    @Override
    public void close() {
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    @Override
    public boolean isRecording() {
        return true;
    }

    @Override
    public String getExtension() {
        return ".csv";
    }

    public static void writeHeader(OutputStream out) throws IOException {
        out.write(String.format("\"%s\", \"%s\", \"%s\", \"%s\", \"%s\"\n", BUNDLE.getString("ABSOLUTE_CYCLES"), BUNDLE.getString("RELATIVE_CYCLES"), BUNDLE.getString("ADDRESS"), BUNDLE.getString("VALUE"), BUNDLE.getString("DESCRIPTION")).getBytes(StandardCharsets.ISO_8859_1));
    }

    protected abstract OutputStream getOut(String var1) throws IOException;

    public static enum Format {
        NORMAL,
        APP,
        C64_JUKEBOX;

    }

    public static class SIDRegStreamDriver
    extends SIDRegDriver {
        public SIDRegStreamDriver(OutputStream out, Format format) {
            this.out = out;
            this.format = format;
        }

        @Override
        protected OutputStream getOut(String recordingFilename) {
            return this.out;
        }
    }

    public static class SIDRegFileDriver
    extends SIDRegDriver {
        @Override
        protected OutputStream getOut(String recordingFilename) throws IOException {
            System.out.println("Recording, file=" + recordingFilename);
            return new FileOutputStream(recordingFilename);
        }

        @Override
        public void close() {
            super.close();
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing SIDRegDriver stream", e);
                }
                finally {
                    this.out = null;
                }
            }
        }
    }
}

