/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

public final class ImageQueue<T> {
    private static final int MAX_QUEUE_SIZE = 60;
    private static final int DROP_NTH_FRAME = 10;
    private static final int DROP_FRAMES_SIZE = 20;
    private QueueItem<T> head;
    private QueueItem<T> tail;
    private int size;
    private boolean disposed;

    public final synchronized void push(T image) {
        if (this.disposed) {
            return;
        }
        if (this.size == 60) {
            this.head = ((QueueItem)this.head).next;
            --this.size;
        }
        QueueItem item = new QueueItem(image);
        if (this.tail == null) {
            this.head = item;
            this.tail = this.head;
        } else {
            ((QueueItem)this.tail).next = item;
            this.tail = item;
        }
        ++this.size;
    }

    public final synchronized T pull() {
        if (this.size > 20) {
            QueueItem<T> prev = this.head;
            QueueItem scan = this.head;
            int count = this.size / 10;
            while (count-- > 0) {
                for (int i = 0; i < 10 && scan != this.tail; ++i) {
                    prev = scan;
                    scan = scan.next;
                }
                if (scan == this.tail) {
                    this.tail = prev;
                }
                ((QueueItem)prev).next = scan.next;
                --this.size;
            }
        }
        if (this.tail == null) {
            return null;
        }
        if (this.head == this.tail) {
            this.tail = null;
        }
        Object result = ((QueueItem)this.head).image;
        this.head = ((QueueItem)this.head).next;
        --this.size;
        return (T)result;
    }

    public final synchronized void clear() {
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public final synchronized void dispose() {
        this.clear();
        this.disposed = true;
    }

    private static class QueueItem<T> {
        private final T image;
        private QueueItem<T> next;

        private QueueItem(T image) {
            this.image = image;
        }
    }
}

