/*
 * Decompiled with CFR 0.152.
 */
package ui.videoplayer;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.DirectoryChooser;
import javafx.util.Duration;
import sidplay.Player;
import sidplay.audio.Audio;
import sidplay.audio.AudioConfig;
import sidplay.audio.JavaSound;
import sidplay.audio.xuggle.XuggleBase;
import sidplay.audio.xuggle.XuggleVideoPlayer;
import sidplay.player.State;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.ImageQueue;
import ui.common.UIPart;
import ui.entities.config.AudioSection;
import ui.entities.config.SidPlay2Section;

public class VideoPlayer
extends C64VBox
implements UIPart {
    public static final String ID = "VIDEOPLAYER";
    @FXML
    private TextField filenameField;
    @FXML
    private ToggleButton recordingPauseContinue;
    @FXML
    private TitledPane monitor;
    @FXML
    private ImageView screen;
    private ImageQueue<Image> imageQueue;
    private PauseTransition pauseTransition;
    private SequentialTransition sequentialTransition;
    private JavaSound javaSound;
    private Thread thread;
    private XuggleVideoPlayer playerRunnable;
    private StateChangeListener propertyChangeListener;

    public VideoPlayer() {
    }

    public VideoPlayer(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.pauseTransition = new PauseTransition();
        this.sequentialTransition = new SequentialTransition(new Animation[]{this.pauseTransition});
        this.pauseTransition.setOnFinished(evt -> {
            Image image = this.imageQueue.pull();
            if (image != null) {
                this.screen.setImage(image);
            }
        });
        this.sequentialTransition.setCycleCount(-1);
        this.imageQueue = new ImageQueue();
        Path sourcePath = Paths.get(this.util.getPlayer().getRecordingFilename(), new String[0]);
        this.filenameField.setText(sourcePath.toFile().getAbsolutePath());
        this.propertyChangeListener = new StateChangeListener();
        this.util.getPlayer().stateProperty().addListener(this.propertyChangeListener);
        this.javaSound = new JavaSound();
        this.playerRunnable = new XuggleVideoPlayer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SidPlay2Section sidplay2Section = VideoPlayer.this.util.getConfig().getSidplay2Section();
                    AudioSection audioSection = VideoPlayer.this.util.getConfig().getAudioSection();
                    XuggleBase.VideoInfo videoInfo = super.open(VideoPlayer.this.filenameField.getText());
                    Platform.runLater(() -> {
                        VideoPlayer.this.screen.setFitWidth((double)videoInfo.getWidth());
                        VideoPlayer.this.screen.setFitHeight((double)videoInfo.getHeight());
                        double scale = sidplay2Section.getVideoScaling();
                        VideoPlayer.this.screen.setScaleX(scale);
                        VideoPlayer.this.screen.setScaleY(scale);
                        VideoPlayer.this.pauseTransition.setDuration(Duration.millis((double)(1000.0 / videoInfo.getFrameRate())));
                        VideoPlayer.this.sequentialTransition.playFromStart();
                    });
                    VideoPlayer.this.javaSound.open(new AudioConfig(videoInfo.getSampleRate(), videoInfo.getChannels(), audioSection.getAudioBufferSize()), JavaSound.getDeviceInfo(audioSection));
                    super.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    super.close();
                    VideoPlayer.this.sequentialTransition.stop();
                    VideoPlayer.this.imageQueue.clear();
                    VideoPlayer.this.javaSound.close();
                    VideoPlayer.this.recordingPauseContinue.setSelected(false);
                    VideoPlayer.this.thread = null;
                }
            }

            @Override
            protected void write(BufferedImage image) {
                VideoPlayer.this.imageQueue.push(SwingFXUtils.toFXImage((BufferedImage)image, null));
            }

            @Override
            protected void write(byte[] samples) throws InterruptedException {
                for (byte b : samples) {
                    if (VideoPlayer.this.javaSound.buffer().put(b).hasRemaining()) continue;
                    VideoPlayer.this.javaSound.write();
                    ((Buffer)VideoPlayer.this.javaSound.buffer()).clear();
                }
            }

            @Override
            public void pauseContinue() {
                super.pauseContinue();
                if (VideoPlayer.this.javaSound != null) {
                    VideoPlayer.this.javaSound.pause();
                }
            }
        };
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.propertyChangeListener);
        this.stop();
        this.imageQueue.dispose();
    }

    @FXML
    private void pauseContinue() {
        if (this.thread != null) {
            this.playerRunnable.pauseContinue();
        } else {
            this.thread = new Thread(this.playerRunnable);
            this.thread.start();
        }
    }

    @FXML
    public void stop() {
        try {
            if (this.thread != null) {
                this.playerRunnable.terminate();
                this.thread.join();
            }
            this.recordingPauseContinue.setSelected(false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void export() {
        try {
            SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
            DirectoryChooser fileDialog = new DirectoryChooser();
            fileDialog.setTitle(this.util.getBundle().getString("SAVE_RECORDING"));
            fileDialog.setInitialDirectory(sidplay2Section.getLastDirectory());
            File directory = fileDialog.showDialog(this.getScene().getWindow());
            if (directory != null) {
                sidplay2Section.setLastDirectory(directory);
                Path sourcePath = Paths.get(this.util.getPlayer().getRecordingFilename(), new String[0]);
                Path targetPath = new File(directory, sourcePath.toFile().getName()).toPath();
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                sourcePath.toFile().deleteOnExit();
                System.out.println("Recording Saved to: " + targetPath);
            }
        }
        catch (IOException e) {
            this.openErrorDialog(e.getMessage());
        }
    }

    private void openErrorDialog(String msg) {
        Alert alert = new Alert(Alert.AlertType.ERROR, msg, new ButtonType[0]);
        alert.setTitle(this.util.getBundle().getString("ALERT_TITLE"));
        alert.showAndWait();
    }

    private class StateChangeListener
    implements PropertyChangeListener {
        private StateChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ((event.getNewValue() == State.END || event.getNewValue() == State.QUIT) && VideoPlayer.this.util.getPlayer().getAudioDriver().isRecording() && !Arrays.asList(Audio.LIVE_VIDEO_STREAMING, Audio.LIVE_SID_DUMP, Audio.LIVE_SID_REG).contains((Object)VideoPlayer.this.util.getPlayer().getAudio())) {
                Path sourcePath = Paths.get(VideoPlayer.this.util.getPlayer().getRecordingFilename(), new String[0]);
                VideoPlayer.this.filenameField.setText(sourcePath.toFile().getAbsolutePath());
            }
        }
    }
}

