/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.output;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import kickass.pass.values.LabelValue;
import kickass.pass.values.NamespaceValue;
import kickass.pass.values.ScopeIfSelectorValue;
import kickass.pass.values.ScopeValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.namespace.Namespace;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;

public class SymbolFile {
    private static String newline = System.getProperty("line.separator");
    private Namespace rootNamespace;
    private String indent = "  ";

    public SymbolFile(Namespace namespace) {
        this.rootNamespace = namespace;
    }

    public void writeFile(String string, EvaluationState evaluationState) {
        try {
            OutputStream outputStream = evaluationState.outputMgr.OpenOutputStream(string, false);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            this.writeScope(0, this.rootNamespace.getScope(), bufferedWriter);
            ((Writer)bufferedWriter).close();
            outputStream.close();
        }
        catch (IOException iOException) {
            evaluationState.log.error("IO error while writing symbol file '" + string + "':" + iOException.getMessage());
        }
        catch (Exception exception) {
            evaluationState.log.error("Internal error while writing symbol file '" + string + "'. Contact the author");
            exception.printStackTrace(System.out);
        }
    }

    private void writeScope(int n, SymbolScope symbolScope, Writer writer) throws IOException {
        boolean bl;
        boolean bl2 = bl = symbolScope.getSymbolTable() == this.rootNamespace.getScope().getSymbolTable();
        if (!bl) {
            return;
        }
        String string = this.getIndent(n);
        Map<String, ISymbolPageIdx> map = symbolScope.getLocalDefinedEntities();
        for (Map.Entry<String, ISymbolPageIdx> entry : map.entrySet()) {
            boolean bl3;
            String string2 = entry.getKey();
            Value value = entry.getValue().getValueHolder().getWithoutSideeffect();
            boolean bl4 = value instanceof NamespaceValue;
            if (bl4) {
                writer.write(string + ".namespace " + string2 + " {" + newline);
                this.writeScope(n + 1, ((NamespaceValue)value).getScope(), writer);
                writer.write(string + "}" + newline);
                continue;
            }
            boolean bl5 = value instanceof LabelValue;
            if (!bl5) continue;
            LabelValue labelValue = (LabelValue)value;
            Value value2 = labelValue.getConnectedValue();
            String string3 = Integer.toHexString(value.getInt(null));
            boolean bl6 = bl3 = value2 == null;
            if (bl3) {
                writer.write(string + ".label " + string2 + "=$" + string3 + newline);
                continue;
            }
            boolean bl7 = value2 instanceof ScopeValue;
            if (value2 instanceof ScopeValue) {
                this.WriteLabelAndScope(n, string2, string3, ((ScopeValue)value2).getScope(), writer);
                continue;
            }
            if (value2 instanceof ScopeIfSelectorValue) {
                this.WriteLabelAndScope(n, string2, string3, ((ScopeIfSelectorValue)value2).selectedScopeValue.getScope(), writer);
                continue;
            }
            this.WriteLabelAndScope(n, string2, string3, null, writer);
        }
    }

    private void WriteLabelAndScope(int n, String string, String string2, SymbolScope symbolScope, Writer writer) throws IOException {
        String string3 = this.getIndent(n);
        writer.write(string3 + ".label " + string + "=$" + string2);
        if (symbolScope == null) {
            writer.write(newline);
            return;
        }
        writer.write(" {" + newline);
        this.writeScope(n + 1, symbolScope, writer);
        writer.write(string3 + "}" + newline);
    }

    private String getIndent(int n) {
        String string = "";
        while (n > 0) {
            string = string + this.indent;
            --n;
        }
        return string;
    }
}

