/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import net.java.truecommons.shed.Option;

final class Some<T>
extends Option<T> {
    private final T element;

    Some(T element) {
        this.element = Objects.requireNonNull(element);
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.singleton(this.element).iterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public T get() {
        return this.element;
    }

    @Override
    public T getOrElse(@Nullable T alternative) {
        return this.element;
    }

    @Override
    public T orNull() {
        return this.element;
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof Some && this.element.equals(((Some)that).element);
    }

    @Override
    public int hashCode() {
        return this.element.hashCode();
    }
}

