/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingInputStream;

@NotThreadSafe
final class CountingInputStream
extends DecoratingInputStream {
    private long bytesRead;

    @CreatesObligation
    CountingInputStream(@WillCloseWhenClosed InputStream in) {
        super(in);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read > 0) {
            this.bytesRead += (long)read;
        }
        return read;
    }

    public int read() throws IOException {
        int read = this.in.read();
        if (read != -1) {
            ++this.bytesRead;
        }
        return read;
    }

    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.bytesRead += skipped;
        return skipped;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

