/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truevfs.comp.zip.WinZipAesParameters;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipKeyException;

@ThreadSafe
final class WinZipAesEntryParameters {
    private final WinZipAesParameters param;
    private final ZipEntry entry;

    WinZipAesEntryParameters(WinZipAesParameters param, ZipEntry entry) {
        assert (null != param);
        assert (null != entry);
        this.param = param;
        this.entry = entry;
    }

    ZipEntry getEntry() {
        return this.entry;
    }

    AesKeyStrength getKeyStrength() throws ZipKeyException {
        return this.param.getKeyStrength(this.entry.getName());
    }

    void setKeyStrength(AesKeyStrength keyStrength) throws ZipKeyException {
        this.param.setKeyStrength(this.entry.getName(), keyStrength);
    }

    byte[] getWritePassword() throws ZipKeyException {
        return this.param.getWritePassword(this.entry.getName());
    }

    byte[] getReadPassword(boolean invalid) throws ZipKeyException {
        return this.param.getReadPassword(this.entry.getName(), invalid);
    }
}

