/*
 * Decompiled with CFR 0.152.
 */
package builder.resid;

import builder.resid.SampleMixer;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDChip;
import libsidplay.common.SIDEmu;

public abstract class ReSIDBase
extends SIDEmu {
    private final SIDChip sid = this.createSID();
    private final EventScheduler context;
    private SampleMixer sampler = new SampleMixer.NoOpSampleMixer();
    protected long lastTime;

    public ReSIDBase(EventScheduler context) {
        this.context = context;
        this.reset((byte)15);
    }

    protected void setSampler(SampleMixer sampler) {
        this.sampler = sampler;
    }

    SampleMixer getSampler() {
        return this.sampler;
    }

    @Override
    public void reset(byte volume) {
        this.clocksSinceLastAccess();
        this.sid.reset();
        this.sid.write(24, volume);
    }

    @Override
    public byte read(int addr) {
        this.clock();
        return this.sid.read(addr);
    }

    @Override
    public void write(int addr, byte data) {
        this.clock();
        super.write(addr, data);
        this.sid.write(addr, data);
    }

    @Override
    public void clock() {
        this.sid.clock(this.clocksSinceLastAccess(), this.sampler);
    }

    @Override
    public void setVoiceMute(int num, boolean mute) {
        this.sid.mute(num, mute);
    }

    @Override
    public void setClockFrequency(double systemClock) {
        this.sid.setClockFrequency(systemClock);
    }

    @Override
    public void setChipModel(ChipModel model) {
        this.sid.setChipModel(model);
    }

    @Override
    public void input(int input) {
        this.sid.input(input);
    }

    @Override
    public void setDigiBoost(boolean digiBoost) {
        this.sid.setDigiBoost(digiBoost);
    }

    public abstract byte readENV(int var1);

    public abstract byte readOSC(int var1);

    protected abstract SIDChip createSID();

    protected int clocksSinceLastAccess() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastTime);
        this.lastTime = now;
        return diff;
    }
}

