/*
 * Decompiled with CFR 0.152.
 */
package builder.resid.residfp;

import builder.resid.residfp.SID;
import libsidplay.config.IFilterSection;

public final class FilterModelConfig {
    private static final double sid_caps = 4.7E-10;
    private static final float dac_kinkiness = 0.96f;

    public static double estimateFrequency(IFilterSection filter, int fc) {
        return FilterModelConfig.estimateFrequency(filter.getK(), filter.getB(), filter.getMinimumfetresistance(), filter.getOffset(), filter.getSteepness(), filter.getBaseresistance(), fc);
    }

    public static double estimateFrequency(float k, float b, float minimumfetresistance, float offset, float steepness, float baseresistance, int fc) {
        if (k == 0.0f) {
            double ik = SID.kinkedDac(fc, 0.96f, 11);
            double dynamic = (double)minimumfetresistance + (double)offset / Math.pow(steepness, ik);
            double R = (double)baseresistance * dynamic / ((double)baseresistance + dynamic);
            return 1.0 / (2.953097094374406E-9 * R);
        }
        return k * (float)fc + b;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 2048; ++i) {
            System.err.println("x=" + i + ", y=" + FilterModelConfig.estimateFrequency(0.0f, 0.0f, 16125.155f, 2.742288E8f, 1.0066634f, 1147036.5f, i));
        }
    }
}

