/*
 * Decompiled with CFR 0.152.
 */
package client.teavm;

import client.teavm.ImportedApiWav;
import client.teavm.common.ExportedApi;
import client.teavm.common.IExportedApi;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import libsidplay.common.SamplingRate;
import libsidutils.IOUtils;

public final class JSIDPlay2TeaVMc {
    private static final String[] DEBUG_ARGS = new String[]{"--debug", "false"};
    private static IExportedApi jsidplay2;

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("Missing arguments: <sidFilename> <wavFilename> <recordingTimeInSeconds>");
        } else {
            File tuneFile = new File(args[0]);
            File outFile = new File(args[1]);
            int seconds = Integer.parseInt(args[2]);
            try (FileInputStream is = new FileInputStream(tuneFile);
                 DataOutputStream os = new DataOutputStream(new FileOutputStream(outFile));){
                SamplingRate samplingRate = SamplingRate.MEDIUM;
                int frequency = samplingRate.getFrequency();
                int numSamples = seconds * frequency;
                jsidplay2 = new ExportedApi(new ImportedApiWav(os, frequency, numSamples), DEBUG_ARGS);
                jsidplay2.bufferSize(3 * frequency);
                jsidplay2.audioBufferSize(frequency);
                jsidplay2.samplingRate(samplingRate);
                jsidplay2.open(IOUtils.readAllBytes(is), tuneFile.getName(), 0, 0, false, null, null, null, 0.0, false, 0);
                while (os.size() >> 2 < numSamples) {
                    jsidplay2.clock();
                }
            }
        }
    }
}

