/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.oscilloscope;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import libsidplay.common.SIDEmu;
import libsidutils.oscilloscope.GaugeUtil;

public class Gauge {
    private GaugeUtil gaugeUtil;
    protected String text = "";
    protected ByteBuffer path;

    public Gauge(final int width, final int height, Supplier<ByteBuffer> initGaugeBuffer) {
        this.path = initGaugeBuffer.get();
        this.gaugeUtil = new GaugeUtil(width, height){

            @Override
            protected void drawLine(int x1, int y1, int x2, int y2, int color) {
                Gauge.this.path.putInt(Math.min(Math.max(0, x1), width - 1));
                Gauge.this.path.putInt(Math.min(Math.max(0, y1), height - 1));
                Gauge.this.path.putInt(Math.min(Math.max(0, x2), width - 1));
                Gauge.this.path.putInt(Math.min(Math.max(0, y2), height - 1));
            }
        };
    }

    protected void accumulate(float value) {
        this.gaugeUtil.accumulate(value);
    }

    protected void advance() {
        this.gaugeUtil.advance();
    }

    public void reset() {
        this.gaugeUtil.reset();
    }

    public void draw(SIDEmu sidemu) {
        ((Buffer)this.path).clear();
        this.path.putInt(-1);
        this.gaugeUtil.draw(sidemu);
        this.path.putInt(0, this.path.position() >> 2);
    }
}

