/*
 * Decompiled with CFR 0.152.
 */
package libsidplay;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Locale;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;

public interface Ultimate64 {
    public static final int SOCKET_CONNECT_TIMEOUT = 5000;
    public static final int MAX_COMMAND_LEN = 16;

    default public void sendRamAndRun(IConfig config, SidTune tune, byte[] c64Ram) throws InterruptedException {
        String hostname = config.getEmulationSection().getUltimate64Host();
        int port = config.getEmulationSection().getUltimate64Port();
        int syncDelay = config.getEmulationSection().getUltimate64SyncDelay();
        try (Socket connectedSocket = new Socket();){
            connectedSocket.connect(new InetSocketAddress(hostname, port), 5000);
            int ramStart = 2048;
            int ramEnd = 65536;
            byte[] ram = new byte[ramEnd - ramStart + 6];
            ram[0] = (byte)(SocketCommand.SOCKET_CMD_DMARUN.value & 0xFF);
            ram[1] = (byte)(SocketCommand.SOCKET_CMD_DMARUN.value >> 8 & 0xFF);
            ram[2] = (byte)(ram.length & 0xFF);
            ram[3] = (byte)(ram.length >> 8 & 0xFF);
            ram[4] = (byte)(ramStart & 0xFF);
            ram[5] = (byte)(ramStart >> 8 & 0xFF);
            System.arraycopy(c64Ram, ramStart, ram, 6, ramEnd - ramStart);
            connectedSocket.getOutputStream().write(ram);
        }
        catch (IOException e) {
            System.err.println("Ultimate64: cannot send RAM and RUN: " + e.getMessage());
        }
        Thread.sleep(syncDelay);
    }

    default public void sendRamAndSys(IConfig config, SidTune tune, byte[] c64Ram, int startAddr) throws InterruptedException {
        String hostname = config.getEmulationSection().getUltimate64Host();
        int port = config.getEmulationSection().getUltimate64Port();
        int syncDelay = config.getEmulationSection().getUltimate64SyncDelay();
        try (Socket connectedSocket = new Socket();){
            connectedSocket.connect(new InetSocketAddress(hostname, port), 5000);
            int ramStart = 1024;
            int ramEnd = 65536;
            byte[] ram = new byte[ramEnd - ramStart + 8];
            ram[0] = (byte)(SocketCommand.SOCKET_CMD_DMAJUMP.value & 0xFF);
            ram[1] = (byte)(SocketCommand.SOCKET_CMD_DMAJUMP.value >> 8 & 0xFF);
            ram[2] = (byte)(ram.length & 0xFF);
            ram[3] = (byte)(ram.length >> 8 & 0xFF);
            ram[4] = (byte)(startAddr & 0xFF);
            ram[5] = (byte)(startAddr >> 8 & 0xFF);
            ram[6] = (byte)(ramStart & 0xFF);
            ram[7] = (byte)(ramStart >> 8 & 0xFF);
            System.arraycopy(c64Ram, ramStart, ram, 8, ramEnd - ramStart);
            connectedSocket.getOutputStream().write(ram);
        }
        catch (IOException e) {
            System.err.println("Ultimate64: cannot send RAM and SYS: " + e.getMessage());
        }
        Thread.sleep(syncDelay);
    }

    default public void sendReset(IConfig config, SidTune tune) {
        String hostname = config.getEmulationSection().getUltimate64Host();
        int port = config.getEmulationSection().getUltimate64Port();
        try (Socket connectedSocket = new Socket();){
            connectedSocket.connect(new InetSocketAddress(hostname, port), 5000);
            byte[] ram = new byte[]{(byte)(SocketCommand.SOCKET_CMD_RESET.value & 0xFF), (byte)(SocketCommand.SOCKET_CMD_RESET.value >> 8 & 0xFF), 0, 0};
            connectedSocket.getOutputStream().write(ram);
        }
        catch (IOException e) {
            System.err.println("Ultimate64: cannot send RESET: " + e.getMessage());
        }
    }

    default public void sendCommand(IConfig config, String command) {
        String hostname = config.getEmulationSection().getUltimate64Host();
        int port = config.getEmulationSection().getUltimate64Port();
        int length = Math.min(command.length(), 16);
        try (Socket connectedSocket = new Socket();){
            connectedSocket.connect(new InetSocketAddress(hostname, port), 5000);
            byte[] ram = new byte[length + 4];
            ram[0] = (byte)(SocketCommand.SOCKET_CMD_KEYB.value & 0xFF);
            ram[1] = (byte)(SocketCommand.SOCKET_CMD_KEYB.value >> 8 & 0xFF);
            ram[2] = (byte)(length & 0xFF);
            ram[3] = (byte)(length >> 8 & 0xFF);
            System.arraycopy(command.toUpperCase(Locale.US).getBytes(StandardCharsets.US_ASCII), 0, ram, 4, length);
            connectedSocket.getOutputStream().write(ram);
        }
        catch (IOException e) {
            System.err.println("Ultimate64: cannot send COMMAND: " + e.getMessage());
        }
    }

    default public void sendWait(IConfig config, int delay) {
        String hostname = config.getEmulationSection().getUltimate64Host();
        int port = config.getEmulationSection().getUltimate64Port();
        try (Socket connectedSocket = new Socket();){
            connectedSocket.connect(new InetSocketAddress(hostname, port), 5000);
            byte[] ram = new byte[]{(byte)(SocketCommand.SOCKET_CMD_WAIT.value & 0xFF), (byte)(SocketCommand.SOCKET_CMD_WAIT.value >> 8 & 0xFF), (byte)(delay & 0xFF), (byte)(delay >> 8 & 0xFF), (byte)(delay & 0xFF), (byte)(delay >> 8 & 0xFF)};
            connectedSocket.getOutputStream().write(ram);
        }
        catch (IOException e) {
            System.err.println("Ultimate64: cannot send WAIT: " + e.getMessage());
        }
    }

    default public void sendInsertDisk(IConfig config, File file) throws IOException {
        byte[] diskContents = Files.readAllBytes(file.toPath());
        String hostname = config.getEmulationSection().getUltimate64Host();
        int port = config.getEmulationSection().getUltimate64Port();
        try (Socket connectedSocket = new Socket();){
            connectedSocket.connect(new InetSocketAddress(hostname, port), 5000);
            byte[] ram = new byte[diskContents.length + 5];
            ram[0] = (byte)(SocketCommand.INSERT_DISK.value & 0xFF);
            ram[1] = (byte)(SocketCommand.INSERT_DISK.value >> 8 & 0xFF);
            ram[2] = (byte)(diskContents.length & 0xFF);
            ram[3] = (byte)(diskContents.length >> 8 & 0xFF);
            ram[4] = (byte)(diskContents.length >> 16 & 0xFF);
            System.arraycopy(diskContents, 0, ram, 5, diskContents.length);
            connectedSocket.getOutputStream().write(ram);
        }
        catch (IOException e) {
            System.err.println("Ultimate64: cannot insert disk: " + e.getMessage());
        }
    }

    default public void startStreaming(IEmulationSection emulationSection, SocketStreamingCommand command, String target, int duration) {
        String hostname = emulationSection.getUltimate64Host();
        int port = emulationSection.getUltimate64Port();
        try (Socket connectedSocket = new Socket();){
            connectedSocket.connect(new InetSocketAddress(hostname, port), 5000);
            byte[] ram = new byte[target.length() + 6];
            ram[0] = (byte)(command.value & 0xFF);
            ram[1] = (byte)(command.value >> 8 & 0xFF);
            ram[2] = (byte)(target.length() + 2 & 0xFF);
            ram[3] = (byte)(target.length() + 2 >> 8 & 0xFF);
            ram[4] = 0;
            ram[5] = (byte)(duration & 0xFF);
            System.arraycopy(target.getBytes(StandardCharsets.US_ASCII), 0, ram, 6, target.length());
            connectedSocket.getOutputStream().write(ram);
        }
        catch (IOException e) {
            System.err.println("Ultimate64: cannot start streaming: " + e.getMessage());
        }
    }

    default public void stopStreaming(IEmulationSection emulationSection, SocketStreamingCommand command) {
        String hostname = emulationSection.getUltimate64Host();
        int port = emulationSection.getUltimate64Port();
        try (Socket connectedSocket = new Socket();){
            connectedSocket.connect(new InetSocketAddress(hostname, port), 5000);
            byte[] ram = new byte[]{(byte)(command.value & 0xFF), (byte)(command.value >> 8 & 0xFF), 0, 0};
            connectedSocket.getOutputStream().write(ram);
        }
        catch (IOException e) {
            System.err.println("Ultimate64: cannot stop streaming: " + e.getMessage());
        }
    }

    public static enum SocketCommand {
        SOCKET_CMD_DMA(65281),
        SOCKET_CMD_DMARUN(65282),
        SOCKET_CMD_KEYB(65283),
        SOCKET_CMD_RESET(65284),
        SOCKET_CMD_WAIT(65285),
        SOCKET_CMD_DMAWRITE(65286),
        SOCKET_CMD_REUWRITE(65287),
        SOCKET_CMD_KERNALWRITE(65288),
        SOCKET_CMD_DMAJUMP(65289),
        INSERT_DISK(65290),
        SOCKET_CMD_RUN_IMG(65291),
        SOCKET_CMD_LOADSIDCRT(65393),
        SOCKET_CMD_LOADBOOTCRT(65394),
        SOCKET_CMD_READMEM(65396),
        SOCKET_CMD_READFLASH(65397),
        SOCKET_CMD_DEBUG_REG(65398);

        int value;

        private SocketCommand(int on) {
            this.value = on;
        }
    }

    public static enum SocketStreamingCommand {
        SOCKET_CMD_VICSTREAM_ON(65312),
        SOCKET_CMD_AUDIOSTREAM_ON(65313),
        SOCKET_CMD_VICSTREAM_OFF(65328),
        SOCKET_CMD_AUDIOSTREAM_OFF(65329);

        int value;

        private SocketStreamingCommand(int on) {
            this.value = on;
        }
    }
}

