/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.common;

import java.util.ArrayList;
import java.util.List;
import libsidplay.common.Event;

public final class EventScheduler {
    private static final int THREAD_SAFE_KEY_EVENT_QUEUE_CHECK_INTERVAL = 50000;
    private static final int THREAD_SAFE_QUEUE_CHECK_INTERVAL = 500;
    private long currentTime;
    private double cyclesPerSecond;
    private List<Event> threadSafeKeyQueue = new ArrayList<Event>();
    private List<Event> threadSafeQueue = new ArrayList<Event>();
    private final Event lastEvent = new Event("Tail"){
        {
            this.triggerTime = Long.MAX_VALUE;
        }

        @Override
        public void event() {
            throw new RuntimeException("Event scheduler ran out of events to execute");
        }
    };
    private final Event firstEvent = new Event("Root"){
        {
            this.triggerTime = Long.MIN_VALUE;
        }

        @Override
        public void event() {
            throw new RuntimeException("Event scheduler executed the root event");
        }
    };
    private final Event threadSafeQueueingEvent = new Event("Inject events in thread-safe manner."){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void event() throws InterruptedException {
            List list = EventScheduler.this.threadSafeQueue;
            synchronized (list) {
                if (!EventScheduler.this.threadSafeQueue.isEmpty()) {
                    ((Event)EventScheduler.this.threadSafeQueue.remove(0)).event();
                }
            }
            EventScheduler.this.schedule(this, 500L);
        }
    };
    private final Event threadSafeQueueingKeyEvent = new Event("Inject key events in thread-safe manner."){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void event() throws InterruptedException {
            List list = EventScheduler.this.threadSafeKeyQueue;
            synchronized (list) {
                if (!EventScheduler.this.threadSafeKeyQueue.isEmpty()) {
                    ((Event)EventScheduler.this.threadSafeKeyQueue.remove(0)).event();
                }
            }
            EventScheduler.this.schedule(this, 50000L);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleThreadSafeKeyEvent(Event event) {
        List<Event> list = this.threadSafeKeyQueue;
        synchronized (list) {
            this.threadSafeKeyQueue.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleThreadSafe(Event event) {
        List<Event> list = this.threadSafeQueue;
        synchronized (list) {
            this.threadSafeQueue.add(event);
        }
    }

    public EventScheduler() {
        this.reset();
    }

    public void schedule(Event event, long cycles, Event.Phase phase) {
        event.triggerTime = (cycles << 1) + this.currentTime + (this.currentTime & 1L ^ (long)(phase == Event.Phase.PHI1 ? 0 : 1));
        this.addEventToSchedule(event);
    }

    public void schedule(Event event, long cycles) {
        event.triggerTime = (cycles << 1) + this.currentTime;
        this.addEventToSchedule(event);
    }

    public void scheduleAbsolute(Event event, long absoluteCycles, Event.Phase phase) {
        event.triggerTime = (absoluteCycles << 1) + (long)(phase == Event.Phase.PHI2 ? 1 : 0);
        this.addEventToSchedule(event);
    }

    private void addEventToSchedule(Event event) {
        Event scan = this.firstEvent;
        while (true) {
            Event next = scan.next;
            if (next.triggerTime > event.triggerTime) {
                event.next = next;
                scan.next = event;
                return;
            }
            scan = next;
        }
    }

    public boolean cancel(Event event) {
        Event prev = this.firstEvent;
        Event scan = this.firstEvent.next;
        while (scan != this.lastEvent) {
            if (event == scan) {
                prev.next = scan.next;
                return true;
            }
            prev = scan;
            scan = scan.next;
        }
        return false;
    }

    public void reset() {
        this.threadSafeQueue.clear();
        this.threadSafeKeyQueue.clear();
        this.currentTime = 0L;
        this.firstEvent.next = this.lastEvent;
        this.schedule(this.threadSafeQueueingEvent, 0L, Event.Phase.PHI1);
        this.schedule(this.threadSafeQueueingKeyEvent, 0L, Event.Phase.PHI1);
    }

    public void clock() throws InterruptedException {
        Event event = this.firstEvent.next;
        this.firstEvent.next = event.next;
        this.currentTime = event.triggerTime;
        event.event();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clockThreadSafeEvents() throws InterruptedException {
        List<Event> list = this.threadSafeQueue;
        synchronized (list) {
            if (!this.threadSafeQueue.isEmpty()) {
                this.threadSafeQueue.remove(0).event();
            }
        }
    }

    public boolean isPending(Event event) {
        Event scan = this.firstEvent.next;
        while (scan != this.lastEvent) {
            if (event == scan) {
                return true;
            }
            scan = scan.next;
        }
        return false;
    }

    public long getTime(Event.Phase phase) {
        return this.currentTime + (long)(phase == Event.Phase.PHI1 ? 1 : 0) >> 1;
    }

    public Event.Phase phase() {
        return (this.currentTime & 1L) == 0L ? Event.Phase.PHI1 : Event.Phase.PHI2;
    }

    public double getCyclesPerSecond() {
        return this.cyclesPerSecond;
    }

    public void setCyclesPerSecond(double cyclesPerSecond) {
        this.cyclesPerSecond = cyclesPerSecond;
    }
}

