/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import java.util.function.IntConsumer;

public class FMOPL_072 {
    private static final int FINAL_SH = 0;
    private static final int FREQ_SH = 16;
    private static final int EG_SH = 16;
    private static final int LFO_SH = 24;
    private static final int FREQ_MASK = 65535;
    private static final int ENV_BITS = 10;
    private static final int ENV_LEN = 1024;
    private static final double ENV_STEP = 0.125;
    private static final int MAX_ATT_INDEX = 511;
    private static final int MIN_ATT_INDEX = 0;
    private static final int SIN_BITS = 10;
    private static final int SIN_LEN = 1024;
    private static final int SIN_MASK = 1023;
    private static final int TL_RES_LEN = 256;
    private static final int SLOT1 = 0;
    private static final int SLOT2 = 1;
    private static final int EG_ATT = 4;
    private static final int EG_DEC = 3;
    private static final int EG_SUS = 2;
    private static final int EG_REL = 1;
    private static final int EG_OFF = 0;
    private static final int OPL_TYPE_WAVESEL = 1;
    private static final int OPL_TYPE_ADPCM = 2;
    private static final int OPL_TYPE_KEYBOARD = 4;
    private static final int OPL_TYPE_IO = 8;
    public static final int OPL_TYPE_YM3526 = 0;
    public static final int OPL_TYPE_YM3812 = 1;
    public static final int OPL_TYPE_Y8950 = 14;
    private static final int RATE_STEPS = 8;
    private static final int[] eg_rate_select = new int[]{112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 32, 40, 48, 56, 64, 72, 80, 88, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96};
    private static final int[] eg_rate_shift = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 12, 12, 12, 11, 11, 11, 11, 10, 10, 10, 10, 9, 9, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static FM_OPL init(int type, int clock, int rate) {
        FM_OPL chip = FM_OPL.Create(clock, rate, type);
        if (chip != null) {
            chip.postload();
            FMOPL_072.reset_chip(chip);
        }
        return chip;
    }

    public static void shutdown(FM_OPL chip) {
    }

    public static void reset_chip(FM_OPL chip) {
        chip.ResetChip();
    }

    public static int write(FM_OPL chip, int a, int v) {
        return chip.Write(a, v);
    }

    public static int read(FM_OPL chip, int a) {
        return chip.Read(a) | 6;
    }

    public static void update_one(FM_OPL chip, IntConsumer sampler, int length) {
        boolean rhythm = (chip.rhythm & 0x20) != 0;
        for (int i = 0; i < length; ++i) {
            ((FM_OPL)chip).output[0] = 0;
            chip.advance_lfo();
            chip.CALC_CH(chip.P_CH[0]);
            chip.CALC_CH(chip.P_CH[1]);
            chip.CALC_CH(chip.P_CH[2]);
            chip.CALC_CH(chip.P_CH[3]);
            chip.CALC_CH(chip.P_CH[4]);
            chip.CALC_CH(chip.P_CH[5]);
            if (!rhythm) {
                chip.CALC_CH(chip.P_CH[6]);
                chip.CALC_CH(chip.P_CH[7]);
                chip.CALC_CH(chip.P_CH[8]);
            } else {
                chip.CALC_RH();
            }
            sampler.accept(chip.output[0] >> 0);
            chip.advance();
        }
    }

    public static int timer_over(FM_OPL chip, int c) {
        return chip.TimerOver(c);
    }

    public static void clock_changed(FM_OPL chip, int clock, int rate) {
        chip.clock_changed(clock, rate);
    }

    public static void set_timer_handler(FM_OPL chip, OPL_TIMERHANDLER timer_handler) {
        chip.SetTimerHandler(timer_handler);
    }

    public static void set_irq_handler(FM_OPL chip, OPL_IRQHANDLER IRQHandler) {
        chip.SetIRQHandler(IRQHandler);
    }

    public static void set_update_handler(FM_OPL chip, OPL_UPDATEHANDLER UpdateHandler) {
        chip.SetUpdateHandler(UpdateHandler);
    }

    public static class FM_OPL {
        private static double DV = 0.09375;
        private static final double[] ksl_tab = new double[]{0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.75 / DV, 1.125 / DV, 1.5 / DV, 1.875 / DV, 2.25 / DV, 2.625 / DV, 3.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 1.125 / DV, 1.875 / DV, 2.625 / DV, 3.0 / DV, 3.75 / DV, 4.125 / DV, 4.5 / DV, 4.875 / DV, 5.25 / DV, 5.625 / DV, 6.0 / DV, 0.0 / DV, 0.0 / DV, 0.0 / DV, 1.875 / DV, 3.0 / DV, 4.125 / DV, 4.875 / DV, 5.625 / DV, 6.0 / DV, 6.75 / DV, 7.125 / DV, 7.5 / DV, 7.875 / DV, 8.25 / DV, 8.625 / DV, 9.0 / DV, 0.0 / DV, 0.0 / DV, 3.0 / DV, 4.875 / DV, 6.0 / DV, 7.125 / DV, 7.875 / DV, 8.625 / DV, 9.0 / DV, 9.75 / DV, 10.125 / DV, 10.5 / DV, 10.875 / DV, 11.25 / DV, 11.625 / DV, 12.0 / DV, 0.0 / DV, 3.0 / DV, 6.0 / DV, 7.875 / DV, 9.0 / DV, 10.125 / DV, 10.875 / DV, 11.625 / DV, 12.0 / DV, 12.75 / DV, 13.125 / DV, 13.5 / DV, 13.875 / DV, 14.25 / DV, 14.625 / DV, 15.0 / DV, 0.0 / DV, 6.0 / DV, 9.0 / DV, 10.875 / DV, 12.0 / DV, 13.125 / DV, 13.875 / DV, 14.625 / DV, 15.0 / DV, 15.75 / DV, 16.125 / DV, 16.5 / DV, 16.875 / DV, 17.25 / DV, 17.625 / DV, 18.0 / DV, 0.0 / DV, 9.0 / DV, 12.0 / DV, 13.875 / DV, 15.0 / DV, 16.125 / DV, 16.875 / DV, 17.625 / DV, 18.0 / DV, 18.75 / DV, 19.125 / DV, 19.5 / DV, 19.875 / DV, 20.25 / DV, 20.625 / DV, 21.0 / DV};
        private static int[] ksl_shift = new int[]{31, 1, 2, 0};
        private static final double SC = 16.0;
        private static final int[] sl_tab = new int[]{0, 16, 32, 48, 64, 80, 96, 112, 128, 144, 160, 176, 192, 208, 224, 496};
        private static final int[] eg_inc = new int[]{0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 4, 4, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0};
        private static final int ML = 2;
        private static final int[] mul_tab = new int[]{1, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 20, 24, 24, 30, 30};
        private static final int[] slot_array = new int[]{0, 2, 4, 1, 3, 5, -1, -1, 6, 8, 10, 7, 9, 11, -1, -1, 12, 14, 16, 13, 15, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private static int TL_TAB_LEN = 6144;
        private static int ENV_QUIET = TL_TAB_LEN >> 4;
        private static int LFO_AM_TAB_ELEMENTS = 210;
        private static int[] tl_tab = new int[TL_TAB_LEN];
        private static int[] sin_tab = new int[4096];
        private static int[] lfo_am_table = new int[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 25, 25, 25, 25, 24, 24, 24, 24, 23, 23, 23, 23, 22, 22, 22, 22, 21, 21, 21, 21, 20, 20, 20, 20, 19, 19, 19, 19, 18, 18, 18, 18, 17, 17, 17, 17, 16, 16, 16, 16, 15, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 12, 12, 12, 12, 11, 11, 11, 11, 10, 10, 10, 10, 9, 9, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 2, 1, 1, 1, 1};
        private static int[] lfo_pm_table = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 2, 1, 0, -1, -2, -1, 0, 1, 1, 0, 0, 0, -1, 0, 0, 0, 3, 1, 0, -1, -3, -1, 0, 1, 2, 1, 0, -1, -2, -1, 0, 1, 4, 2, 0, -2, -4, -2, 0, 2, 2, 1, 0, -1, -2, -1, 0, 1, 5, 2, 0, -2, -5, -2, 0, 2, 3, 1, 0, -1, -3, -1, 0, 1, 6, 3, 0, -3, -6, -3, 0, 3, 3, 1, 0, -1, -3, -1, 0, 1, 7, 3, 0, -3, -7, -3, 0, 3};
        private static int num_lock = 0;
        private OPL_CH[] P_CH = new OPL_CH[9];
        private int eg_cnt;
        private int eg_timer;
        private int eg_timer_add;
        private int eg_timer_overflow;
        private int rhythm;
        private int[] fn_tab = new int[1024];
        private int LFO_AM;
        private int LFO_PM;
        private int lfo_am_depth;
        private int lfo_pm_depth_range;
        private int lfo_am_cnt;
        private int lfo_am_inc;
        private int lfo_pm_cnt;
        private int lfo_pm_inc;
        private int noise_rng;
        private int noise_p;
        private int noise_f;
        private int wavesel;
        private int[] T = new int[2];
        private int[] st = new int[2];
        OPL_TIMERHANDLER timer_handler;
        OPL_IRQHANDLER IRQHandler;
        OPL_UPDATEHANDLER UpdateHandler;
        private int type;
        private int address;
        private int status;
        private int statusmask;
        private int mode;
        private int clock;
        private int rate;
        private double freqbase;
        private double TimerBase;
        private int[] phase_modulation = new int[1];
        private int[] output = new int[1];

        public void STATUS_SET(int flag) {
            this.status |= flag;
            if ((this.status & 0x80) == 0 && (this.status & this.statusmask) != 0) {
                this.status |= 0x80;
                if (this.IRQHandler != null) {
                    this.IRQHandler.invoke(1);
                }
            }
        }

        public void STATUS_RESET(int flag) {
            this.status &= ~flag;
            if ((this.status & 0x80) != 0 && (this.status & this.statusmask) == 0) {
                this.status &= 0x7F;
                if (this.IRQHandler != null) {
                    this.IRQHandler.invoke(0);
                }
            }
        }

        void STATUSMASK_SET(int flag) {
            this.statusmask = flag;
            this.STATUS_SET(0);
            this.STATUS_RESET(0);
        }

        void advance_lfo() {
            this.lfo_am_cnt += this.lfo_am_inc;
            if (this.lfo_am_cnt >= LFO_AM_TAB_ELEMENTS << 24) {
                this.lfo_am_cnt -= LFO_AM_TAB_ELEMENTS << 24;
            }
            int tmp = lfo_am_table[this.lfo_am_cnt >>> 24];
            this.LFO_AM = this.lfo_am_depth != 0 ? tmp : tmp >> 2;
            this.lfo_pm_cnt += this.lfo_pm_inc;
            this.LFO_PM = this.lfo_pm_cnt >>> 24 & 7 | this.lfo_pm_depth_range;
        }

        void advance() {
            OPL_SLOT op;
            OPL_CH CH;
            int i;
            this.eg_timer += this.eg_timer_add;
            while (this.eg_timer >= this.eg_timer_overflow) {
                this.eg_timer -= this.eg_timer_overflow;
                ++this.eg_cnt;
                block7: for (i = 0; i < 18; ++i) {
                    CH = this.P_CH[i / 2];
                    op = CH.SLOT[i & 1];
                    switch (op.state) {
                        case 4: {
                            if ((this.eg_cnt & (1 << op.eg_sh_ar) - 1) != 0) continue block7;
                            OPL_SLOT oPL_SLOT = op;
                            oPL_SLOT.volume = oPL_SLOT.volume + (~op.volume * FM_OPL.eg_inc[op.eg_sel_ar + (this.eg_cnt >> op.eg_sh_ar & 7)] >> 3);
                            if (op.volume > 0) continue block7;
                            op.volume = 0;
                            op.state = 3;
                            continue block7;
                        }
                        case 3: {
                            if ((this.eg_cnt & (1 << op.eg_sh_dr) - 1) != 0) continue block7;
                            op.volume += FM_OPL.eg_inc[op.eg_sel_dr + (this.eg_cnt >> op.eg_sh_dr & 7)];
                            if (op.volume < op.sl) continue block7;
                            op.state = 2;
                            continue block7;
                        }
                        case 2: {
                            if (op.eg_type != 0 || (this.eg_cnt & (1 << op.eg_sh_rr) - 1) != 0) continue block7;
                            op.volume += FM_OPL.eg_inc[op.eg_sel_rr + (this.eg_cnt >> op.eg_sh_rr & 7)];
                            if (op.volume < 511) continue block7;
                            op.volume = 511;
                            continue block7;
                        }
                        case 1: {
                            if ((this.eg_cnt & (1 << op.eg_sh_rr) - 1) != 0) continue block7;
                            op.volume += FM_OPL.eg_inc[op.eg_sel_rr + (this.eg_cnt >> op.eg_sh_rr & 7)];
                            if (op.volume < 511) continue block7;
                            op.volume = 511;
                            op.state = 0;
                            continue block7;
                        }
                    }
                }
            }
            for (i = 0; i < 18; ++i) {
                CH = this.P_CH[i / 2];
                op = CH.SLOT[i & 1];
                if (op.vib != 0) {
                    int block_fnum = CH.block_fnum;
                    int fnum_lfo = (block_fnum & 0x380) >> 7;
                    int lfo_fn_table_index_offset = lfo_pm_table[this.LFO_PM + 16 * fnum_lfo];
                    if (lfo_fn_table_index_offset != 0) {
                        int block = ((block_fnum += lfo_fn_table_index_offset) & 0x1C00) >> 10;
                        op.Cnt += (this.fn_tab[block_fnum & 0x3FF] >> 7 - block) * op.mul;
                        continue;
                    }
                    op.Cnt += op.Incr;
                    continue;
                }
                op.Cnt += op.Incr;
            }
            this.noise_p += this.noise_f;
            this.noise_p &= 0xFFFF;
            for (i = this.noise_p >> 16; i > 0; --i) {
                if ((this.noise_rng & 1) != 0) {
                    this.noise_rng ^= 0x800302;
                }
                this.noise_rng >>= 1;
            }
        }

        void CALC_CH(OPL_CH CH) {
            this.phase_modulation[0] = 0;
            OPL_SLOT SLOT = CH.SLOT[0];
            int env = this.volume_calc(SLOT);
            int out = SLOT.op1_out[0] + SLOT.op1_out[1];
            ((OPL_SLOT)SLOT).op1_out[0] = SLOT.op1_out[1];
            int[] nArray = SLOT.connect1;
            nArray[0] = nArray[0] + SLOT.op1_out[0];
            ((OPL_SLOT)SLOT).op1_out[1] = 0;
            if (env < ENV_QUIET) {
                if (SLOT.FB == 0) {
                    out = 0;
                }
                ((OPL_SLOT)SLOT).op1_out[1] = this.op_calc1(SLOT.Cnt, env, out << SLOT.FB, SLOT.wavetable);
            }
            if ((env = this.volume_calc(SLOT = CH.SLOT[1])) < ENV_QUIET) {
                this.output[0] = this.output[0] + this.op_calc(SLOT.Cnt, env, this.phase_modulation[0], SLOT.wavetable);
            }
        }

        void CALC_RH() {
            OPL_SLOT SLOT8_1;
            OPL_SLOT SLOT7_2;
            int noise = this.noise_rng & 1;
            this.phase_modulation[0] = 0;
            OPL_SLOT SLOT = this.P_CH[6].SLOT[0];
            int env = this.volume_calc(SLOT);
            int out = SLOT.op1_out[0] + SLOT.op1_out[1];
            ((OPL_SLOT)SLOT).op1_out[0] = SLOT.op1_out[1];
            if (SLOT.CON == 0) {
                this.phase_modulation[0] = SLOT.op1_out[0];
            }
            ((OPL_SLOT)SLOT).op1_out[1] = 0;
            if (env < ENV_QUIET) {
                if (SLOT.FB == 0) {
                    out = 0;
                }
                ((OPL_SLOT)SLOT).op1_out[1] = this.op_calc1(SLOT.Cnt, env, out << SLOT.FB, SLOT.wavetable);
            }
            if ((env = this.volume_calc(SLOT = this.P_CH[6].SLOT[1])) < ENV_QUIET) {
                this.output[0] = this.output[0] + this.op_calc(SLOT.Cnt, env, this.phase_modulation[0], SLOT.wavetable) * 2;
            }
            OPL_SLOT SLOT7_1 = this.P_CH[7].SLOT[0];
            OPL_SLOT SLOT8_2 = this.P_CH[8].SLOT[1];
            env = this.volume_calc(SLOT7_1);
            if (env < ENV_QUIET) {
                int bit7 = SLOT7_1.Cnt >>> 16 & 0x80;
                int bit3 = SLOT7_1.Cnt >>> 16 & 8;
                int bit2 = SLOT7_1.Cnt >>> 16 & 4;
                int res1 = bit2 ^ bit7 | bit3;
                int phase = res1 != 0 ? 564 : 208;
                int bit5e = SLOT8_2.Cnt >>> 16 & 0x20;
                int bit3e = SLOT8_2.Cnt >>> 16 & 8;
                int res2 = bit3e ^ bit5e;
                if (res2 != 0) {
                    phase = 564;
                }
                if ((phase & 0x200) != 0) {
                    if (noise != 0) {
                        phase = 720;
                    }
                } else if (noise != 0) {
                    phase = 52;
                }
                this.output[0] = this.output[0] + this.op_calc(phase << 16, env, 0, SLOT7_1.wavetable) * 2;
            }
            if ((env = this.volume_calc(SLOT7_2 = this.P_CH[7].SLOT[1])) < ENV_QUIET) {
                int phase;
                int bit8 = SLOT7_1.Cnt >>> 16 & 0x100;
                int n = phase = bit8 != 0 ? 512 : 256;
                if (noise != 0) {
                    phase ^= 0x100;
                }
                this.output[0] = this.output[0] + this.op_calc(phase << 16, env, 0, SLOT7_2.wavetable) * 2;
            }
            if ((env = this.volume_calc(SLOT8_1 = this.P_CH[8].SLOT[0])) < ENV_QUIET) {
                this.output[0] = this.output[0] + this.op_calc(SLOT8_1.Cnt, env, 0, SLOT8_1.wavetable) * 2;
            }
            if ((env = this.volume_calc(SLOT8_2)) < ENV_QUIET) {
                int bit7 = SLOT7_1.Cnt >>> 16 & 0x80;
                int bit3 = SLOT7_1.Cnt >>> 16 & 8;
                int bit2 = SLOT7_1.Cnt >>> 16 & 4;
                int res1 = bit2 ^ bit7 | bit3;
                int phase = res1 != 0 ? 768 : 256;
                int bit5e = SLOT8_2.Cnt >>> 16 & 0x20;
                int bit3e = SLOT8_2.Cnt >>> 16 & 8;
                int res2 = bit3e ^ bit5e;
                if (res2 != 0) {
                    phase = 768;
                }
                this.output[0] = this.output[0] + this.op_calc(phase << 16, env, 0, SLOT8_2.wavetable) * 2;
            }
        }

        private static int init_tables() {
            int i;
            double m;
            for (int x = 0; x < 256; ++x) {
                m = Math.floor(65536.0 / Math.pow(2.0, (double)(x + 1) * 0.03125 / 8.0));
                int n = (int)m;
                n = ((n >>= 4) & 1) != 0 ? (n >> 1) + 1 : (n >>= 1);
                FM_OPL.tl_tab[x * 2 + 0] = n <<= 1;
                FM_OPL.tl_tab[x * 2 + 1] = -tl_tab[x * 2 + 0];
                for (int i2 = 1; i2 < 12; ++i2) {
                    FM_OPL.tl_tab[x * 2 + 0 + i2 * 2 * 256] = tl_tab[x * 2 + 0] >> i2;
                    FM_OPL.tl_tab[x * 2 + 1 + i2 * 2 * 256] = -tl_tab[x * 2 + 0 + i2 * 2 * 256];
                }
            }
            for (i = 0; i < 1024; ++i) {
                m = Math.sin((double)(i * 2 + 1) * Math.PI / 1024.0);
                double o = m > 0.0 ? 8.0 * Math.log(1.0 / m) / Math.log(2.0) : 8.0 * Math.log(-1.0 / m) / Math.log(2.0);
                int n = (int)(2.0 * (o /= 0.03125));
                n = (n & 1) != 0 ? (n >> 1) + 1 : (n >>= 1);
                FM_OPL.sin_tab[i] = n * 2 + (m >= 0.0 ? 0 : 1);
            }
            for (i = 0; i < 1024; ++i) {
                FM_OPL.sin_tab[1024 + i] = (i & 0x200) != 0 ? TL_TAB_LEN : sin_tab[i];
                FM_OPL.sin_tab[2048 + i] = sin_tab[i & 0x1FF];
                FM_OPL.sin_tab[3072 + i] = (i & 0x100) != 0 ? TL_TAB_LEN : sin_tab[i & 0xFF];
            }
            return 1;
        }

        private void initialize() {
            this.freqbase = this.rate != 0 ? (double)this.clock / 72.0 / (double)this.rate : 0.0;
            this.TimerBase = this.clock != 0 ? 1.0 / ((double)this.clock / 72.0) : 0.0;
            for (int i = 0; i < 1024; ++i) {
                this.fn_tab[i] = (int)((double)i * 64.0 * this.freqbase * 64.0);
            }
            this.lfo_am_inc = (int)(262144.0 * this.freqbase);
            this.lfo_pm_inc = (int)(16384.0 * this.freqbase);
            this.noise_f = (int)(65536.0 * this.freqbase);
            this.eg_timer_add = (int)(65536.0 * this.freqbase);
            this.eg_timer_overflow = 65536;
        }

        private void WriteReg(int r, int v) {
            v &= 0xFF;
            block0 : switch ((r &= 0xFF) & 0xE0) {
                case 0: {
                    switch (r & 0x1F) {
                        case 1: {
                            if ((this.type & 1) == 0) break;
                            this.wavesel = v & 0x20;
                            break;
                        }
                        case 2: {
                            this.T[0] = (256 - v) * 4;
                            break;
                        }
                        case 3: {
                            this.T[1] = (256 - v) * 16;
                            break;
                        }
                        case 4: {
                            if ((v & 0x80) != 0) {
                                this.STATUS_RESET(119);
                                break;
                            }
                            int st1 = v & 1;
                            int st2 = v >> 1 & 1;
                            this.STATUS_RESET(v & 0x70);
                            this.STATUSMASK_SET(~v & 0x78);
                            if (this.st[1] != st2) {
                                this.st[1] = st2;
                                if (this.timer_handler != null) {
                                    this.timer_handler.invoke(1, st2 != 0 ? this.TimerBase * (double)this.T[1] : 0.0);
                                }
                            }
                            if (this.st[0] == st1) break block0;
                            this.st[0] = st1;
                            if (this.timer_handler == null) break block0;
                            this.timer_handler.invoke(0, st1 != 0 ? this.TimerBase * (double)this.T[0] : 0.0);
                            break;
                        }
                        case 8: {
                            this.mode = v;
                            break;
                        }
                    }
                    break;
                }
                case 32: {
                    int slot = slot_array[r & 0x1F];
                    if (slot < 0) {
                        return;
                    }
                    this.set_mul(slot, v);
                    break;
                }
                case 64: {
                    int slot = slot_array[r & 0x1F];
                    if (slot < 0) {
                        return;
                    }
                    this.set_ksl_tl(slot, v);
                    break;
                }
                case 96: {
                    int slot = slot_array[r & 0x1F];
                    if (slot < 0) {
                        return;
                    }
                    this.set_ar_dr(slot, v);
                    break;
                }
                case 128: {
                    int slot = slot_array[r & 0x1F];
                    if (slot < 0) {
                        return;
                    }
                    this.set_sl_rr(slot, v);
                    break;
                }
                case 160: {
                    int block_fnum;
                    if (r == 189) {
                        this.lfo_am_depth = v & 0x80;
                        this.lfo_pm_depth_range = (v & 0x40) != 0 ? 8 : 0;
                        this.rhythm = v & 0x3F;
                        if ((this.rhythm & 0x20) != 0) {
                            if ((v & 0x10) != 0) {
                                this.P_CH[6].SLOT[0].KEYON(2);
                                this.P_CH[6].SLOT[1].KEYON(2);
                            } else {
                                this.P_CH[6].SLOT[0].KEYOFF(-3);
                                this.P_CH[6].SLOT[1].KEYOFF(-3);
                            }
                            if ((v & 1) != 0) {
                                this.P_CH[7].SLOT[0].KEYON(2);
                            } else {
                                this.P_CH[7].SLOT[0].KEYOFF(-3);
                            }
                            if ((v & 8) != 0) {
                                this.P_CH[7].SLOT[1].KEYON(2);
                            } else {
                                this.P_CH[7].SLOT[1].KEYOFF(-3);
                            }
                            if ((v & 4) != 0) {
                                this.P_CH[8].SLOT[0].KEYON(2);
                            } else {
                                this.P_CH[8].SLOT[0].KEYOFF(-3);
                            }
                            if ((v & 2) != 0) {
                                this.P_CH[8].SLOT[1].KEYON(2);
                            } else {
                                this.P_CH[8].SLOT[1].KEYOFF(-3);
                            }
                        } else {
                            this.P_CH[6].SLOT[0].KEYOFF(-3);
                            this.P_CH[6].SLOT[1].KEYOFF(-3);
                            this.P_CH[7].SLOT[0].KEYOFF(-3);
                            this.P_CH[7].SLOT[1].KEYOFF(-3);
                            this.P_CH[8].SLOT[0].KEYOFF(-3);
                            this.P_CH[8].SLOT[1].KEYOFF(-3);
                        }
                        return;
                    }
                    if ((r & 0xF) > 8) {
                        return;
                    }
                    OPL_CH CH = this.P_CH[r & 0xF];
                    if ((r & 0x10) == 0) {
                        block_fnum = CH.block_fnum & 0x1F00 | v;
                    } else {
                        block_fnum = (v & 0x1F) << 8 | CH.block_fnum & 0xFF;
                        if ((v & 0x20) != 0) {
                            CH.SLOT[0].KEYON(1);
                            CH.SLOT[1].KEYON(1);
                        } else {
                            CH.SLOT[0].KEYOFF(-2);
                            CH.SLOT[1].KEYOFF(-2);
                        }
                    }
                    if (CH.block_fnum == block_fnum) break;
                    int block = block_fnum >> 10;
                    CH.block_fnum = block_fnum;
                    CH.ksl_base = (int)FM_OPL.ksl_tab[block_fnum >> 6];
                    CH.fc = this.fn_tab[block_fnum & 0x3FF] >> 7 - block;
                    CH.kcode = (CH.block_fnum & 0x1C00) >> 9;
                    if ((this.mode & 0x40) != 0) {
                        CH.kcode |= (CH.block_fnum & 0x100) >> 8;
                    } else {
                        CH.kcode |= (CH.block_fnum & 0x200) >> 9;
                    }
                    CH.SLOT[0].TLL = CH.SLOT[0].TL + (CH.ksl_base >>> CH.SLOT[0].ksl);
                    CH.SLOT[1].TLL = CH.SLOT[1].TL + (CH.ksl_base >>> CH.SLOT[1].ksl);
                    CH.CALC_FCSLOT(CH.SLOT[0]);
                    CH.CALC_FCSLOT(CH.SLOT[1]);
                    break;
                }
                case 192: {
                    if ((r & 0xF) > 8) {
                        return;
                    }
                    OPL_CH CH = this.P_CH[r & 0xF];
                    CH.SLOT[0].FB = (v >> 1 & 7) != 0 ? (v >> 1 & 7) + 7 : 0;
                    CH.SLOT[0].CON = v & 1;
                    OPL_SLOT.access$2602(CH.SLOT[0], CH.SLOT[0].CON != 0 ? this.output : this.phase_modulation);
                    break;
                }
                case 224: {
                    if (this.wavesel == 0) break;
                    int slot = slot_array[r & 0x1F];
                    if (slot < 0) {
                        return;
                    }
                    OPL_CH CH = this.P_CH[slot / 2];
                    CH.SLOT[slot & 1].wavetable = (v & 3) * 1024;
                }
            }
        }

        private void ResetChip() {
            this.eg_timer = 0;
            this.eg_cnt = 0;
            this.noise_rng = 1;
            this.mode = 0;
            this.STATUS_RESET(127);
            this.WriteReg(1, 0);
            this.WriteReg(2, 0);
            this.WriteReg(3, 0);
            this.WriteReg(4, 0);
            for (int i = 255; i >= 32; --i) {
                this.WriteReg(i, 0);
            }
            for (OPL_CH CH : this.P_CH) {
                for (OPL_SLOT SLOT : CH.SLOT) {
                    SLOT.wavetable = 0;
                    SLOT.state = 0;
                    SLOT.volume = 511;
                }
            }
        }

        private void postload() {
            for (OPL_CH CH : this.P_CH) {
                int block_fnum = CH.block_fnum;
                CH.ksl_base = (int)FM_OPL.ksl_tab[block_fnum >> 6];
                CH.fc = this.fn_tab[block_fnum & 0x3FF] >> 7 - (block_fnum >> 10);
                for (OPL_SLOT SLOT : CH.SLOT) {
                    SLOT.ksr = CH.kcode >>> SLOT.KSR;
                    if (SLOT.ar + SLOT.ksr < 78) {
                        SLOT.eg_sh_ar = eg_rate_shift[SLOT.ar + SLOT.ksr];
                        SLOT.eg_sel_ar = eg_rate_select[SLOT.ar + SLOT.ksr];
                    } else {
                        SLOT.eg_sh_ar = 0;
                        SLOT.eg_sel_ar = 104;
                    }
                    SLOT.eg_sh_dr = eg_rate_shift[SLOT.dr + SLOT.ksr];
                    SLOT.eg_sel_dr = eg_rate_select[SLOT.dr + SLOT.ksr];
                    SLOT.eg_sh_rr = eg_rate_shift[SLOT.rr + SLOT.ksr];
                    SLOT.eg_sel_rr = eg_rate_select[SLOT.rr + SLOT.ksr];
                    SLOT.Incr = CH.fc * SLOT.mul;
                    SLOT.TLL = SLOT.TL + (CH.ksl_base >>> SLOT.ksl);
                    OPL_SLOT.access$2602(SLOT, SLOT.CON != 0 ? this.output : this.phase_modulation);
                }
            }
        }

        void set_mul(int slot, int v) {
            OPL_CH CH = this.P_CH[slot / 2];
            OPL_SLOT SLOT = CH.SLOT[slot & 1];
            SLOT.mul = FM_OPL.mul_tab[v & 0xF];
            SLOT.KSR = (v & 0x10) != 0 ? 0 : 2;
            SLOT.eg_type = v & 0x20;
            SLOT.vib = v & 0x40;
            SLOT.AMmask = (v & 0x80) != 0 ? -1 : 0;
            CH.CALC_FCSLOT(SLOT);
        }

        void set_ksl_tl(int slot, int v) {
            OPL_CH CH = this.P_CH[slot / 2];
            OPL_SLOT SLOT = CH.SLOT[slot & 1];
            SLOT.ksl = FM_OPL.ksl_shift[v >> 6];
            SLOT.TL = (v & 0x3F) << 2;
            SLOT.TLL = SLOT.TL + (CH.ksl_base >>> SLOT.ksl);
        }

        void set_ar_dr(int slot, int v) {
            OPL_CH CH = this.P_CH[slot / 2];
            OPL_SLOT SLOT = CH.SLOT[slot & 1];
            SLOT.ar = v >> 4 != 0 ? 16 + (v >> 4 << 2) : 0;
            if (SLOT.ar + SLOT.ksr < 78) {
                SLOT.eg_sh_ar = eg_rate_shift[SLOT.ar + SLOT.ksr];
                SLOT.eg_sel_ar = eg_rate_select[SLOT.ar + SLOT.ksr];
            } else {
                SLOT.eg_sh_ar = 0;
                SLOT.eg_sel_ar = 104;
            }
            SLOT.dr = (v & 0xF) != 0 ? 16 + ((v & 0xF) << 2) : 0;
            SLOT.eg_sh_dr = eg_rate_shift[SLOT.dr + SLOT.ksr];
            SLOT.eg_sel_dr = eg_rate_select[SLOT.dr + SLOT.ksr];
        }

        void set_sl_rr(int slot, int v) {
            OPL_CH CH = this.P_CH[slot / 2];
            OPL_SLOT SLOT = CH.SLOT[slot & 1];
            SLOT.sl = FM_OPL.sl_tab[v >> 4];
            SLOT.rr = (v & 0xF) != 0 ? 16 + ((v & 0xF) << 2) : 0;
            SLOT.eg_sh_rr = eg_rate_shift[SLOT.rr + SLOT.ksr];
            SLOT.eg_sel_rr = eg_rate_select[SLOT.rr + SLOT.ksr];
        }

        void clock_changed(int c, int r) {
            this.clock = c;
            this.rate = r;
            this.initialize();
        }

        int Write(int a, int v) {
            if ((a & 1) == 0) {
                this.address = v & 0xFF;
            } else {
                if (this.UpdateHandler != null) {
                    this.UpdateHandler.invoke(0);
                }
                this.WriteReg(this.address, v);
            }
            return this.status >> 7;
        }

        int Read(int a) {
            if ((a & 1) == 0) {
                return this.status & (this.statusmask | 0x80);
            }
            return 255;
        }

        private int TimerOver(int c) {
            if (c != 0) {
                this.STATUS_SET(32);
            } else {
                this.STATUS_SET(64);
                if ((this.mode & 0x80) != 0) {
                    if (this.UpdateHandler != null) {
                        this.UpdateHandler.invoke(0);
                    }
                    for (int ch = 0; ch < 9; ++ch) {
                        this.P_CH[ch].CSMKeyControll();
                    }
                }
            }
            if (this.timer_handler != null) {
                this.timer_handler.invoke(c, this.TimerBase * (double)this.T[c]);
            }
            return this.status >> 7;
        }

        private static FM_OPL Create(int clock, int rate, int type) {
            if (FM_OPL.LockTable() == -1) {
                return null;
            }
            FM_OPL OPL = new FM_OPL();
            for (int i = 0; i < OPL.P_CH.length; ++i) {
                OPL.P_CH[i] = new OPL_CH();
                for (int j = 0; j < OPL.P_CH[i].SLOT.length; ++j) {
                    ((OPL_CH)OPL.P_CH[i]).SLOT[j] = new OPL_SLOT();
                }
            }
            OPL.type = type;
            OPL.clock_changed(clock, rate);
            return OPL;
        }

        private final int volume_calc(OPL_SLOT OP) {
            return OP.TLL + OP.volume + (this.LFO_AM & OP.AMmask);
        }

        private int op_calc(long phase, int env, int pm, int wave_tab) {
            int p = (env << 4) + sin_tab[wave_tab + ((int)((phase & 0xFFFFFFFFFFFF0000L) + (long)(pm << 16)) >> 16 & 0x3FF)];
            return p >= TL_TAB_LEN ? 0 : tl_tab[p];
        }

        private int op_calc1(long phase, int env, int pm, int wave_tab) {
            int p = (env << 4) + sin_tab[wave_tab + ((int)((phase & 0xFFFFFFFFFFFF0000L) + (long)pm) >> 16 & 0x3FF)];
            return p >= TL_TAB_LEN ? 0 : tl_tab[p];
        }

        private static int LockTable() {
            if (++num_lock > 1) {
                return 0;
            }
            if (FM_OPL.init_tables() == 0) {
                --num_lock;
                return -1;
            }
            return 0;
        }

        void SetTimerHandler(OPL_TIMERHANDLER handler) {
            this.timer_handler = handler;
        }

        void SetIRQHandler(OPL_IRQHANDLER handler) {
            this.IRQHandler = handler;
        }

        void SetUpdateHandler(OPL_UPDATEHANDLER handler) {
            this.UpdateHandler = handler;
        }
    }

    private static class OPL_CH {
        private OPL_SLOT[] SLOT = new OPL_SLOT[2];
        private int block_fnum;
        private int fc;
        private int ksl_base;
        private int kcode;

        private OPL_CH() {
        }

        private void CALC_FCSLOT(OPL_SLOT SLOT) {
            SLOT.Incr = this.fc * SLOT.mul;
            int ksr = this.kcode >>> SLOT.KSR;
            if (SLOT.ksr != ksr) {
                SLOT.ksr = ksr;
                if (SLOT.ar + SLOT.ksr < 78) {
                    SLOT.eg_sh_ar = eg_rate_shift[SLOT.ar + SLOT.ksr];
                    SLOT.eg_sel_ar = eg_rate_select[SLOT.ar + SLOT.ksr];
                } else {
                    SLOT.eg_sh_ar = 0;
                    SLOT.eg_sel_ar = 104;
                }
                SLOT.eg_sh_dr = eg_rate_shift[SLOT.dr + SLOT.ksr];
                SLOT.eg_sel_dr = eg_rate_select[SLOT.dr + SLOT.ksr];
                SLOT.eg_sh_rr = eg_rate_shift[SLOT.rr + SLOT.ksr];
                SLOT.eg_sel_rr = eg_rate_select[SLOT.rr + SLOT.ksr];
            }
        }

        void CSMKeyControll() {
            this.SLOT[0].KEYON(4);
            this.SLOT[1].KEYON(4);
            this.SLOT[0].KEYOFF(-5);
            this.SLOT[1].KEYOFF(-5);
        }
    }

    static interface OPL_TIMERHANDLER {
        public void invoke(int var1, double var2);
    }

    static interface OPL_IRQHANDLER {
        public void invoke(int var1);
    }

    static interface OPL_UPDATEHANDLER {
        public void invoke(int var1);
    }

    private static class OPL_SLOT {
        private int ar;
        private int dr;
        private int rr;
        private int KSR;
        private int ksl;
        private int ksr;
        private int mul;
        private int Cnt;
        private int Incr;
        private int FB;
        private int[] connect1;
        private int[] op1_out = new int[2];
        private int CON;
        private int eg_type;
        private int state;
        private int TL;
        private int TLL;
        private int volume;
        private int sl;
        private int eg_sh_ar;
        private int eg_sel_ar;
        private int eg_sh_dr;
        private int eg_sel_dr;
        private int eg_sh_rr;
        private int eg_sel_rr;
        private int key;
        private int AMmask;
        private int vib;
        private int wavetable;

        private OPL_SLOT() {
        }

        private void KEYON(int key_set) {
            if (this.key == 0) {
                this.Cnt = 0;
                this.state = 4;
            }
            this.key |= key_set;
        }

        private void KEYOFF(int key_clr) {
            if (this.key != 0) {
                this.key &= key_clr;
                if (this.key == 0 && this.state > 1) {
                    this.state = 1;
                }
            }
        }

        static /* synthetic */ int[] access$2602(OPL_SLOT x0, int[] x1) {
            x0.connect1 = x1;
            return x1;
        }
    }
}

