/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.directory;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.CBMCodeUtils;
import libsidutils.directory.DirEntry;
import libsidutils.directory.Directory;
import libsidutils.siddatabase.SidDatabase;

public class TuneDirectory
extends Directory {
    private static final int MAXLEN_FILENAME = 16;

    public TuneDirectory(File hvscRoot, File tuneFile) throws IOException, SidTuneError {
        String playerId;
        SidTune tune = SidTune.load(tuneFile);
        DoubleSupplier lengthFnct = () -> 0.0;
        if (hvscRoot != null) {
            SidDatabase db = new SidDatabase(hvscRoot);
            lengthFnct = () -> db.getTuneLength(tune);
        }
        SidTuneInfo info = tune.getInfo();
        Iterator<String> descriptionIt = info.getInfoString().iterator();
        String title = tuneFile.getName();
        String author = null;
        String released = null;
        if (descriptionIt.hasNext()) {
            title = descriptionIt.next();
        }
        if (descriptionIt.hasNext()) {
            author = descriptionIt.next();
        }
        if (descriptionIt.hasNext()) {
            released = descriptionIt.next();
        }
        this.title = this.toTitle(title);
        this.id = this.toId(info.getStartSong(), info.getSongs());
        if (author != null && author.length() > 0) {
            this.dirEntries.add(this.toDirEntry(author));
        }
        if (released != null && released.length() > 0) {
            this.dirEntries.add(this.toDirEntry(released));
        }
        if ((playerId = tune.identify().stream().collect(Collectors.joining(","))) != null && playerId.length() > 0) {
            this.dirEntries.add(this.toDirEntry(playerId));
        }
        this.dirEntries.add(this.toDirEntry("" + (Object)((Object)info.getCompatibility())));
        if (info.getClockSpeed() != SidTune.Clock.UNKNOWN) {
            this.dirEntries.add(this.toDirEntry("" + (Object)((Object)info.getClockSpeed())));
        }
        this.dirEntries.add(this.toDirEntry("" + (Object)((Object)tune.getSongSpeed(1))));
        this.dirEntries.add(this.toDirEntry("" + info.getAudioTypeString()));
        if (info.getSIDModel(0) != SidTune.Model.UNKNOWN) {
            this.dirEntries.add(this.toDirEntry("" + (Object)((Object)info.getSIDModel(0))));
        }
        if (info.getSIDModel(1) != SidTune.Model.UNKNOWN) {
            this.dirEntries.add(this.toDirEntry("" + (Object)((Object)info.getSIDModel(1))));
        }
        if (info.getSIDModel(2) != SidTune.Model.UNKNOWN) {
            this.dirEntries.add(this.toDirEntry("" + (Object)((Object)info.getSIDModel(2))));
        }
        this.dirEntries.add(this.toDirEntry(String.format("$%04X", info.getSIDChipBase(0))));
        if (info.getSIDChipBase(1) != 0) {
            this.dirEntries.add(this.toDirEntry(String.format("$%04X", info.getSIDChipBase(1))));
        }
        if (info.getSIDChipBase(2) != 0) {
            this.dirEntries.add(this.toDirEntry(String.format("$%04X", info.getSIDChipBase(2))));
        }
        this.dirEntries.add(this.toDirEntry(lengthFnct.getAsDouble() + "s"));
        this.dirEntries.add(this.toDirEntry("DRV_ADDR=" + info.getDeterminedDriverAddr()));
        this.dirEntries.add(this.toDirEntry("LOAD_ADDR=" + info.getLoadAddr()));
        this.dirEntries.add(this.toDirEntry("LOAD_LGTH=" + info.getC64dataLen()));
        this.dirEntries.add(this.toDirEntry("INIT_ADDR=" + info.getInitAddr()));
        this.dirEntries.add(this.toDirEntry("PLY_ADDR=" + info.getPlayAddr()));
        this.dirEntries.add(this.toDirEntry("SIZE_KB=" + (tuneFile.length() >> 10)));
        this.dirEntries.add(this.toDirEntry("SIZE_B=" + tuneFile.length()));
        this.dirEntries.add(this.toDirEntry("RELOC_PAGE=" + info.getRelocStartPage()));
        this.dirEntries.add(this.toDirEntry("RELOC_PAGES=" + info.getRelocPages()));
        this.dirEntries.add(this.toDirEntry("" + Instant.ofEpochMilli(tuneFile.lastModified()).atZone(ZoneId.systemDefault()).toLocalDateTime()));
    }

    private byte[] toTitle(String str) {
        return CBMCodeUtils.iso88591ToScreenRam(str.toUpperCase(Locale.US), 16);
    }

    private byte[] toId(int startSong, int songs) {
        return CBMCodeUtils.iso88591ToScreenRam(String.format("%02X/%02X", startSong, songs), 5);
    }

    private DirEntry toDirEntry(String str) {
        return new DirEntry(0, CBMCodeUtils.iso88591ToScreenRam(str.toUpperCase(Locale.US), 16), -1);
    }
}

