/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.prg2tap;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import libsidutils.assembler.KickAssembler;
import libsidutils.assembler.KickAssemblerResult;
import libsidutils.prg2tap.PRG2TAPProgram;

public class PRG2TAP {
    private static final String TURBO_HEADER_ASM = "/libsidutils/prg2tap/PRG2TAP_TurboHeader.asm";
    private static final String TURBO_DATA_ASM = "/libsidutils/prg2tap/PRG2TAP_TurboData.asm";
    private static final String SLOW_HEADER_ASM = "/libsidutils/prg2tap/PRG2TAP_SlowHeader.asm";
    private static final String TURBO_HEADER_BIN = "/libsidutils/prg2tap/PRG2TAP_TurboHeader.bin";
    private static final String TURBO_DATA_BIN = "/libsidutils/prg2tap/PRG2TAP_TurboData.bin";
    private static final String SLOW_HEADER_BIN = "/libsidutils/prg2tap/PRG2TAP_SlowHeader.bin";
    public static boolean USE_KICKASSEMBLER;
    static final int MAX_NAME_LENGTH = 16;
    private static final int TAP_HEADER_SIZE = 20;
    private static final int[] PULSE_LENGTH;
    private byte tapVersion = 1;
    private int threshold = 263;
    private boolean turboTape = true;
    private List<Byte> result = new ArrayList<Byte>();

    public final void setTapVersion(byte tapVersion) {
        assert (tapVersion != 0 && tapVersion != 1);
        this.tapVersion = tapVersion;
    }

    public final void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public final void setTurboTape(boolean turboTape) {
        this.turboTape = turboTape;
    }

    public void add(PRG2TAPProgram program) throws IOException {
        if (USE_KICKASSEMBLER) {
            this.addAssembled(program);
        } else {
            this.addBin(program, this.compile(TURBO_HEADER_BIN), this.compile(TURBO_DATA_BIN), this.compile(SLOW_HEADER_BIN));
        }
    }

    public void addAssembled(PRG2TAPProgram program) throws IOException {
        if (this.turboTape) {
            HashMap<String, String> globals = new HashMap<String, String>();
            globals.put("name", this.getName(program));
            globals.put("threshold", String.valueOf(this.threshold));
            byte[] header = this.compileAssembled(globals, TURBO_HEADER_ASM);
            this.slowConvert(header, 0, header.length, 20000);
            this.addSilence(200000);
            globals = new HashMap();
            byte[] data = this.compileAssembled(globals, TURBO_DATA_ASM);
            this.slowConvert(data, 0, data.length, 5000);
            this.addSilence(1000000);
            this.turbotapeConvert(program);
        } else {
            int start = program.getStartAddr();
            int end = start + program.getLength();
            HashMap<String, String> globals = new HashMap<String, String>();
            globals.put("name", this.getName(program));
            globals.put("start", String.valueOf(start));
            globals.put("end", String.valueOf(end));
            byte[] header = this.compileAssembled(globals, SLOW_HEADER_ASM);
            this.slowConvert(header, 0, header.length, 20000);
            this.addSilence(200000);
            this.slowConvert(program.getMem(), start, end - start, 5000);
        }
    }

    public void addBin(PRG2TAPProgram program, byte[] turboHeaderBin, byte[] turboDataBin, byte[] slowHeaderBin) throws IOException {
        if (this.turboTape) {
            byte[] header = turboHeaderBin;
            for (int i = 0; i < 16; ++i) {
                header[5 + i] = program.getName()[i];
            }
            header[140] = (byte)(this.threshold & 0xFF);
            header[145] = (byte)(this.threshold >> 8);
            this.slowConvert(header, 0, header.length, 20000);
            this.addSilence(200000);
            byte[] data = turboDataBin;
            this.slowConvert(data, 0, data.length, 5000);
            this.addSilence(1000000);
            this.turbotapeConvert(program);
        } else {
            int start = program.getStartAddr();
            int end = start + program.getLength();
            byte[] header = slowHeaderBin;
            header[1] = (byte)(program.getStartAddr() & 0xFF);
            header[2] = (byte)(program.getStartAddr() >> 8 & 0xFF);
            header[3] = (byte)(program.getStartAddr() + program.getLength() & 0xFF);
            header[4] = (byte)(program.getStartAddr() + program.getLength() >> 8 & 0xFF);
            for (int i = 0; i < 16; ++i) {
                header[5 + i] = program.getName()[i];
            }
            this.slowConvert(header, 0, header.length, 20000);
            this.addSilence(200000);
            this.slowConvert(program.getMem(), start, end - start, 5000);
        }
    }

    private byte[] compileAssembled(HashMap<String, String> globals, String resource) {
        InputStream asm = PRG2TAP.class.getResourceAsStream(resource);
        KickAssemblerResult kickassemblerResult = KickAssembler.assemble(resource, asm, globals);
        return Arrays.copyOfRange(kickassemblerResult.getData(), 2, kickassemblerResult.getData().length);
    }

    private byte[] compile(String compiledBin) {
        byte[] DRIVER;
        try (DataInputStream is = new DataInputStream(PRG2TAP.class.getResourceAsStream(compiledBin));){
            URL url = PRG2TAP.class.getResource(compiledBin);
            DRIVER = new byte[url.openConnection().getContentLength()];
            is.readFully(DRIVER);
        }
        catch (IOException e) {
            throw new RuntimeException("Load failed for resource: " + compiledBin);
        }
        return DRIVER;
    }

    private String getName(PRG2TAPProgram program) {
        String name = "";
        for (int i = 0; i < 16; ++i) {
            name = name + (char)program.getName()[i];
        }
        return name;
    }

    public void addSilence(int ncycles) throws IOException {
        if (ncycles < 2048) {
            this.result.add((byte)(ncycles / 8));
        } else {
            this.result.add((byte)0);
            if (this.tapVersion == 0) {
                return;
            }
            this.result.add((byte)(ncycles & 0xFF));
            this.result.add((byte)(ncycles >> 8 & 0xFF));
            this.result.add((byte)(ncycles >> 16 & 0xFF));
        }
    }

    public void open() throws IOException {
        byte[] header;
        for (byte b : header = "C64-TAPE-RAW".getBytes("ISO-8859-1")) {
            this.result.add(b);
        }
        this.result.add(this.tapVersion);
        for (int i = 0; i < 20 - header.length; ++i) {
            this.result.add((byte)0);
        }
    }

    public void close() {
        long size = this.result.size() - 20;
        this.result.set(16, (byte)(size & 0xFFL));
        this.result.set(17, (byte)(size >> 8 & 0xFFL));
        this.result.set(18, (byte)(size >> 16 & 0xFFL));
        this.result.set(19, (byte)(size >> 24 & 0xFFL));
    }

    public byte[] getResult() {
        byte[] out = new byte[this.result.size()];
        for (int i = 0; i < this.result.size(); ++i) {
            out[i] = this.result.get(i);
        }
        return out;
    }

    private void slowConvert(byte[] data, int startAddr, int length, int leadinLen) throws IOException {
        int i;
        int i2;
        for (i2 = 0; i2 < leadinLen; ++i2) {
            this.addSilence(PULSE_LENGTH[0]);
        }
        for (i2 = 137; i2 > 128; --i2) {
            this.slowWriteByte((byte)i2);
        }
        byte checksum = 0;
        for (i = 0; i < length; ++i) {
            this.slowWriteByte(data[startAddr + i]);
            checksum = (byte)(checksum ^ data[startAddr + i]);
        }
        this.slowWriteByte(checksum);
        this.addSilence(PULSE_LENGTH[2]);
        this.addSilence(PULSE_LENGTH[0]);
        for (i = 0; i < 79; ++i) {
            this.addSilence(PULSE_LENGTH[0]);
        }
        for (i = 9; i > 0; --i) {
            this.slowWriteByte((byte)i);
        }
        for (i = 0; i < length; ++i) {
            this.slowWriteByte(data[startAddr + i]);
        }
        this.slowWriteByte(checksum);
        this.addSilence(PULSE_LENGTH[2]);
        this.addSilence(PULSE_LENGTH[0]);
        for (i = 0; i < 200; ++i) {
            this.addSilence(PULSE_LENGTH[0]);
        }
    }

    private void slowWriteByte(byte byt) throws IOException {
        this.addSilence(PULSE_LENGTH[2]);
        this.addSilence(PULSE_LENGTH[1]);
        boolean parity = true;
        byte count = 1;
        do {
            if ((byt & count) != 0) {
                parity ^= true;
                this.addSilence(PULSE_LENGTH[1]);
                this.addSilence(PULSE_LENGTH[0]);
                continue;
            }
            this.addSilence(PULSE_LENGTH[0]);
            this.addSilence(PULSE_LENGTH[1]);
        } while ((count = (byte)(count << 1)) != 0);
        if (parity) {
            this.addSilence(PULSE_LENGTH[1]);
            this.addSilence(PULSE_LENGTH[0]);
        } else {
            this.addSilence(PULSE_LENGTH[0]);
            this.addSilence(PULSE_LENGTH[1]);
        }
    }

    private void turbotapeConvert(PRG2TAPProgram program) throws IOException {
        int i;
        int i2;
        for (i2 = 0; i2 < 630; ++i2) {
            this.turbotapeWriteByte((byte)2);
        }
        for (i2 = 9; i2 >= 1; --i2) {
            this.turbotapeWriteByte((byte)i2);
        }
        this.turbotapeWriteByte((byte)1);
        this.turbotapeWriteByte((byte)(program.getStartAddr() & 0xFF));
        this.turbotapeWriteByte((byte)(program.getStartAddr() >> 8 & 0xFF));
        this.turbotapeWriteByte((byte)(program.getStartAddr() + program.getLength() & 0xFF));
        this.turbotapeWriteByte((byte)(program.getStartAddr() + program.getLength() >> 8 & 0xFF));
        this.turbotapeWriteByte((byte)0);
        for (i2 = 0; i2 < 16; ++i2) {
            this.turbotapeWriteByte(program.getName()[i2]);
        }
        for (i2 = 0; i2 < 171; ++i2) {
            this.turbotapeWriteByte((byte)32);
        }
        for (i2 = 0; i2 < 630; ++i2) {
            this.turbotapeWriteByte((byte)2);
        }
        for (i2 = 9; i2 >= 1; --i2) {
            this.turbotapeWriteByte((byte)i2);
        }
        this.turbotapeWriteByte((byte)0);
        byte checksum = 0;
        for (i = 0; i < program.getLength(); ++i) {
            this.turbotapeWriteByte(program.getMem()[program.getStartAddr() + i]);
            checksum = (byte)(checksum ^ program.getMem()[program.getStartAddr() + i]);
        }
        this.turbotapeWriteByte(checksum);
        for (i = 0; i < 630; ++i) {
            this.turbotapeWriteByte((byte)0);
        }
    }

    private void turbotapeWriteByte(byte byt) throws IOException {
        int zeroBit = this.threshold * 4 / 5;
        int oneBit = this.threshold * 13 / 10;
        int count = 128;
        do {
            if ((byt & count) != 0) {
                this.addSilence(oneBit);
                continue;
            }
            this.addSilence(zeroBit);
        } while ((count >>= 1) != 0);
    }

    static {
        PULSE_LENGTH = new int[]{384, 536, 680};
    }
}

