/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.siddatabase;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeConverter {
    private static final Pattern TIME_VALUE = Pattern.compile("([0-9]{1,2}):([0-9]{2})(\\.[0-9]{1,3})?(?:\\(.*)?");
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);

    public Double fromString(String time) {
        try {
            Matcher m = TIME_VALUE.matcher(time);
            if (!m.matches()) {
                return -1.0;
            }
            int minutes = Integer.parseInt(m.group(1));
            int seconds = Integer.parseInt(m.group(2));
            int millis = m.group(3) != null ? (int)(NUMBER_FORMAT.parse(m.group(3)).doubleValue() * 1000.0) : 0;
            return (double)new Calendar.Builder().setTimeZone(TimeZone.getTimeZone("UTC")).set(12, minutes).set(13, seconds).set(14, millis).build().getTime().getTime() / 1000.0;
        }
        catch (NumberFormatException | ParseException e) {
            return -1.0;
        }
    }

    public String toString(Double seconds) {
        if (seconds == null || seconds == -1.0) {
            return "00:00";
        }
        return new SimpleDateFormat("mm:ss.SSS").format(new Date((long)(seconds * 1000.0)));
    }
}

