/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.rtmp;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import libsidplay.components.keyboard.KeyTableEntry;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestparam.VideoRequestParamServletParameters;
import server.restful.common.rtmp.PlayerCleanupTimerTask;

@WebServlet(name="PressKeyServlet", displayName="PressKeyServlet", urlPatterns={"/static/press_key"}, description="Press key for emulator running as a RTMP live video stream")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class PressKeyServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            PressKeyServletParameters servletParameters = new PressKeyServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            UUID uuid = servletParameters.getUuid();
            if (servletParameters.type != null) {
                ServletUtil.info(this.getServletContext(), String.format("typeKey: RTMP stream of: %s, key=%s", uuid, servletParameters.type.name()), new Thread[0]);
                PlayerCleanupTimerTask.update(uuid, rtmpPlayerWithStatus -> rtmpPlayerWithStatus.typeKey(servletParameters.type));
            } else if (servletParameters.press != null) {
                ServletUtil.info(this.getServletContext(), String.format("pressKey: RTMP stream of: %s, key=%s", uuid, servletParameters.press.name()), new Thread[0]);
                PlayerCleanupTimerTask.update(uuid, rtmpPlayerWithStatus -> rtmpPlayerWithStatus.pressKey(servletParameters.press));
            } else if (servletParameters.release != null) {
                ServletUtil.info(this.getServletContext(), String.format("releaseKey: RTMP stream of: %s, key=%s", uuid, servletParameters.release.name()), new Thread[0]);
                PlayerCleanupTimerTask.update(uuid, rtmpPlayerWithStatus -> rtmpPlayerWithStatus.releaseKey(servletParameters.release));
            }
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.rtmp.PressKeyServletParameters")
    public static class PressKeyServletParameters
    extends VideoRequestParamServletParameters {
        @Parameter(names={"--type"}, descriptionKey="TYPE", order=-2147483646)
        private KeyTableEntry type;
        @Parameter(names={"--press"}, descriptionKey="PRESS", order=-2147483645)
        private KeyTableEntry press;
        @Parameter(names={"--release"}, descriptionKey="RELEASE", order=-2147483644)
        private KeyTableEntry release;
    }
}

