/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import libsidplay.config.IAudioSection;
import libsidplay.sidtune.MP3Tune;
import libsidplay.sidtune.SidTune;
import sidplay.audio.AACDriver;
import sidplay.audio.AVIDriver;
import sidplay.audio.AudioDriver;
import sidplay.audio.CmpToMP3FileDriver;
import sidplay.audio.FLACDriver;
import sidplay.audio.FLVDriver;
import sidplay.audio.JMP3Driver;
import sidplay.audio.JWAVDriver;
import sidplay.audio.JavaSound;
import sidplay.audio.MP3Driver;
import sidplay.audio.MP4Driver;
import sidplay.audio.ProxyDriver;
import sidplay.audio.SIDDumpDriver;
import sidplay.audio.SIDRegDriver;
import sidplay.audio.WAVDriver;

public enum Audio {
    SOUNDCARD(JavaSound.class, new Class[0]),
    WAV(WAVDriver.WAVFileDriver.class, new Class[0]),
    JWAV(JWAVDriver.JWAVFileDriver.class, new Class[0]),
    FLAC(FLACDriver.FLACFileDriver.class, new Class[0]),
    AAC(AACDriver.AACFileDriver.class, new Class[0]),
    MP3(MP3Driver.MP3FileDriver.class, new Class[0]),
    JMP3(JMP3Driver.JMP3FileDriver.class, new Class[0]),
    FLV(FLVDriver.FLVFileDriver.class, new Class[0]),
    AVI(AVIDriver.AVIFileDriver.class, new Class[0]),
    MP4(MP4Driver.MP4FileDriver.class, new Class[0]),
    SID_REG(SIDRegDriver.SIDRegFileDriver.class, new Class[0]),
    SID_DUMP(SIDDumpDriver.SIDDumpFileDriver.class, new Class[0]),
    LIVE_WAV(ProxyDriver.class, JavaSound.class, WAVDriver.WAVFileDriver.class),
    LIVE_JWAV(ProxyDriver.class, JavaSound.class, JWAVDriver.JWAVFileDriver.class),
    LIVE_FLAC(ProxyDriver.class, JavaSound.class, FLACDriver.FLACFileDriver.class),
    LIVE_AAC(ProxyDriver.class, JavaSound.class, AACDriver.AACFileDriver.class),
    LIVE_MP3(ProxyDriver.class, JavaSound.class, MP3Driver.MP3FileDriver.class),
    LIVE_JMP3(ProxyDriver.class, JavaSound.class, JMP3Driver.JMP3FileDriver.class),
    LIVE_FLV(ProxyDriver.class, JavaSound.class, FLVDriver.FLVFileDriver.class),
    LIVE_AVI(ProxyDriver.class, JavaSound.class, AVIDriver.AVIFileDriver.class),
    LIVE_MP4(ProxyDriver.class, JavaSound.class, MP4Driver.MP4FileDriver.class),
    LIVE_VIDEO_STREAMING(ProxyDriver.class, JavaSound.class, FLVDriver.FLVStreamDriver.class),
    LIVE_SID_REG(ProxyDriver.class, JavaSound.class, SIDRegDriver.SIDRegFileDriver.class),
    LIVE_SID_DUMP(ProxyDriver.class, JavaSound.class, SIDDumpDriver.SIDDumpFileDriver.class),
    COMPARE_MP3(CmpToMP3FileDriver.class, new Class[0]);

    private final Class<? extends AudioDriver> audioDriverClass;
    private final Class<? extends AudioDriver>[] parameterClasses;
    private AudioDriver audioDriver;

    @SafeVarargs
    private Audio(Class<? extends AudioDriver> audioDriverClass, Class<? extends AudioDriver> ... parameters) {
        this.audioDriverClass = audioDriverClass;
        this.parameterClasses = parameters;
    }

    public final AudioDriver getAudioDriver() {
        if (this.audioDriver == null) {
            this.audioDriver = this.newAudioDriver();
        }
        return this.audioDriver;
    }

    public final AudioDriver newAudioDriver() {
        try {
            Class[] parameterTypes = (Class[])Stream.generate(() -> AudioDriver.class).limit(this.parameterClasses.length).toArray(Class[]::new);
            ArrayList<AudioDriver> initArgs = new ArrayList<AudioDriver>();
            for (Class<? extends AudioDriver> parameterClass : this.parameterClasses) {
                initArgs.add(Stream.of(Audio.values()).map(audio -> audio.audioDriver).filter(parameterClass::isInstance).findFirst().orElse(parameterClass.getConstructor(new Class[0]).newInstance(new Object[0])));
            }
            return this.audioDriverClass.getConstructor(parameterTypes).newInstance(initArgs.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Audiodriver cannot be instanciated: " + this.audioDriverClass.getName(), e);
        }
    }

    public final AudioDriver getAudioDriver(IAudioSection audioSection, SidTune tune) {
        if (tune instanceof MP3Tune) {
            audioSection.setMp3(((MP3Tune)tune).getMP3());
            audioSection.setPlayOriginal(true);
            return COMPARE_MP3.getAudioDriver();
        }
        return this.getAudioDriver();
    }

    public static final List<Audio> getLiveAudio() {
        return Stream.of(Audio.values()).filter(audio -> Arrays.asList(JavaSound.class, ProxyDriver.class, CmpToMP3FileDriver.class).stream().anyMatch(audio.audioDriverClass::equals)).collect(Collectors.toList());
    }
}

