/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.EventScheduler;
import libsidplay.config.IAudioSection;
import lowlevel.LameEncoder;
import mp3.MPEGMode;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public abstract class JMP3Driver
implements AudioDriver {
    private LameEncoder jump3r;
    protected OutputStream out;
    protected ByteBuffer sampleBuffer;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        AudioConfig cfg = new AudioConfig(audioSection);
        boolean signed = true;
        boolean bigEndian = false;
        AudioFormat audioFormat = new AudioFormat(cfg.getFrameRate(), 16, cfg.getChannels(), signed, bigEndian);
        this.jump3r = new LameEncoder(audioFormat, audioSection.getCbr(), MPEGMode.STEREO, audioSection.getVbrQuality(), audioSection.isVbr());
        this.out = this.getOut(recordingFilename);
        this.sampleBuffer = ByteBuffer.allocate(cfg.getChunkFrames() * 2 * cfg.getChannels()).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void write() throws InterruptedException {
        try {
            byte[] encoded = new byte[this.jump3r.getMP3BufferSize()];
            int bytesWritten = this.jump3r.encodeBuffer(this.sampleBuffer.array(), 0, this.sampleBuffer.position(), encoded);
            this.out.write(encoded, 0, bytesWritten);
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Error writing MP3 audio stream", e);
        }
    }

    @Override
    public void close() {
        if (this.jump3r != null) {
            this.jump3r.close();
        }
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    @Override
    public boolean isRecording() {
        return true;
    }

    @Override
    public String getExtension() {
        return ".mp3";
    }

    protected abstract OutputStream getOut(String var1) throws IOException;

    public static class JMP3StreamDriver
    extends JMP3Driver {
        public JMP3StreamDriver(OutputStream out) {
            this.out = out;
        }

        @Override
        protected OutputStream getOut(String recordingFilename) {
            return this.out;
        }
    }

    public static class JMP3FileDriver
    extends JMP3Driver {
        @Override
        protected OutputStream getOut(String recordingFilename) throws IOException {
            System.out.println("Recording, file=" + recordingFilename);
            return new FileOutputStream(recordingFilename);
        }

        @Override
        public void close() {
            super.close();
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing MP3 audio stream", e);
                }
                finally {
                    this.out = null;
                }
            }
        }
    }
}

