/*
 * Decompiled with CFR 0.152.
 */
package ui.common.properties;

import java.util.function.Function;
import javafx.beans.value.WritableValue;

public class ShadowField<P extends WritableValue<V>, V> {
    private Function<V, P> propertyCreator;
    private V _shadowValue;
    private P property;

    public ShadowField(Function<V, P> propertyCreator, V initialValue) {
        this.propertyCreator = propertyCreator;
        this._shadowValue = initialValue;
    }

    public final V get() {
        return (V)(this.property == null ? this._shadowValue : this.property.getValue());
    }

    public final void set(V value) {
        if (this.property == null) {
            this._shadowValue = value;
        } else {
            this.property.setValue(value);
        }
    }

    public P property() {
        if (this.property == null) {
            this.property = (WritableValue)this.propertyCreator.apply(this._shadowValue);
        }
        return this.property;
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

