/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import com.beust.jcommander.ParametersDelegate;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.input.KeyCode;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import libsidplay.components.keyboard.KeyTableEntry;
import libsidplay.config.IConfig;
import libsidplay.config.IConsoleSection;
import sidplay.ini.IniDefaults;
import sidplay.ini.converter.BeanToStringConverter;
import ui.common.properties.LazyListField;
import ui.common.properties.ObservableLazyListField;
import ui.common.properties.ShadowField;
import ui.entities.config.Assembly64Section;
import ui.entities.config.AudioSection;
import ui.entities.config.C1541Section;
import ui.entities.config.ConsoleSection;
import ui.entities.config.EmulationSection;
import ui.entities.config.FavoritesSection;
import ui.entities.config.FilterSection;
import ui.entities.config.JoystickSection;
import ui.entities.config.KeyTableEntity;
import ui.entities.config.OnlineSection;
import ui.entities.config.PrinterSection;
import ui.entities.config.SidPlay2Section;
import ui.entities.config.ViewEntity;
import ui.entities.config.WhatsSidSection;

@Entity
@Access(value=AccessType.PROPERTY)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class Configuration
implements IConfig {
    public static final List<FilterSection> DEFAULT_FILTERS = IniDefaults.DEFAULT_FILTER_SECTION.stream().map(FilterSection::new).collect(Collectors.toList());
    public static final List<ViewEntity> DEFAULT_VIEWS = Arrays.asList(new ViewEntity("CONSOLE"), new ViewEntity("VIDEO"));
    public static final List<FavoritesSection> DEFAULT_FAVORITES = Arrays.asList(new FavoritesSection());
    public static final List<KeyTableEntity> DEFAULT_KEYCODES = Arrays.asList(KeyTableEntity.of(KeyCode.A.getName(), KeyTableEntry.A), KeyTableEntity.of(KeyCode.BACK_SLASH.getName(), KeyTableEntry.ARROW_LEFT), KeyTableEntity.of(KeyCode.DIGIT1.getName(), KeyTableEntry.ONE), KeyTableEntity.of(KeyCode.DIGIT2.getName(), KeyTableEntry.TWO), KeyTableEntity.of(KeyCode.DIGIT3.getName(), KeyTableEntry.THREE), KeyTableEntity.of(KeyCode.DIGIT4.getName(), KeyTableEntry.FOUR), KeyTableEntity.of(KeyCode.DIGIT5.getName(), KeyTableEntry.FIVE), KeyTableEntity.of(KeyCode.DIGIT6.getName(), KeyTableEntry.SIX), KeyTableEntity.of(KeyCode.DIGIT7.getName(), KeyTableEntry.SEVEN), KeyTableEntity.of(KeyCode.DIGIT8.getName(), KeyTableEntry.EIGHT), KeyTableEntity.of(KeyCode.DIGIT9.getName(), KeyTableEntry.NINE), KeyTableEntity.of(KeyCode.DIGIT0.getName(), KeyTableEntry.ZERO), KeyTableEntity.of(KeyCode.OPEN_BRACKET.getName(), KeyTableEntry.PLUS), KeyTableEntity.of(KeyCode.CLOSE_BRACKET.getName(), KeyTableEntry.MINUS), KeyTableEntity.of(KeyCode.POUND.getName(), KeyTableEntry.POUND), KeyTableEntity.of(KeyCode.HOME.getName(), KeyTableEntry.CLEAR_HOME), KeyTableEntity.of(KeyCode.BACK_SPACE.getName(), KeyTableEntry.INS_DEL), KeyTableEntity.of(KeyCode.Q.getName(), KeyTableEntry.Q), KeyTableEntity.of(KeyCode.W.getName(), KeyTableEntry.W), KeyTableEntity.of(KeyCode.E.getName(), KeyTableEntry.E), KeyTableEntity.of(KeyCode.R.getName(), KeyTableEntry.R), KeyTableEntity.of(KeyCode.T.getName(), KeyTableEntry.T), KeyTableEntity.of(KeyCode.Y.getName(), KeyTableEntry.Y), KeyTableEntity.of(KeyCode.U.getName(), KeyTableEntry.U), KeyTableEntity.of(KeyCode.I.getName(), KeyTableEntry.I), KeyTableEntity.of(KeyCode.O.getName(), KeyTableEntry.O), KeyTableEntity.of(KeyCode.P.getName(), KeyTableEntry.P), KeyTableEntity.of(KeyCode.SEMICOLON.getName(), KeyTableEntry.AT), KeyTableEntity.of(KeyCode.PLUS.getName(), KeyTableEntry.STAR), KeyTableEntity.of(KeyCode.LESS.getName(), KeyTableEntry.ARROW_UP), KeyTableEntity.of(KeyCode.ESCAPE.getName(), KeyTableEntry.RUN_STOP), KeyTableEntity.of(KeyCode.A.getName(), KeyTableEntry.A), KeyTableEntity.of(KeyCode.S.getName(), KeyTableEntry.S), KeyTableEntity.of(KeyCode.D.getName(), KeyTableEntry.D), KeyTableEntity.of(KeyCode.F.getName(), KeyTableEntry.F), KeyTableEntity.of(KeyCode.G.getName(), KeyTableEntry.G), KeyTableEntity.of(KeyCode.H.getName(), KeyTableEntry.H), KeyTableEntity.of(KeyCode.J.getName(), KeyTableEntry.J), KeyTableEntity.of(KeyCode.K.getName(), KeyTableEntry.K), KeyTableEntity.of(KeyCode.L.getName(), KeyTableEntry.L), KeyTableEntity.of(KeyCode.BACK_QUOTE.getName(), KeyTableEntry.COLON), KeyTableEntity.of(KeyCode.QUOTE.getName(), KeyTableEntry.SEMICOLON), KeyTableEntity.of(KeyCode.SLASH.getName(), KeyTableEntry.EQUALS), KeyTableEntity.of(KeyCode.ENTER.getName(), KeyTableEntry.RETURN), KeyTableEntity.of(KeyCode.Z.getName(), KeyTableEntry.Z), KeyTableEntity.of(KeyCode.X.getName(), KeyTableEntry.X), KeyTableEntity.of(KeyCode.C.getName(), KeyTableEntry.C), KeyTableEntity.of(KeyCode.V.getName(), KeyTableEntry.V), KeyTableEntity.of(KeyCode.B.getName(), KeyTableEntry.B), KeyTableEntity.of(KeyCode.N.getName(), KeyTableEntry.N), KeyTableEntity.of(KeyCode.M.getName(), KeyTableEntry.M), KeyTableEntity.of(KeyCode.COMMA.getName(), KeyTableEntry.COMMA), KeyTableEntity.of(KeyCode.PERIOD.getName(), KeyTableEntry.PERIOD), KeyTableEntity.of(KeyCode.MINUS.getName(), KeyTableEntry.SLASH), KeyTableEntity.of(KeyCode.DOWN.getName(), KeyTableEntry.CURSOR_UP_DOWN), KeyTableEntity.of(KeyCode.UP.getName(), KeyTableEntry.CURSOR_UP_DOWN), KeyTableEntity.of(KeyCode.RIGHT.getName(), KeyTableEntry.CURSOR_LEFT_RIGHT), KeyTableEntity.of(KeyCode.LEFT.getName(), KeyTableEntry.CURSOR_LEFT_RIGHT), KeyTableEntity.of(KeyCode.SPACE.getName(), KeyTableEntry.SPACE), KeyTableEntity.of(KeyCode.F1.getName(), KeyTableEntry.F1), KeyTableEntity.of(KeyCode.F3.getName(), KeyTableEntry.F3), KeyTableEntity.of(KeyCode.F5.getName(), KeyTableEntry.F5), KeyTableEntity.of(KeyCode.F7.getName(), KeyTableEntry.F7));
    private Integer id;
    private SidPlay2Section sidplay2 = new SidPlay2Section();
    private OnlineSection online = new OnlineSection();
    private C1541Section c1541 = new C1541Section();
    private PrinterSection printer = new PrinterSection();
    private ConsoleSection consoleSection = new ConsoleSection();
    private JoystickSection joystickSection = new JoystickSection();
    private AudioSection audioSection = new AudioSection();
    @ParametersDelegate
    private EmulationSection emulationSection = new EmulationSection();
    @ParametersDelegate
    private WhatsSidSection whatsSidSection = new WhatsSidSection();
    private ShadowField<StringProperty, String> currentFavorite = new ShadowField<StringProperty, Object>(SimpleStringProperty::new, null);
    private ObservableLazyListField<FavoritesSection> favorites = new ObservableLazyListField();
    private Assembly64Section assembly64Section = new Assembly64Section();
    private ObservableLazyListField<ViewEntity> views = new ObservableLazyListField();
    private LazyListField<FilterSection> filter = new LazyListField();
    private LazyListField<KeyTableEntity> keyCodeMap = new LazyListField();

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @XmlTransient
    @JsonIgnore
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    @Embedded
    public SidPlay2Section getSidplay2Section() {
        return this.sidplay2;
    }

    public void setSidplay2Section(SidPlay2Section sidplay2) {
        this.sidplay2 = sidplay2;
    }

    @Embedded
    public OnlineSection getOnlineSection() {
        return this.online;
    }

    public void setOnlineSection(OnlineSection online) {
        this.online = online;
    }

    @Override
    @Embedded
    public C1541Section getC1541Section() {
        return this.c1541;
    }

    public void setC1541Section(C1541Section c1541) {
        this.c1541 = c1541;
    }

    @Override
    @Embedded
    public PrinterSection getPrinterSection() {
        return this.printer;
    }

    public void setPrinterSection(PrinterSection printer) {
        this.printer = printer;
    }

    @Override
    @Transient
    @XmlTransient
    @JsonIgnore
    public IConsoleSection getConsoleSection() {
        return this.consoleSection;
    }

    public void setConsoleSection(ConsoleSection consoleSection) {
        this.consoleSection = consoleSection;
    }

    @Embedded
    public JoystickSection getJoystickSection() {
        return this.joystickSection;
    }

    public void setJoystickSection(JoystickSection joystick) {
        this.joystickSection = joystick;
    }

    @Override
    @Embedded
    public AudioSection getAudioSection() {
        return this.audioSection;
    }

    public void setAudioSection(AudioSection audio) {
        this.audioSection = audio;
    }

    @Override
    @Embedded
    public EmulationSection getEmulationSection() {
        return this.emulationSection;
    }

    public void setEmulationSection(EmulationSection emulation) {
        this.emulationSection = emulation;
    }

    @Override
    @Embedded
    public WhatsSidSection getWhatsSidSection() {
        return this.whatsSidSection;
    }

    public void setWhatsSidSection(WhatsSidSection whatsSidSection) {
        this.whatsSidSection = whatsSidSection;
    }

    public String getCurrentFavorite() {
        return this.currentFavorite.get();
    }

    public void setCurrentFavorite(String currentFavorite) {
        this.currentFavorite.set(currentFavorite);
    }

    public final StringProperty currentFavoriteProperty() {
        return this.currentFavorite.property();
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<FavoritesSection> getFavorites() {
        return this.favorites.get(() -> new ArrayList<FavoritesSection>(DEFAULT_FAVORITES));
    }

    public void setFavorites(List<FavoritesSection> favorites) {
        this.favorites.set(favorites);
    }

    @Embedded
    public Assembly64Section getAssembly64Section() {
        return this.assembly64Section;
    }

    public void setAssembly64Section(Assembly64Section assembly64Section) {
        this.assembly64Section = assembly64Section;
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<ViewEntity> getViews() {
        return this.views.get(() -> new ArrayList<ViewEntity>(DEFAULT_VIEWS));
    }

    public void setViews(List<ViewEntity> views) {
        this.views.set(views);
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<FilterSection> getFilterSection() {
        return this.filter.get(() -> DEFAULT_FILTERS.stream().map(FilterSection::new).collect(Collectors.toList()));
    }

    public void setFilterSection(List<FilterSection> filter) {
        this.filter.set(filter);
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<KeyTableEntity> getKeyCodeMap() {
        return this.keyCodeMap.get(() -> DEFAULT_KEYCODES.stream().map(KeyTableEntity::new).collect(Collectors.toList()));
    }

    public void setKeyCodeMap(List<KeyTableEntity> keyCodeMap) {
        this.keyCodeMap.set(keyCodeMap);
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

